/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import javax.lang.model.element.ElementKind;

@BugPattern(name="FilesLinesLeak", category=BugPattern.Category.JDK, summary="The stream returned by Files.lines should be closed using try-with-resources", severity=BugPattern.SeverityLevel.ERROR)
public class FilesLinesLeak
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("java.nio.file.Files").named("lines");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (this.inTWR(state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof MemberSelectTree) {
            MemberSelectTree select = (MemberSelectTree)parent;
            StatementTree statement = (StatementTree)state.findEnclosing(new Class[]{StatementTree.class});
            SuggestedFix.Builder fix = SuggestedFix.builder();
            if (statement instanceof VariableTree) {
                VariableTree var = (VariableTree)statement;
                int pos = ((JCTree)((Object)var)).getStartPosition();
                int initPos = ((JCTree)((Object)var.getInitializer())).getStartPosition();
                int eqPos = pos + state.getSourceForNode((Tree)var).substring(0, initPos - pos).lastIndexOf(61);
                fix.replace(eqPos, initPos, String.format(";\ntry (Stream<String> stream = %s) {\n%s =", state.getSourceForNode((Tree)tree), var.getName().toString()));
            } else {
                fix.prefixWith((Tree)statement, String.format("try (Stream<String> stream = %s) {\n", state.getSourceForNode((Tree)tree)));
                fix.replace((Tree)select.getExpression(), "stream");
            }
            fix.replace((Tree)tree, "stream");
            fix.postfixWith((Tree)statement, "}");
            fix.addImport("java.util.stream.Stream");
            description.addFix((Fix)fix.build());
        }
        return description.build();
    }

    private boolean inTWR(VisitorState state) {
        TreePath path = state.getPath().getParentPath();
        while (path.getLeaf().getKind() == Tree.Kind.CONDITIONAL_EXPRESSION) {
            path = path.getParentPath();
        }
        Symbol sym = ASTHelpers.getSymbol((Tree)path.getLeaf());
        return sym != null && sym.getKind() == ElementKind.RESOURCE_VARIABLE;
    }
}

