/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ForkJoinTask;

@BugPattern(name="FutureReturnValueIgnored", summary="Return value of methods returning Future must be checked. Ignoring returned Futures suppresses exceptions thrown from the code that completes the Future.", explanation="Methods that return `java.util.concurrent.Future` and its subclasses generally indicate errors by returning a future that eventually fails.\n\nIf you don\u2019t check the return value of these methods, you will never find out if they threw an exception.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public final class FutureReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final Matcher<ExpressionTree> FORK_JOIN_TASK_FORK = MethodMatchers.instanceMethod().onDescendantOf(ForkJoinTask.class.getName()).named("fork").withParameters(new String[0]);
    private static final Matcher<MethodInvocationTree> MATCHER = new Matcher<MethodInvocationTree>(){

        public boolean matches(MethodInvocationTree tree, VisitorState state) {
            Type futureType = Objects.requireNonNull(state.getTypeFromString("java.util.concurrent.Future"));
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
            if (ASTHelpers.hasAnnotation((Symbol)sym, CanIgnoreReturnValue.class, (VisitorState)state)) {
                return false;
            }
            for (Symbol.MethodSymbol superSym : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)sym, (Types)state.getTypes())) {
                if (!ASTHelpers.hasAnnotation((Symbol)superSym, CanIgnoreReturnValue.class, (VisitorState)state) || !ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)superSym.getReturnType(), (Types)state.getTypes()), (Type)futureType, (VisitorState)state)) continue;
                return false;
            }
            if (FORK_JOIN_TASK_FORK.matches((Tree)tree, state)) {
                return false;
            }
            Type returnType = sym.getReturnType();
            return ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)returnType, (Types)state.getTypes()), (Type)futureType, (VisitorState)state);
        }
    };
    private final Stack<Set<String>> stackNames = new Stack();
    private List<Tree> previousTreePath = new ArrayList<Tree>();

    @Override
    public Matcher<? super MethodInvocationTree> specializedMatcher() {
        return MATCHER;
    }

    @Override
    public Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        return this.describeUnused(methodInvocationTree, state);
    }

    List<Tree> pathToList(TreePath input) {
        ArrayList<Tree> list = new ArrayList<Tree>();
        do {
            list.add(0, input.getLeaf());
        } while ((input = input.getParentPath()) != null);
        return list;
    }

    private String findVariableName(String name, VisitorState state) {
        String identifierName;
        if (this.previousTreePath.size() != this.stackNames.size()) {
            throw new IllegalStateException();
        }
        TreePath currentPath = state.getPath();
        List<Tree> currentPathList = this.pathToList(currentPath);
        for (int i = 0; i < currentPathList.size(); ++i) {
            if (this.previousTreePath.size() > i) {
                if (this.previousTreePath.get(i).equals(currentPathList.get(i))) continue;
                while (this.stackNames.size() > i) {
                    this.stackNames.pop();
                }
                this.stackNames.push(new HashSet());
                continue;
            }
            this.stackNames.push(new HashSet());
        }
        this.previousTreePath = currentPathList;
        if (this.previousTreePath.size() != this.stackNames.size()) {
            throw new IllegalStateException();
        }
        int i = 0;
        while (true) {
            block8: {
                identifierName = i == 0 ? name : name + i;
                for (Set set : this.stackNames) {
                    if (!set.contains(identifierName)) continue;
                    break block8;
                }
                if (FindIdentifiers.findIdent((String)identifierName, (VisitorState)state) == null) break;
            }
            ++i;
        }
        String chosenName = identifierName;
        for (i = this.stackNames.size() - 1; i >= 0; --i) {
            if (!this.declaresVariableScope(currentPathList.get(i).getKind())) continue;
            ((Set)this.stackNames.get(i)).add(chosenName);
            return chosenName;
        }
        throw new IllegalStateException("Didn't find enclosing block");
    }

    boolean declaresVariableScope(Tree.Kind kind) {
        switch (kind) {
            case BLOCK: 
            case METHOD: {
                return true;
            }
        }
        return false;
    }

    public Description describeUnused(MethodInvocationTree methodInvocationTree, VisitorState state) {
        SuggestedFix fix = SuggestedFix.builder().addImport("java.util.concurrent.Future").prefixWith((Tree)methodInvocationTree, String.format("@SuppressWarnings(\"unused\") // go/futurereturn-lsc\nFuture<?> %s = ", this.findVariableName("possiblyIgnoredError", state))).build();
        return this.describeMatch(methodInvocationTree, (Fix)fix);
    }
}

