/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_ImmutableAnalysis_Violation;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.Name;
import java.util.HashMap;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import org.pcollections.ConsPStack;

public class ImmutableAnalysis {
    private final BugChecker bugChecker;
    private final VisitorState state;
    private final String nonFinalFieldMessage;
    private final String mutableFieldMessage;

    public ImmutableAnalysis(BugChecker bugChecker, VisitorState state, String nonFinalFieldMessage, String mutableFieldMessage) {
        this.bugChecker = bugChecker;
        this.state = state;
        this.nonFinalFieldMessage = nonFinalFieldMessage;
        this.mutableFieldMessage = mutableFieldMessage;
    }

    Violation checkForImmutability(Optional<ClassTree> tree, ImmutableSet<String> immutableTyParams, Type.ClassType type) {
        Violation info = this.areFieldsImmutable(tree, immutableTyParams, type);
        if (info.isPresent()) {
            return info;
        }
        for (Type interfaceType : this.state.getTypes().interfaces(type)) {
            ImmutableAnnotationInfo interfaceAnnotation = ImmutableAnalysis.getImmutableAnnotation(interfaceType.tsym);
            if (interfaceAnnotation == null || !(info = this.immutableInstantiation(immutableTyParams, interfaceAnnotation, interfaceType)).isPresent()) continue;
            return info.plus(String.format("'%s' extends '%s'", this.getPrettyName(type.tsym), this.getPrettyName(interfaceType.tsym)));
        }
        info = this.checkSuper(immutableTyParams, type);
        if (info.isPresent()) {
            return info;
        }
        Type mutableEnclosing = this.mutableEnclosingInstance(tree, type);
        if (mutableEnclosing != null) {
            return info.plus(String.format("'%s' has mutable enclosing instance '%s'", this.getPrettyName(type.tsym), mutableEnclosing));
        }
        return Violation.absent();
    }

    private Type mutableEnclosingInstance(Optional<ClassTree> tree, Type.ClassType type) {
        if (tree.isPresent() && !CanBeStaticAnalyzer.referencesOuter((Tree)tree.get(), ASTHelpers.getSymbol((ClassTree)((ClassTree)tree.get())), this.state)) {
            return null;
        }
        Type enclosing = type.getEnclosingType();
        while (!Type.noType.equals(enclosing)) {
            if (ImmutableAnalysis.getImmutableAnnotation(enclosing.tsym) == null && this.isImmutableType((ImmutableSet<String>)ImmutableSet.of(), enclosing).isPresent()) {
                return enclosing;
            }
            enclosing = enclosing.getEnclosingType();
        }
        return null;
    }

    private Violation checkSuper(ImmutableSet<String> immutableTyParams, Type.ClassType type) {
        Type.ClassType superType = (Type.ClassType)this.state.getTypes().supertype(type);
        if (superType.getKind() == TypeKind.NONE || this.state.getTypes().isSameType(this.state.getSymtab().objectType, superType)) {
            return Violation.absent();
        }
        if (WellKnownMutability.isAnnotation(this.state, type)) {
            return Violation.absent();
        }
        ImmutableAnnotationInfo superannotation = ImmutableAnalysis.getImmutableAnnotation(superType.tsym);
        if (superannotation != null) {
            Violation info = this.immutableInstantiation(immutableTyParams, superannotation, superType);
            if (!info.isPresent()) {
                return Violation.absent();
            }
            return info.plus(String.format("'%s' extends '%s'", this.getPrettyName(type.tsym), this.getPrettyName(superType.tsym)));
        }
        Violation info = this.checkForImmutability((Optional<ClassTree>)Optional.absent(), immutableTyParams, superType);
        if (!info.isPresent()) {
            return Violation.absent();
        }
        return info.plus(String.format("'%s' extends '%s'", this.getPrettyName(type.tsym), this.getPrettyName(superType.tsym)));
    }

    Violation areFieldsImmutable(Optional<ClassTree> tree, ImmutableSet<String> immutableTyParams, Type.ClassType classType) {
        Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)classType.tsym;
        if (classSym.members() == null) {
            return Violation.absent();
        }
        Filter<Symbol> instanceFieldFilter = new Filter<Symbol>(){

            public boolean accepts(Symbol symbol) {
                return symbol.getKind() == ElementKind.FIELD && !symbol.isStatic();
            }
        };
        HashMap<Symbol, Tree> declarations = new HashMap<Symbol, Tree>();
        if (tree.isPresent()) {
            for (Tree tree2 : ((ClassTree)tree.get()).getMembers()) {
                Symbol sym = ASTHelpers.getSymbol((Tree)tree2);
                if (sym == null) continue;
                declarations.put(sym, tree2);
            }
        }
        ImmutableList members = ImmutableList.copyOf((Iterable)classSym.members().getSymbols((Filter)instanceFieldFilter)).reverse();
        for (Symbol member : members) {
            Optional memberTree = Optional.fromNullable(declarations.get(member));
            Violation info = this.isFieldImmutable((Optional<Tree>)memberTree, immutableTyParams, classSym, classType, (Symbol.VarSymbol)member);
            if (!info.isPresent()) continue;
            return info;
        }
        return Violation.absent();
    }

    private Violation isFieldImmutable(Optional<Tree> tree, ImmutableSet<String> immutableTyParams, Symbol.ClassSymbol classSym, Type.ClassType classType, Symbol.VarSymbol var) {
        if (this.bugChecker.isSuppressed((Symbol)var)) {
            return Violation.absent();
        }
        if (ASTHelpers.hasAnnotation((Symbol)var, LazyInit.class, (VisitorState)this.state)) {
            return Violation.absent();
        }
        if (!var.getModifiers().contains((Object)Modifier.FINAL)) {
            if (tree.isPresent()) {
                this.state.reportMatch(BugChecker.buildDescriptionFromChecker((Tree)((Tree)tree.get()), (BugChecker)this.bugChecker).setMessage(this.nonFinalFieldMessage).addFix((Fix)SuggestedFixes.addModifiers((Tree)((Tree)tree.get()), (VisitorState)this.state, (Modifier[])new Modifier[]{Modifier.FINAL})).build());
                return Violation.absent();
            }
            return Violation.of(String.format("'%s' has non-final field '%s'", this.getPrettyName(classSym), var.getSimpleName()));
        }
        Type varType = this.state.getTypes().memberType(classType, var);
        Violation info = this.isImmutableType(immutableTyParams, varType);
        if (info.isPresent()) {
            if (tree.isPresent()) {
                this.state.reportMatch(BugChecker.buildDescriptionFromChecker((Tree)((Tree)tree.get()), (BugChecker)this.bugChecker).setMessage(info.plus(this.mutableFieldMessage).message()).build());
                return Violation.absent();
            }
            return info.plus(String.format("'%s' has field '%s' of type '%s'", this.getPrettyName(classSym), var.getSimpleName(), varType));
        }
        return Violation.absent();
    }

    Violation immutableInstantiation(ImmutableSet<String> immutableTyParams, ImmutableAnnotationInfo annotation, Type type) {
        if (!annotation.containerOf().isEmpty() && type.tsym.getTypeParameters().size() != type.getTypeArguments().size()) {
            return Violation.of(String.format("'%s' required immutable instantiation of '%s', but was raw", this.getPrettyName(type.tsym), Joiner.on((String)", ").join(annotation.containerOf())));
        }
        for (int i = 0; i < type.tsym.getTypeParameters().size(); ++i) {
            Type tyarg;
            Violation info;
            Symbol.TypeVariableSymbol typaram = type.tsym.getTypeParameters().get(i);
            if (!annotation.containerOf().contains((Object)((Name)typaram.getSimpleName()).toString()) || !(info = this.isImmutableType(immutableTyParams, tyarg = type.getTypeArguments().get(i))).isPresent()) continue;
            return info.plus(String.format("'%s' was instantiated with mutable type for '%s'", this.getPrettyName(type.tsym), typaram.getSimpleName()));
        }
        return Violation.absent();
    }

    Violation isImmutableType(ImmutableSet<String> immutableTyParams, Type type) {
        return type.accept(new ImmutableTypeVisitor(immutableTyParams), null);
    }

    static ImmutableAnnotationInfo getImmutableAnnotation(Symbol sym) {
        String nameStr = sym.flatName().toString();
        ImmutableAnnotationInfo known = (ImmutableAnnotationInfo)WellKnownMutability.KNOWN_IMMUTABLE.get((Object)nameStr);
        if (known != null) {
            return known;
        }
        Immutable immutable = (Immutable)ASTHelpers.getAnnotation((Symbol)sym, Immutable.class);
        if (immutable == null) {
            return null;
        }
        return ImmutableAnnotationInfo.create(sym.getQualifiedName().toString(), (Iterable<String>)ImmutableList.copyOf((Object[])immutable.containerOf()));
    }

    static ImmutableAnnotationInfo getImmutableAnnotation(Tree tree) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        return sym == null ? null : ImmutableAnalysis.getImmutableAnnotation(sym);
    }

    private String getPrettyName(Symbol sym) {
        if (!sym.getSimpleName().isEmpty()) {
            return sym.getSimpleName().toString();
        }
        if (sym.getKind() == ElementKind.ENUM) {
            return sym.owner.getSimpleName().toString();
        }
        Type superType = this.state.getTypes().supertype(sym.type);
        if (this.state.getTypes().isSameType(superType, this.state.getSymtab().objectType)) {
            superType = (Type)Iterables.getFirst(this.state.getTypes().interfaces(sym.type), (Object)superType);
        }
        return ((Name)superType.tsym.getSimpleName()).toString();
    }

    private class ImmutableTypeVisitor
    extends Types.SimpleVisitor<Violation, Void> {
        private final ImmutableSet<String> immutableTyParams;

        private ImmutableTypeVisitor(ImmutableSet<String> immutableTyParams) {
            this.immutableTyParams = immutableTyParams;
        }

        @Override
        public Violation visitWildcardType(Type.WildcardType type, Void s) {
            return ImmutableAnalysis.this.state.getTypes().wildUpperBound(type).accept(this, null);
        }

        @Override
        public Violation visitArrayType(Type.ArrayType t, Void s) {
            return Violation.of(String.format("arrays are mutable", new Object[0]));
        }

        @Override
        public Violation visitTypeVar(Type.TypeVar type, Void s) {
            Symbol.TypeVariableSymbol tyvar = (Symbol.TypeVariableSymbol)type.tsym;
            if (this.immutableTyParams != null && this.immutableTyParams.contains((Object)((Name)tyvar.getSimpleName()).toString())) {
                return Violation.absent();
            }
            String message = this.immutableTyParams.isEmpty() ? String.format("'%s' is a mutable type variable", tyvar.getSimpleName()) : String.format("'%s' is a mutable type variable (not in '%s')", tyvar.getSimpleName(), Joiner.on((String)", ").join(this.immutableTyParams));
            return Violation.of(message);
        }

        @Override
        public Violation visitType(Type type, Void s) {
            switch (type.tsym.getKind()) {
                case ANNOTATION_TYPE: {
                    return Violation.absent();
                }
                case ENUM: {
                    return Violation.absent();
                }
                case INTERFACE: 
                case CLASS: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unexpected type kind %s", new Object[]{type.tsym.getKind()}));
                }
            }
            if (WellKnownMutability.isAnnotation(ImmutableAnalysis.this.state, type)) {
                return Violation.absent();
            }
            ImmutableAnnotationInfo annotation = ImmutableAnalysis.getImmutableAnnotation(type.tsym);
            if (annotation != null) {
                return ImmutableAnalysis.this.immutableInstantiation(this.immutableTyParams, annotation, type);
            }
            String nameStr = type.tsym.flatName().toString();
            if (WellKnownMutability.KNOWN_UNSAFE.contains((Object)nameStr)) {
                return Violation.of(String.format("'%s' is mutable", type.tsym.getSimpleName()));
            }
            if (WellKnownMutability.isProto2MessageClass(ImmutableAnalysis.this.state, type)) {
                if (WellKnownMutability.isProto2MutableMessageClass(ImmutableAnalysis.this.state, type)) {
                    return Violation.of(String.format("'%s' is a mutable proto message", type.tsym.getSimpleName()));
                }
                return Violation.absent();
            }
            return Violation.of(String.format("the declaration of type '%s' is not annotated @Immutable", type));
        }
    }

    static abstract class Violation {
        Violation() {
        }

        private static Violation create(ConsPStack<String> path) {
            return new AutoValue_ImmutableAnalysis_Violation(path);
        }

        boolean isPresent() {
            return !this.path().isEmpty();
        }

        String message() {
            return Joiner.on((String)", ").join(this.path());
        }

        abstract ConsPStack<String> path();

        Violation plus(String edge) {
            return Violation.create((ConsPStack<String>)this.path().plus((Object)edge));
        }

        static Violation of(String reason) {
            return Violation.create((ConsPStack<String>)ConsPStack.singleton((Object)reason));
        }

        static Violation absent() {
            return Violation.create((ConsPStack<String>)ConsPStack.empty());
        }
    }
}

