/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.DaggerCollections;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;

public final class SetFactory<T>
implements Factory<Set<T>> {
    private static final Factory<Set<Object>> EMPTY_FACTORY = new Factory<Set<Object>>(){

        public Set<Object> get() {
            return Collections.emptySet();
        }
    };
    private final List<Provider<T>> individualProviders;
    private final List<Provider<Collection<T>>> collectionProviders;

    public static <T> Factory<Set<T>> empty() {
        return EMPTY_FACTORY;
    }

    public static <T> Builder<T> builder(int individualProviderSize, int collectionProviderSize) {
        return new Builder(individualProviderSize, collectionProviderSize);
    }

    private SetFactory(List<Provider<T>> individualProviders, List<Provider<Collection<T>>> collectionProviders) {
        this.individualProviders = individualProviders;
        this.collectionProviders = collectionProviders;
    }

    public Set<T> get() {
        int i;
        int size = this.individualProviders.size();
        ArrayList<Collection> providedCollections = new ArrayList<Collection>(this.collectionProviders.size());
        int c = this.collectionProviders.size();
        for (int i2 = 0; i2 < c; ++i2) {
            Collection providedCollection = (Collection)this.collectionProviders.get(i2).get();
            size += providedCollection.size();
            providedCollections.add(providedCollection);
        }
        HashSet providedValues = DaggerCollections.newHashSetWithExpectedSize(size);
        int c2 = this.individualProviders.size();
        for (i = 0; i < c2; ++i) {
            providedValues.add(Preconditions.checkNotNull(this.individualProviders.get(i).get()));
        }
        c2 = providedCollections.size();
        for (i = 0; i < c2; ++i) {
            for (Object element : (Collection)providedCollections.get(i)) {
                providedValues.add(Preconditions.checkNotNull(element));
            }
        }
        return Collections.unmodifiableSet(providedValues);
    }

    public static final class Builder<T> {
        private final List<Provider<T>> individualProviders;
        private final List<Provider<Collection<T>>> collectionProviders;

        private Builder(int individualProviderSize, int collectionProviderSize) {
            this.individualProviders = DaggerCollections.presizedList(individualProviderSize);
            this.collectionProviders = DaggerCollections.presizedList(collectionProviderSize);
        }

        public Builder<T> addProvider(Provider<? extends T> individualProvider) {
            assert (individualProvider != null) : "Codegen error? Null provider";
            this.individualProviders.add(individualProvider);
            return this;
        }

        public Builder<T> addCollectionProvider(Provider<? extends Collection<? extends T>> collectionProvider) {
            assert (collectionProvider != null) : "Codegen error? Null provider";
            this.collectionProviders.add(collectionProvider);
            return this;
        }

        public SetFactory<T> build() {
            assert (!DaggerCollections.hasDuplicates(this.individualProviders)) : "Codegen error?  Duplicates in the provider list";
            assert (!DaggerCollections.hasDuplicates(this.collectionProviders)) : "Codegen error?  Duplicates in the provider list";
            return new SetFactory(this.individualProviders, this.collectionProviders);
        }
    }
}

