/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.util;

public class HashCodeUtils {
    private static int prime = 31;
    private static int seed = 17;

    public static int hash(int hash, boolean item) {
        return hash * prime + (item ? 1 : 0);
    }

    public static int hash(int hash, char item) {
        return hash * prime + item;
    }

    public static int hash(int hash, int item) {
        return hash * prime + item;
    }

    public static int hash(int hash, long item) {
        return hash * prime + (int)(item ^ item >>> 32);
    }

    public static int hash(int hash, float item) {
        return hash * prime + Float.floatToIntBits(item);
    }

    public static int hash(int hash, double item) {
        long l = Double.doubleToLongBits(item);
        return seed * prime + (int)(l ^ l >>> 32);
    }

    public static int hash(int hash, Object item) {
        if (item == null) {
            return hash * prime;
        }
        return hash * prime + item.hashCode();
    }

    public static int hash(boolean item) {
        return item ? 1 : 0;
    }

    public static int hash(char item) {
        return item;
    }

    public static int hash(int item) {
        return item;
    }

    public static int hash(long item) {
        return (int)(item ^ item >>> 32);
    }

    public static int hash(float item) {
        return Float.floatToIntBits(item);
    }

    public static int hash(double item) {
        long l = Double.doubleToLongBits(item);
        return (int)(l ^ l >>> 32);
    }

    public static int hash(Object item) {
        if (item == null) {
            return 0;
        }
        return item.hashCode();
    }

    public static int hash(Object ... items) {
        int result = seed;
        for (Object item : items) {
            result = result * prime + (item == null ? 0 : item.hashCode());
        }
        return result;
    }
}

