/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.Iterators;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class Scope {
    public final Symbol owner;
    private static final Filter<Symbol> noFilter = null;
    ScopeListenerList listeners = new ScopeListenerList();

    protected Scope(Symbol symbol) {
        this.owner = symbol;
    }

    public final Iterable<Symbol> getSymbols() {
        return this.getSymbols(noFilter);
    }

    public final Iterable<Symbol> getSymbols(Filter<Symbol> filter) {
        return this.getSymbols(filter, LookupKind.RECURSIVE);
    }

    public final Iterable<Symbol> getSymbols(LookupKind lookupKind) {
        return this.getSymbols(noFilter, lookupKind);
    }

    public abstract Iterable<Symbol> getSymbols(Filter<Symbol> var1, LookupKind var2);

    public final Iterable<Symbol> getSymbolsByName(Name name) {
        return this.getSymbolsByName(name, LookupKind.RECURSIVE);
    }

    public final Iterable<Symbol> getSymbolsByName(Name name, Filter<Symbol> filter) {
        return this.getSymbolsByName(name, filter, LookupKind.RECURSIVE);
    }

    public final Iterable<Symbol> getSymbolsByName(Name name, LookupKind lookupKind) {
        return this.getSymbolsByName(name, noFilter, lookupKind);
    }

    public abstract Iterable<Symbol> getSymbolsByName(Name var1, Filter<Symbol> var2, LookupKind var3);

    public final Symbol findFirst(Name name) {
        return this.findFirst(name, noFilter);
    }

    public Symbol findFirst(Name name, Filter<Symbol> filter) {
        Iterator<Symbol> iterator = this.getSymbolsByName(name, filter).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public boolean anyMatch(Filter<Symbol> filter) {
        return this.getSymbols(filter, LookupKind.NON_RECURSIVE).iterator().hasNext();
    }

    public boolean includes(Symbol symbol) {
        return this.includes(symbol, LookupKind.RECURSIVE);
    }

    public boolean includes(Symbol symbol, LookupKind lookupKind) {
        return this.getSymbolsByName(symbol.name, symbol2 -> symbol2 == symbol, lookupKind).iterator().hasNext();
    }

    public boolean isEmpty() {
        return !this.getSymbols(LookupKind.NON_RECURSIVE).iterator().hasNext();
    }

    public abstract Scope getOrigin(Symbol var1);

    public abstract boolean isStaticallyImported(Symbol var1);

    public static class ErrorScope
    extends ScopeImpl {
        ErrorScope(ScopeImpl scopeImpl, Symbol symbol, Entry[] entryArray) {
            super(scopeImpl, symbol, entryArray);
        }

        public ErrorScope(Symbol symbol) {
            super(symbol);
        }

        @Override
        public WriteableScope dup(Symbol symbol) {
            return new ErrorScope(this, symbol, this.table);
        }

        @Override
        public WriteableScope dupUnshared(Symbol symbol) {
            return new ErrorScope(this, symbol, (Entry[])this.table.clone());
        }

        @Override
        public Entry lookup(Name name) {
            Entry entry = super.lookup(name);
            if (entry.scope == null) {
                return new Entry(this.owner, null, null, null);
            }
            return entry;
        }
    }

    public static class CompoundScope
    extends Scope
    implements ScopeListener {
        List<Scope> subScopes = List.nil();
        private int mark = 0;

        public CompoundScope(Symbol symbol) {
            super(symbol);
        }

        public void prependSubScope(Scope scope) {
            if (scope != null) {
                this.subScopes = this.subScopes.prepend(scope);
                scope.listeners.add(this);
                ++this.mark;
                this.listeners.symbolAdded(null, this);
            }
        }

        @Override
        public void symbolAdded(Symbol symbol, Scope scope) {
            ++this.mark;
            this.listeners.symbolAdded(symbol, scope);
        }

        @Override
        public void symbolRemoved(Symbol symbol, Scope scope) {
            ++this.mark;
            this.listeners.symbolRemoved(symbol, scope);
        }

        public int getMark() {
            return this.mark;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CompoundScope{");
            String string = "";
            for (Scope scope : this.subScopes) {
                stringBuilder.append(string);
                stringBuilder.append(scope);
                string = ",";
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        @Override
        public Iterable<Symbol> getSymbols(Filter<Symbol> filter, LookupKind lookupKind) {
            return () -> Iterators.createCompoundIterator(this.subScopes, scope -> scope.getSymbols(filter, lookupKind).iterator());
        }

        @Override
        public Iterable<Symbol> getSymbolsByName(Name name, Filter<Symbol> filter, LookupKind lookupKind) {
            return () -> Iterators.createCompoundIterator(this.subScopes, scope -> scope.getSymbolsByName(name, filter, lookupKind).iterator());
        }

        @Override
        public Scope getOrigin(Symbol symbol) {
            for (Scope scope : this.subScopes) {
                if (!scope.includes(symbol)) continue;
                return scope.getOrigin(symbol);
            }
            return null;
        }

        @Override
        public boolean isStaticallyImported(Symbol symbol) {
            for (Scope scope : this.subScopes) {
                if (!scope.includes(symbol)) continue;
                return scope.isStaticallyImported(symbol);
            }
            return false;
        }
    }

    private static class FilterImportScope
    extends Scope {
        private final Types types;
        private final Scope origin;
        private final Name filterName;
        private final ImportFilter filter;
        private final JCTree.JCImport imp;
        private final BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> cfHandler;

        public FilterImportScope(Types types, Scope scope, Name name, ImportFilter importFilter, JCTree.JCImport jCImport, BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> biConsumer) {
            super(scope.owner);
            this.types = types;
            this.origin = scope;
            this.filterName = name;
            this.filter = importFilter;
            this.imp = jCImport;
            this.cfHandler = biConsumer;
        }

        @Override
        public Iterable<Symbol> getSymbols(final Filter<Symbol> filter, final LookupKind lookupKind) {
            if (this.filterName != null) {
                return this.getSymbolsByName(this.filterName, filter, lookupKind);
            }
            try {
                SymbolImporter symbolImporter = new SymbolImporter(this.imp.staticImport){

                    @Override
                    Iterable<Symbol> doLookup(Symbol.TypeSymbol typeSymbol) {
                        return typeSymbol.members().getSymbols(filter, lookupKind);
                    }
                };
                return symbolImporter.importFrom((Symbol.TypeSymbol)this.origin.owner)::iterator;
            }
            catch (Symbol.CompletionFailure completionFailure) {
                this.cfHandler.accept(this.imp, completionFailure);
                return Collections.emptyList();
            }
        }

        @Override
        public Iterable<Symbol> getSymbolsByName(final Name name, final Filter<Symbol> filter, final LookupKind lookupKind) {
            if (this.filterName != null && this.filterName != name) {
                return Collections.emptyList();
            }
            try {
                SymbolImporter symbolImporter = new SymbolImporter(this.imp.staticImport){

                    @Override
                    Iterable<Symbol> doLookup(Symbol.TypeSymbol typeSymbol) {
                        return typeSymbol.members().getSymbolsByName(name, filter, lookupKind);
                    }
                };
                return symbolImporter.importFrom((Symbol.TypeSymbol)this.origin.owner)::iterator;
            }
            catch (Symbol.CompletionFailure completionFailure) {
                this.cfHandler.accept(this.imp, completionFailure);
                return Collections.emptyList();
            }
        }

        @Override
        public Scope getOrigin(Symbol symbol) {
            return this.origin;
        }

        @Override
        public boolean isStaticallyImported(Symbol symbol) {
            return this.imp.staticImport;
        }

        abstract class SymbolImporter {
            Set<Symbol> processed = new HashSet<Symbol>();
            List<Iterable<Symbol>> delegates = List.nil();
            final boolean inspectSuperTypes;

            public SymbolImporter(boolean bl) {
                this.inspectSuperTypes = bl;
            }

            Stream<Symbol> importFrom(Symbol.TypeSymbol typeSymbol) {
                if (typeSymbol == null || !this.processed.add(typeSymbol)) {
                    return Stream.empty();
                }
                Stream<Object> stream = Stream.empty();
                if (this.inspectSuperTypes) {
                    stream = this.importFrom(((FilterImportScope)FilterImportScope.this).types.supertype((Type)typeSymbol.type).tsym);
                    for (Type type : FilterImportScope.this.types.interfaces(typeSymbol.type)) {
                        stream = Stream.concat(this.importFrom(type.tsym), stream);
                    }
                }
                return Stream.concat(StreamSupport.stream(this.doLookup(typeSymbol).spliterator(), false).filter(symbol -> FilterImportScope.this.filter.accepts(FilterImportScope.this.origin, (Symbol)symbol)), stream);
            }

            abstract Iterable<Symbol> doLookup(Symbol.TypeSymbol var1);
        }
    }

    public static interface ImportFilter {
        public boolean accepts(Scope var1, Symbol var2);
    }

    public static class StarImportScope
    extends ImportScope {
        public StarImportScope(Symbol symbol) {
            super(symbol);
        }

        public void importAll(Types types, Scope scope, ImportFilter importFilter, JCTree.JCImport jCImport, BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> biConsumer) {
            for (Scope scope2 : this.subScopes) {
                Assert.check(scope2 instanceof FilterImportScope);
                FilterImportScope filterImportScope = (FilterImportScope)scope2;
                if (filterImportScope.origin != scope || filterImportScope.filter != importFilter || ((FilterImportScope)filterImportScope).imp.staticImport != jCImport.staticImport) continue;
                return;
            }
            this.prependSubScope(new FilterImportScope(types, scope, null, importFilter, jCImport, biConsumer));
        }

        public boolean isFilled() {
            return this.subScopes.nonEmpty();
        }
    }

    public static class NamedImportScope
    extends ImportScope {
        public NamedImportScope(Symbol symbol, Scope scope) {
            super(symbol);
            this.prependSubScope(scope);
        }

        public Scope importByName(Types types, Scope scope, Name name, ImportFilter importFilter, JCTree.JCImport jCImport, BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> biConsumer) {
            return this.appendScope(new FilterImportScope(types, scope, name, importFilter, jCImport, biConsumer));
        }

        public Scope importType(Scope scope, Scope scope2, Symbol symbol) {
            return this.appendScope(new SingleEntryScope(scope.owner, symbol, scope2));
        }

        private Scope appendScope(Scope scope) {
            List list = this.subScopes.reverse();
            this.subScopes = List.of(list.head);
            this.subScopes = this.subScopes.prepend(scope);
            for (Scope scope2 : list.tail) {
                this.subScopes = this.subScopes.prepend(scope2);
            }
            return scope;
        }

        private static class SingleEntryScope
        extends Scope {
            private final Symbol sym;
            private final List<Symbol> content;
            private final Scope origin;

            public SingleEntryScope(Symbol symbol, Symbol symbol2, Scope scope) {
                super(symbol);
                this.sym = symbol2;
                this.content = List.of(symbol2);
                this.origin = scope;
            }

            @Override
            public Iterable<Symbol> getSymbols(Filter<Symbol> filter, LookupKind lookupKind) {
                return filter == null || filter.accepts(this.sym) ? this.content : Collections.emptyList();
            }

            @Override
            public Iterable<Symbol> getSymbolsByName(Name name, Filter<Symbol> filter, LookupKind lookupKind) {
                return this.sym.name == name && (filter == null || filter.accepts(this.sym)) ? this.content : Collections.emptyList();
            }

            @Override
            public Scope getOrigin(Symbol symbol) {
                return this.sym == symbol ? this.origin : null;
            }

            @Override
            public boolean isStaticallyImported(Symbol symbol) {
                return false;
            }
        }
    }

    public static class ImportScope
    extends CompoundScope {
        public ImportScope(Symbol symbol) {
            super(symbol);
        }

        public void finalizeScope() {
            List list = this.subScopes;
            while (list.nonEmpty()) {
                Scope scope = (Scope)list.head;
                if (scope instanceof FilterImportScope && scope.owner.kind == Kinds.Kind.TYP) {
                    WriteableScope writeableScope = WriteableScope.create(scope.owner);
                    for (Symbol symbol : scope.getSymbols()) {
                        writeableScope.enter(symbol);
                    }
                    writeableScope.listeners.add(new ScopeListener(){

                        @Override
                        public void symbolAdded(Symbol symbol, Scope scope) {
                            Assert.error("The scope is sealed.");
                        }

                        @Override
                        public void symbolRemoved(Symbol symbol, Scope scope) {
                            Assert.error("The scope is sealed.");
                        }
                    });
                    list.head = writeableScope;
                }
                list = list.tail;
            }
        }
    }

    private static class Entry {
        public Symbol sym;
        private Entry shadowed;
        public Entry sibling;
        public ScopeImpl scope;

        public Entry(Symbol symbol, Entry entry, Entry entry2, ScopeImpl scopeImpl) {
            this.sym = symbol;
            this.shadowed = entry;
            this.sibling = entry2;
            this.scope = scopeImpl;
        }

        public Entry next() {
            return this.shadowed;
        }

        public Entry next(Filter<Symbol> filter) {
            if (this.shadowed.sym == null || filter == null || filter.accepts(this.shadowed.sym)) {
                return this.shadowed;
            }
            return this.shadowed.next(filter);
        }
    }

    private static class ScopeImpl
    extends WriteableScope {
        private int shared;
        public ScopeImpl next;
        Entry[] table;
        int hashMask;
        public Entry elems;
        int nelems = 0;
        int removeCount = 0;
        private static final Entry sentinel = new Entry(null, null, null, null);
        private static final int INITIAL_SIZE = 16;

        private ScopeImpl(ScopeImpl scopeImpl, Symbol symbol, Entry[] entryArray) {
            super(symbol);
            this.next = scopeImpl;
            Assert.check(symbol != null);
            this.table = entryArray;
            this.hashMask = entryArray.length - 1;
        }

        private ScopeImpl(ScopeImpl scopeImpl, Symbol symbol, Entry[] entryArray, int n) {
            this(scopeImpl, symbol, entryArray);
            this.nelems = n;
        }

        public ScopeImpl(Symbol symbol) {
            this(null, symbol, new Entry[16]);
        }

        @Override
        public WriteableScope dup(Symbol symbol) {
            ScopeImpl scopeImpl = new ScopeImpl(this, symbol, this.table, this.nelems);
            ++this.shared;
            return scopeImpl;
        }

        @Override
        public WriteableScope dupUnshared(Symbol symbol) {
            if (this.shared > 0) {
                Set set = Collections.newSetFromMap(new IdentityHashMap());
                ScopeImpl scopeImpl = this;
                while (scopeImpl != null) {
                    set.add(scopeImpl);
                    scopeImpl = scopeImpl.next;
                }
                int n = 0;
                Entry[] entryArray = this.table;
                Entry[] entryArray2 = new Entry[this.table.length];
                for (int i = 0; i < entryArray.length; ++i) {
                    Entry entry = entryArray[i];
                    while (entry != null && entry != sentinel && !set.contains(entry.scope)) {
                        entry = entry.shadowed;
                    }
                    if (entry == null) continue;
                    ++n;
                    entryArray2[i] = entry;
                }
                return new ScopeImpl(this, symbol, entryArray2, n);
            }
            return new ScopeImpl(this, symbol, (Entry[])this.table.clone(), this.nelems);
        }

        @Override
        public WriteableScope leave() {
            Assert.check(this.shared == 0);
            if (this.table != this.next.table) {
                return this.next;
            }
            while (this.elems != null) {
                int n = this.getIndex(this.elems.sym.name);
                Entry entry = this.table[n];
                Assert.check(entry == this.elems, this.elems.sym);
                this.table[n] = this.elems.shadowed;
                this.elems = this.elems.sibling;
            }
            Assert.check(this.next.shared > 0);
            --this.next.shared;
            this.next.nelems = this.nelems;
            return this.next;
        }

        private void dble() {
            Assert.check(this.shared == 0);
            Entry[] entryArray = this.table;
            Entry[] entryArray2 = new Entry[entryArray.length * 2];
            ScopeImpl scopeImpl = this;
            while (scopeImpl != null) {
                if (scopeImpl.table == entryArray) {
                    Assert.check(scopeImpl == this || scopeImpl.shared != 0);
                    scopeImpl.table = entryArray2;
                    scopeImpl.hashMask = entryArray2.length - 1;
                }
                scopeImpl = scopeImpl.next;
            }
            int n = 0;
            int n2 = entryArray.length;
            while (--n2 >= 0) {
                Entry entry = entryArray[n2];
                if (entry == null || entry == sentinel) continue;
                this.table[this.getIndex((Name)entry.sym.name)] = entry;
                ++n;
            }
            this.nelems = n;
        }

        @Override
        public void enter(Symbol symbol) {
            Entry entry;
            int n;
            Entry entry2;
            Assert.check(this.shared == 0);
            if (this.nelems * 3 >= this.hashMask * 2) {
                this.dble();
            }
            if ((entry2 = this.table[n = this.getIndex(symbol.name)]) == null) {
                entry2 = sentinel;
                ++this.nelems;
            }
            this.table[n] = entry = new Entry(symbol, entry2, this.elems, this);
            this.elems = entry;
            this.listeners.symbolAdded(symbol, this);
        }

        @Override
        public void remove(Symbol symbol) {
            Assert.check(this.shared == 0);
            Entry entry = this.lookup(symbol.name, symbol2 -> symbol2 == symbol);
            if (entry.scope == null) {
                return;
            }
            int n = this.getIndex(symbol.name);
            Entry entry2 = this.table[n];
            if (entry2 == entry) {
                this.table[n] = entry.shadowed;
            } else {
                while (true) {
                    if (entry2.shadowed == entry) {
                        entry2.shadowed = entry.shadowed;
                        break;
                    }
                    entry2 = entry2.shadowed;
                }
            }
            entry2 = this.elems;
            if (entry2 == entry) {
                this.elems = entry.sibling;
            } else {
                while (true) {
                    if (entry2.sibling == entry) {
                        entry2.sibling = entry.sibling;
                        break;
                    }
                    entry2 = entry2.sibling;
                }
            }
            ++this.removeCount;
            this.listeners.symbolRemoved(symbol, this);
        }

        @Override
        public void enterIfAbsent(Symbol symbol) {
            Assert.check(this.shared == 0);
            Entry entry = this.lookup(symbol.name);
            while (entry.scope == this && entry.sym.kind != symbol.kind) {
                entry = entry.next();
            }
            if (entry.scope != this) {
                this.enter(symbol);
            }
        }

        @Override
        public boolean includes(Symbol symbol) {
            Entry entry = this.lookup(symbol.name);
            while (entry.scope == this) {
                if (entry.sym == symbol) {
                    return true;
                }
                entry = entry.next();
            }
            return false;
        }

        protected Entry lookup(Name name) {
            return this.lookup(name, noFilter);
        }

        protected Entry lookup(Name name, Filter<Symbol> filter) {
            Entry entry = this.table[this.getIndex(name)];
            if (entry == null || entry == sentinel) {
                return sentinel;
            }
            while (entry.scope != null && (entry.sym.name != name || filter != null && !filter.accepts(entry.sym))) {
                entry = entry.shadowed;
            }
            return entry;
        }

        @Override
        public Symbol findFirst(Name name, Filter<Symbol> filter) {
            return this.lookup((Name)name, filter).sym;
        }

        int getIndex(Name name) {
            int n = name.hashCode();
            int n2 = n & this.hashMask;
            int n3 = this.hashMask - (n + (n >> 16) << 1);
            int n4 = -1;
            Entry entry;
            while ((entry = this.table[n2]) != null) {
                if (entry == sentinel) {
                    if (n4 < 0) {
                        n4 = n2;
                    }
                } else if (entry.sym.name == name) {
                    return n2;
                }
                n2 = n2 + n3 & this.hashMask;
            }
            return n4 >= 0 ? n4 : n2;
        }

        @Override
        public boolean anyMatch(Filter<Symbol> filter) {
            return this.getSymbols(filter, LookupKind.NON_RECURSIVE).iterator().hasNext();
        }

        @Override
        public Iterable<Symbol> getSymbols(final Filter<Symbol> filter, final LookupKind lookupKind) {
            return () -> new Iterator<Symbol>(){
                private ScopeImpl currScope;
                private Entry currEntry;
                private int seenRemoveCount;
                {
                    this.currScope = this;
                    this.currEntry = elems;
                    this.seenRemoveCount = this.currScope.removeCount;
                    this.update();
                }

                @Override
                public boolean hasNext() {
                    if (this.seenRemoveCount != this.currScope.removeCount && this.currEntry != null && !this.currEntry.scope.includes(this.currEntry.sym)) {
                        this.doNext();
                        this.seenRemoveCount = this.currScope.removeCount;
                    }
                    return this.currEntry != null;
                }

                @Override
                public Symbol next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.doNext();
                }

                private Symbol doNext() {
                    Symbol symbol;
                    Symbol symbol2 = symbol = this.currEntry == null ? null : this.currEntry.sym;
                    if (this.currEntry != null) {
                        this.currEntry = this.currEntry.sibling;
                    }
                    this.update();
                    return symbol;
                }

                private void update() {
                    this.skipToNextMatchingEntry();
                    if (lookupKind == LookupKind.RECURSIVE) {
                        while (this.currEntry == null && this.currScope.next != null) {
                            this.currScope = this.currScope.next;
                            this.currEntry = this.currScope.elems;
                            this.seenRemoveCount = this.currScope.removeCount;
                            this.skipToNextMatchingEntry();
                        }
                    }
                }

                void skipToNextMatchingEntry() {
                    while (this.currEntry != null && filter != null && !filter.accepts(this.currEntry.sym)) {
                        this.currEntry = this.currEntry.sibling;
                    }
                }
            };
        }

        @Override
        public Iterable<Symbol> getSymbolsByName(final Name name, final Filter<Symbol> filter, final LookupKind lookupKind) {
            return () -> new Iterator<Symbol>(){
                Entry currentEntry;
                int seenRemoveCount;
                {
                    this.currentEntry = this.lookup(name, filter);
                    this.seenRemoveCount = this.currentEntry.scope != null ? this.currentEntry.scope.removeCount : -1;
                }

                @Override
                public boolean hasNext() {
                    if (this.currentEntry.scope != null && this.seenRemoveCount != this.currentEntry.scope.removeCount && !this.currentEntry.scope.includes(this.currentEntry.sym)) {
                        this.doNext();
                    }
                    return this.currentEntry.scope != null && (lookupKind == LookupKind.RECURSIVE || this.currentEntry.scope == this);
                }

                @Override
                public Symbol next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.doNext();
                }

                private Symbol doNext() {
                    Entry entry = this.currentEntry;
                    this.currentEntry = this.currentEntry.next(filter);
                    return entry.sym;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Scope getOrigin(Symbol symbol) {
            Entry entry = this.lookup(symbol.name);
            while (entry.scope != null) {
                if (entry.sym == symbol) {
                    return this;
                }
                entry = entry.next();
            }
            return null;
        }

        @Override
        public boolean isStaticallyImported(Symbol symbol) {
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Scope[");
            ScopeImpl scopeImpl = this;
            while (scopeImpl != null) {
                if (scopeImpl != this) {
                    stringBuilder.append(" | ");
                }
                Entry entry = scopeImpl.elems;
                while (entry != null) {
                    if (entry != scopeImpl.elems) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(entry.sym);
                    entry = entry.sibling;
                }
                scopeImpl = scopeImpl.next;
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static abstract class WriteableScope
    extends Scope {
        public WriteableScope(Symbol symbol) {
            super(symbol);
        }

        public abstract void enter(Symbol var1);

        public abstract void enterIfAbsent(Symbol var1);

        public abstract void remove(Symbol var1);

        public final WriteableScope dup() {
            return this.dup(this.owner);
        }

        public abstract WriteableScope dup(Symbol var1);

        public abstract WriteableScope leave();

        public final WriteableScope dupUnshared() {
            return this.dupUnshared(this.owner);
        }

        public abstract WriteableScope dupUnshared(Symbol var1);

        public static WriteableScope create(Symbol symbol) {
            return new ScopeImpl(symbol);
        }
    }

    public static enum LookupKind {
        RECURSIVE,
        NON_RECURSIVE;

    }

    public static class ScopeListenerList {
        List<WeakReference<ScopeListener>> listeners = List.nil();

        void add(ScopeListener scopeListener) {
            this.listeners = this.listeners.prepend(new WeakReference<ScopeListener>(scopeListener));
        }

        void symbolAdded(Symbol symbol, Scope scope) {
            this.walkReferences(symbol, scope, false);
        }

        void symbolRemoved(Symbol symbol, Scope scope) {
            this.walkReferences(symbol, scope, true);
        }

        private void walkReferences(Symbol symbol, Scope scope, boolean bl) {
            ListBuffer<WeakReference<ScopeListener>> listBuffer = new ListBuffer<WeakReference<ScopeListener>>();
            for (WeakReference<ScopeListener> weakReference : this.listeners) {
                ScopeListener scopeListener = (ScopeListener)weakReference.get();
                if (scopeListener == null) continue;
                if (bl) {
                    scopeListener.symbolRemoved(symbol, scope);
                } else {
                    scopeListener.symbolAdded(symbol, scope);
                }
                listBuffer.add(weakReference);
            }
            this.listeners = listBuffer.toList();
        }
    }

    public static interface ScopeListener {
        public void symbolAdded(Symbol var1, Scope var2);

        public void symbolRemoved(Symbol var1, Scope var2);
    }
}

