/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Node;
import lombok.ast.Statement;

public class Synchronized
extends AbstractNode
implements Statement {
    private AbstractNode lock = null;
    private AbstractNode body = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Expression astLock() {
        if (!(this.lock instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.lock);
    }

    public Synchronized astLock(Expression lock) {
        if (lock == null) {
            throw new NullPointerException("lock is mandatory");
        }
        return this.rawLock(lock);
    }

    public Node rawLock() {
        return this.lock;
    }

    public Synchronized rawLock(Node lock) {
        if (lock == this.lock) {
            return this;
        }
        if (lock != null) {
            this.adopt((AbstractNode)lock);
        }
        if (this.lock != null) {
            this.disown(this.lock);
        }
        this.lock = (AbstractNode)lock;
        return this;
    }

    public Block astBody() {
        if (!(this.body instanceof Block)) {
            return null;
        }
        return (Block)this.body;
    }

    public Synchronized astBody(Block body) {
        if (body == null) {
            throw new NullPointerException("body is mandatory");
        }
        return this.rawBody(body);
    }

    public Node rawBody() {
        return this.body;
    }

    public Synchronized rawBody(Node body) {
        if (body == this.body) {
            return this;
        }
        if (body != null) {
            this.adopt((AbstractNode)body);
        }
        if (this.body != null) {
            this.disown(this.body);
        }
        this.body = (AbstractNode)body;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.lock != null) {
            result.add(this.lock);
        }
        if (this.body != null) {
            result.add(this.body);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.lock == original) {
            this.rawLock(replacement);
            return true;
        }
        if (this.body == original) {
            this.rawBody(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.lock == child) {
            this.disown((AbstractNode)child);
            this.lock = null;
            return true;
        }
        if (this.body == child) {
            this.disown((AbstractNode)child);
            this.body = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitSynchronized(this)) {
            return;
        }
        if (this.lock != null) {
            this.lock.accept(visitor);
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
        visitor.afterVisitSynchronized(this);
        visitor.endVisit(this);
    }

    @Override
    public Synchronized copy() {
        Synchronized result = new Synchronized();
        if (this.lock != null) {
            result.rawLock(this.lock.copy());
        }
        if (this.body != null) {
            result.rawBody(this.body.copy());
        }
        return result;
    }
}

