/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.diag;

import com.google.common.collect.ImmutableList;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineDiagnostic;
import com.google.turbine.diag.TurbineError;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.tools.Diagnostic;

public class TurbineLog {
    private final Set<TurbineDiagnostic> errors = new LinkedHashSet<TurbineDiagnostic>();

    public TurbineLogWithSource withSource(SourceFile source) {
        return new TurbineLogWithSource(source);
    }

    public void maybeThrow() {
        if (this.anyErrors()) {
            throw new TurbineError((ImmutableList<TurbineDiagnostic>)ImmutableList.copyOf(this.errors));
        }
    }

    private boolean anyErrors() {
        for (TurbineDiagnostic error : this.errors) {
            if (!error.severity().equals((Object)Diagnostic.Kind.ERROR)) continue;
            return true;
        }
        return false;
    }

    public boolean errorRaised() {
        for (TurbineDiagnostic error : this.errors) {
            if (!error.kind().equals((Object)TurbineError.ErrorKind.PROC) || !error.severity().equals((Object)Diagnostic.Kind.ERROR)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.errors.clear();
    }

    public void diagnostic(Diagnostic.Kind severity, String message) {
        this.errors.add(TurbineDiagnostic.format(severity, TurbineError.ErrorKind.PROC, message));
    }

    public class TurbineLogWithSource {
        private final SourceFile source;

        private TurbineLogWithSource(SourceFile source) {
            this.source = source;
        }

        public void diagnostic(Diagnostic.Kind severity, int position, TurbineError.ErrorKind kind, Object ... args) {
            TurbineLog.this.errors.add(TurbineDiagnostic.format(severity, this.source, position, kind, args));
        }

        public void error(int position, TurbineError.ErrorKind kind, Object ... args) {
            this.diagnostic(Diagnostic.Kind.ERROR, position, kind, args);
        }
    }
}

