/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.turbine.diag.TurbineLog;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineElements;
import com.google.turbine.processing.TurbineMessager;
import com.google.turbine.processing.TurbineTypes;
import java.util.Locale;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;

public class TurbineProcessingEnvironment
implements ProcessingEnvironment {
    private final Filer filer;
    private final TurbineTypes turbineTypes;
    private final Map<String, String> processorOptions;
    private final TurbineElements turbineElements;
    private final SourceVersion sourceVersion;
    private final Messager messager;

    public TurbineProcessingEnvironment(ModelFactory factory, Filer filer, TurbineLog log, Map<String, String> processorOptions, SourceVersion sourceVersion) {
        this.filer = filer;
        this.turbineTypes = new TurbineTypes(factory);
        this.processorOptions = processorOptions;
        this.sourceVersion = sourceVersion;
        this.turbineElements = new TurbineElements(factory, this.turbineTypes);
        this.messager = new TurbineMessager(factory, log);
    }

    @Override
    public Map<String, String> getOptions() {
        return this.processorOptions;
    }

    @Override
    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public Filer getFiler() {
        return this.filer;
    }

    @Override
    public TurbineElements getElementUtils() {
        return this.turbineElements;
    }

    @Override
    public TurbineTypes getTypeUtils() {
        return this.turbineTypes;
    }

    @Override
    public SourceVersion getSourceVersion() {
        return this.sourceVersion;
    }

    @Override
    public Locale getLocale() {
        return Locale.ENGLISH;
    }
}

