/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Floats;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class PrimitiveFloatArraySubject
extends AbstractArraySubject<PrimitiveFloatArraySubject, float[]> {
    private final float[] actual;
    private static final Correspondence<Float, Number> EXACT_EQUALITY_CORRESPONDENCE = Correspondence.from(new Correspondence.BinaryPredicate<Float, Number>(){

        @Override
        public boolean apply(Float actual, Number expected) {
            return Float.floatToIntBits(actual.floatValue()) == Float.floatToIntBits(PrimitiveFloatArraySubject.checkedToFloat(expected));
        }
    }, "is exactly equal to");

    PrimitiveFloatArraySubject(FailureMetadata metadata, @NullableDecl float[] o, @NullableDecl String typeDescription) {
        super(metadata, o, typeDescription);
        this.actual = o;
    }

    @Override
    public void isEqualTo(Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    public void isNotEqualTo(Object expected) {
        super.isNotEqualTo(expected);
    }

    public FloatArrayAsIterable usingTolerance(double tolerance) {
        return new FloatArrayAsIterable(Correspondence.tolerance(tolerance), this.iterableSubject());
    }

    private static float checkedToFloat(Number expected) {
        Preconditions.checkNotNull((Object)expected);
        Preconditions.checkArgument((!(expected instanceof Double) ? 1 : 0) != 0, (Object)"Expected value in assertion using exact float equality was a double, which is not supported as a double may not have an exact float representation");
        Preconditions.checkArgument((expected instanceof Float || expected instanceof Integer || expected instanceof Long ? 1 : 0) != 0, (String)"Expected value in assertion using exact float equality was of unsupported type %s (it may not have an exact float representation)", expected.getClass());
        if (expected instanceof Integer) {
            Preconditions.checkArgument((Math.abs((Integer)expected) <= 0x1000000 ? 1 : 0) != 0, (String)"Expected value %s in assertion using exact float equality was an int with an absolute value greater than 2^24 which has no exact float representation", (Object)expected);
        }
        if (expected instanceof Long) {
            Preconditions.checkArgument((Math.abs((Long)expected) <= 0x1000000L ? 1 : 0) != 0, (String)"Expected value %s in assertion using exact float equality was a long with an absolute value greater than 2^24 which has no exact float representation", (Object)expected);
        }
        return expected.floatValue();
    }

    public FloatArrayAsIterable usingExactEquality() {
        return new FloatArrayAsIterable(EXACT_EQUALITY_CORRESPONDENCE, this.iterableSubject());
    }

    private IterableSubject iterableSubject() {
        return this.checkNoNeedToDisplayBothValues("asList()", new Object[0]).about(this.iterablesWithCustomFloatToString()).that(Floats.asList((float[])this.actual));
    }

    private Subject.Factory<IterableSubject, Iterable<?>> iterablesWithCustomFloatToString() {
        return new Subject.Factory<IterableSubject, Iterable<?>>(){

            @Override
            public IterableSubject createSubject(FailureMetadata metadata, Iterable<?> actual) {
                return new IterableSubjectWithInheritedToString(metadata, actual);
            }
        };
    }

    private final class IterableSubjectWithInheritedToString
    extends IterableSubject {
        IterableSubjectWithInheritedToString(FailureMetadata metadata, Iterable<?> actual) {
            super(metadata, actual);
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return PrimitiveFloatArraySubject.this.actualCustomStringRepresentationForPackageMembersToCall();
        }
    }

    public static final class FloatArrayAsIterable
    extends IterableSubject.UsingCorrespondence<Float, Number> {
        FloatArrayAsIterable(Correspondence<? super Float, Number> correspondence, IterableSubject subject) {
            super(subject, correspondence);
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeast(float[] expected) {
            return this.containsAtLeastElementsIn(Floats.asList((float[])expected));
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Ordered containsAllOf(float[] expected) {
            return this.containsAtLeast(expected);
        }

        public void containsAnyOf(float[] expected) {
            this.containsAnyIn(Floats.asList((float[])expected));
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(float[] expected) {
            return this.containsExactlyElementsIn(Floats.asList((float[])expected));
        }

        public void containsNoneOf(float[] excluded) {
            this.containsNoneIn(Floats.asList((float[])excluded));
        }
    }

    public static abstract class TolerantPrimitiveFloatArrayComparison {
        private TolerantPrimitiveFloatArrayComparison() {
        }

        public void of(float ... expected) {
            this.ofElementsIn(Floats.asList((float[])expected));
        }

        public abstract void ofElementsIn(Iterable<? extends Number> var1);

        @Deprecated
        public boolean equals(@NullableDecl Object o) {
            throw new UnsupportedOperationException("If you meant to compare float arrays, use .of() or .ofElementsIn() instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

