/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

@BugPattern(name="ProtoFieldNullComparison", summary="Protobuf fields cannot be null.", category=BugPattern.Category.PROTOBUF, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ProtoFieldNullComparison
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final String PROTO_SUPER_CLASS = "com.google.protobuf.GeneratedMessage";
    private static final Matcher<ExpressionTree> PROTO_RECEIVER = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage");
    private static final Matcher<Tree> RETURNS_LIST = Matchers.isSubtypeOf((String)"java.util.List");
    private static final Set<Tree.Kind> COMPARISON_OPERATORS = EnumSet.of(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO);
    private static final Matcher<ExpressionTree> EXTENSION_METHODS_WITH_FIX = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage.ExtendableMessage").named("getExtension").withParameters(new String[]{"com.google.protobuf.ExtensionLite"});
    private static final Matcher<ExpressionTree> EXTENSION_METHODS_WITH_NO_FIX = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageOrBuilder").named("getRepeatedField").withParameters(new String[]{"com.google.protobuf.Descriptors.FieldDescriptor", "int"}), Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage.ExtendableMessage").named("getExtension").withParameters(new String[]{"com.google.protobuf.ExtensionLite", "int"}), Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageOrBuilder").named("getField").withParameters(new String[]{"com.google.protobuf.Descriptors.FieldDescriptor"})});
    private final boolean trackAssignments;

    private static boolean isNull(ExpressionTree tree) {
        return tree.getKind() == Tree.Kind.NULL_LITERAL;
    }

    public ProtoFieldNullComparison(ErrorProneFlags flags) {
        this.trackAssignments = flags.getBoolean("ProtoFieldNullComparison:TrackAssignments").orElse(false);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ProtoNullComparisonScanner scanner = new ProtoNullComparisonScanner(state);
        scanner.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private static String getMethodName(ExpressionTree tree) {
        MethodInvocationTree method = (MethodInvocationTree)tree;
        ExpressionTree expressionTree = method.getMethodSelect();
        JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
        return access.sym.getQualifiedName().toString();
    }

    private static String replaceLast(String text, String pattern, String replacement) {
        StringBuilder builder = new StringBuilder(text);
        int lastIndexOf = builder.lastIndexOf(pattern);
        return builder.replace(lastIndexOf, lastIndexOf + pattern.length(), replacement).toString();
    }

    private static enum GetterTypes {
        SCALAR{

            @Override
            Fixer match(ExpressionTree tree, VisitorState state) {
                if (tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
                    return null;
                }
                MethodInvocationTree method = (MethodInvocationTree)tree;
                if (!method.getArguments().isEmpty()) {
                    return null;
                }
                if (RETURNS_LIST.matches((Tree)method, state)) {
                    return null;
                }
                ExpressionTree expressionTree = method.getMethodSelect();
                return GetterTypes.isGetter(expressionTree) ? (b, s) -> this.generateFix(method, b, s) : null;
            }

            private SuggestedFix generateFix(MethodInvocationTree methodInvocation, BinaryTree binaryTree, VisitorState state) {
                String methodName = ProtoFieldNullComparison.getMethodName(methodInvocation);
                String hasMethod = methodName.replaceFirst("get", "has");
                Set hasMethods = ASTHelpers.findMatchingMethods((Name)state.getName(hasMethod), ms -> ms.params().isEmpty(), (Type)ASTHelpers.getType((Tree)ASTHelpers.getReceiver((ExpressionTree)methodInvocation)), (Types)state.getTypes());
                if (hasMethods.isEmpty()) {
                    return SuggestedFix.builder().build();
                }
                String replacement = ProtoFieldNullComparison.replaceLast(methodInvocation.toString(), methodName, hasMethod);
                return SuggestedFix.replace((Tree)binaryTree, (String)(binaryTree.getKind() == Tree.Kind.EQUAL_TO ? "!" + replacement : replacement));
            }
        }
        ,
        VECTOR{

            @Override
            Fixer match(ExpressionTree tree, VisitorState state) {
                if (tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
                    return null;
                }
                MethodInvocationTree method = (MethodInvocationTree)tree;
                if (!method.getArguments().isEmpty()) {
                    return null;
                }
                if (!RETURNS_LIST.matches((Tree)method, state)) {
                    return null;
                }
                ExpressionTree expressionTree = method.getMethodSelect();
                return GetterTypes.isGetter(expressionTree) ? (b, s) -> this.generateFix(method, b) : null;
            }

            private SuggestedFix generateFix(ExpressionTree methodInvocation, BinaryTree binaryTree) {
                String replacement = methodInvocation + ".isEmpty()";
                return SuggestedFix.replace((Tree)binaryTree, (String)(binaryTree.getKind() == Tree.Kind.EQUAL_TO ? replacement : "!" + replacement));
            }
        }
        ,
        EXTENSION_METHOD{

            @Override
            Fixer match(ExpressionTree tree, VisitorState state) {
                if (EXTENSION_METHODS_WITH_NO_FIX.matches((Tree)tree, state)) {
                    return GetterTypes.emptyFix();
                }
                if (EXTENSION_METHODS_WITH_FIX.matches((Tree)tree, state)) {
                    MethodInvocationTree m = (MethodInvocationTree)tree;
                    Type argumentType = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(m.getArguments())));
                    Symbol extension = state.getSymbolFromString("com.google.protobuf.ExtensionLite");
                    Type genericsArgument = state.getTypes().asSuper(argumentType, extension);
                    if (genericsArgument.getTypeArguments().size() != 2) {
                        return GetterTypes.emptyFix();
                    }
                    if (ASTHelpers.isSubtype((Type)genericsArgument.getTypeArguments().get(1), (Type)state.getTypeFromString("java.util.List"), (VisitorState)state)) {
                        return GetterTypes.emptyFix();
                    }
                    return this.generateFix();
                }
                return null;
            }

            private Fixer generateFix() {
                return (b, s) -> {
                    ExpressionTree leftOperand = b.getLeftOperand();
                    ExpressionTree rightOperand = b.getRightOperand();
                    ExpressionTree methodInvocation = ProtoFieldNullComparison.isNull(leftOperand) ? rightOperand : leftOperand;
                    String methodName = ProtoFieldNullComparison.getMethodName(methodInvocation);
                    String hasMethod = methodName.replaceFirst("get", "has");
                    String replacement = ProtoFieldNullComparison.replaceLast(methodInvocation.toString(), methodName, hasMethod);
                    return SuggestedFix.replace((Tree)b, (String)(b.getKind() == Tree.Kind.EQUAL_TO ? "!" + replacement : replacement));
                };
            }
        };


        private static Fixer emptyFix() {
            return (b, s) -> SuggestedFix.builder().build();
        }

        private static boolean isGetter(ExpressionTree expressionTree) {
            if (!(expressionTree instanceof JCTree.JCFieldAccess)) {
                return false;
            }
            JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
            String methodName = access.sym.getQualifiedName().toString();
            return methodName.startsWith("get");
        }

        abstract Fixer match(ExpressionTree var1, VisitorState var2);
    }

    @FunctionalInterface
    private static interface Fixer {
        public SuggestedFix generateFix(BinaryTree var1, VisitorState var2);
    }

    private class ProtoNullComparisonScanner
    extends TreePathScanner<Void, Void> {
        private final Map<Symbol, ExpressionTree> effectivelyFinalValues = new HashMap<Symbol, ExpressionTree>();
        private final VisitorState state;

        private ProtoNullComparisonScanner(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitMethod(MethodTree method, Void unused) {
            return ProtoFieldNullComparison.this.isSuppressed(method) ? null : (Void)super.visitMethod(method, unused);
        }

        @Override
        public Void visitClass(ClassTree clazz, Void unused) {
            return ProtoFieldNullComparison.this.isSuppressed(clazz) ? null : (Void)super.visitClass(clazz, unused);
        }

        @Override
        public Void visitVariable(VariableTree variable, Void unused) {
            Symbol.VarSymbol symbol;
            if (ProtoFieldNullComparison.this.trackAssignments && this.isEffectivelyFinal(symbol = ASTHelpers.getSymbol((VariableTree)variable)) && variable.getInitializer() != null) {
                this.effectivelyFinalValues.put(symbol, variable.getInitializer());
            }
            return ProtoFieldNullComparison.this.isSuppressed(variable) ? null : (Void)super.visitVariable(variable, null);
        }

        @Override
        public Void visitBinary(BinaryTree binary, Void unused) {
            if (!COMPARISON_OPERATORS.contains((Object)binary.getKind())) {
                return (Void)super.visitBinary(binary, null);
            }
            VisitorState subState = this.state.withPath(this.getCurrentPath());
            Optional<Fixer> getter = Optional.empty();
            if (ProtoFieldNullComparison.isNull(binary.getLeftOperand())) {
                getter = this.getFixer(binary.getRightOperand(), subState);
            }
            if (ProtoFieldNullComparison.isNull(binary.getRightOperand())) {
                getter = this.getFixer(binary.getLeftOperand(), subState);
            }
            getter.map(g -> ProtoFieldNullComparison.this.describeMatch(binary, (Fix)g.generateFix(binary, subState))).ifPresent(arg_0 -> ((VisitorState)this.state).reportMatch(arg_0));
            return (Void)super.visitBinary(binary, null);
        }

        private boolean isEffectivelyFinal(@Nullable Symbol symbol) {
            return symbol != null && (symbol.flags() & 0x20000000010L) != 0L;
        }

        private Optional<Fixer> getFixer(ExpressionTree tree, VisitorState state) {
            ExpressionTree resolvedTree;
            ExpressionTree expressionTree = resolvedTree = tree.getKind() == Tree.Kind.IDENTIFIER ? this.effectivelyFinalValues.get(ASTHelpers.getSymbol((Tree)tree)) : tree;
            if (resolvedTree == null || !PROTO_RECEIVER.matches((Tree)resolvedTree, state)) {
                return Optional.empty();
            }
            return Arrays.stream(GetterTypes.values()).map(type -> type.match(resolvedTree, state)).filter(Objects::nonNull).findFirst();
        }
    }
}

