/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.stats.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class DistributionAggregation {
    private final long count;
    private final double mean;
    private final double sum;
    private final Range range;
    private final List<Tag> tags;
    private final List<Long> bucketCounts;

    public static final DistributionAggregation create(long count, double mean, double sum, Range range, List<Tag> tags) {
        return new DistributionAggregation(count, mean, sum, range, tags, null);
    }

    public static final DistributionAggregation create(long count, double mean, double sum, Range range, List<Tag> tags, List<Long> bucketCounts) {
        return new DistributionAggregation(count, mean, sum, range, tags, Collections.unmodifiableList(new ArrayList<Long>(bucketCounts)));
    }

    public final List<Tag> getTags() {
        return this.tags;
    }

    public long getCount() {
        return this.count;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSum() {
        return this.sum;
    }

    public Range getRange() {
        return this.range;
    }

    @Nullable
    public List<Long> getBucketCounts() {
        return this.bucketCounts;
    }

    private DistributionAggregation(long count, double mean, double sum, Range range, List<Tag> tags, @Nullable List<Long> bucketCounts) {
        this.count = count;
        this.mean = mean;
        this.sum = sum;
        this.range = range;
        this.tags = tags;
        this.bucketCounts = bucketCounts;
    }

    public static final class Range {
        private double min;
        private double max;

        public static final Range create(double min, double max) {
            return new Range(min, max);
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        private Range(double min, double max) {
            this.min = min;
            this.max = max;
        }
    }
}

