/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.List;
import javax.lang.model.element.ElementKind;

@BugPattern(name="EqualsHashCode", summary="Classes that override equals should also override hashCode.", severity=BugPattern.SeverityLevel.ERROR, tags={"FragileCode"})
public class EqualsHashCode
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree classTree, VisitorState state) {
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)classTree);
        if (((Symbol)symbol).getKind() != ElementKind.CLASS) {
            return Description.NO_MATCH;
        }
        if (symbol == state.getSymtab().objectType.tsym) {
            return Description.NO_MATCH;
        }
        MethodTree equals = null;
        for (Tree tree : classTree.getMembers()) {
            if (!(tree instanceof MethodTree)) continue;
            MethodTree methodTree = (MethodTree)tree;
            if (!Matchers.equalsMethodDeclaration().matches((Tree)methodTree, state)) continue;
            equals = methodTree;
        }
        if (equals == null || this.isSuppressed(equals)) {
            return Description.NO_MATCH;
        }
        if (EqualsHashCode.callsSuperEquals(equals, state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol hashCodeSym = ASTHelpers.resolveExistingMethod((VisitorState)state, (Symbol.TypeSymbol)symbol, (Name)state.getName("hashCode"), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
        if (!hashCodeSym.owner.equals(state.getSymtab().objectType.tsym)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(equals);
    }

    private static boolean callsSuperEquals(MethodTree method, VisitorState state) {
        if (method.getBody() == null) {
            return false;
        }
        List<? extends StatementTree> statements = method.getBody().getStatements();
        if (statements.size() != 1) {
            return false;
        }
        Tree statement = (Tree)Iterables.getOnlyElement(statements);
        if (!(statement instanceof ReturnTree)) {
            return false;
        }
        ExpressionTree expression = ((ReturnTree)statement).getExpression();
        if (expression == null) {
            return false;
        }
        return Matchers.instanceEqualsInvocation().matches((Tree)expression, state);
    }
}

