/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.Name;
import javax.lang.model.element.Modifier;

@BugPattern(name="FragmentInjection", summary="Classes extending PreferenceActivity must implement isValidFragment such that it does not unconditionally return true to prevent vulnerability to fragment injection attacks.", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public class FragmentInjection
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<MethodTree> OVERRIDES_IS_VALID_FRAGMENT = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"isValidFragment"), Matchers.methodHasParameters((Matcher[])new Matcher[]{Matchers.isSameType((String)"java.lang.String")})});
    private static final TreeScanner<Boolean, Void> ALWAYS_RETURNS_TRUE = new TreeScanner<Boolean, Void>(){

        @Override
        public Boolean visitReturn(ReturnTree node, Void unused) {
            ExpressionTree returnExpression = node.getExpression();
            Boolean returnValue = (Boolean)ASTHelpers.constValue((Tree)returnExpression, Boolean.class);
            return (Boolean)MoreObjects.firstNonNull((Object)returnValue, (Object)false);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return !(r1 != null && r1 == false || r2 != null && r2 == false);
        }
    };

    public Description matchClass(ClassTree tree, VisitorState state) {
        Type preferenceActivityType = state.getTypeFromString("android.preference.PreferenceActivity");
        if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((ClassTree)tree), (Type)preferenceActivityType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Symbol.TypeSymbol preferenceActivityTypeSymbol = preferenceActivityType.tsym;
        boolean methodNotImplemented = true;
        try {
            Symbol.MethodSymbol isValidFragmentMethodSymbol = ASTHelpers.resolveExistingMethod((VisitorState)state, (Symbol.TypeSymbol)ASTHelpers.getSymbol((ClassTree)tree), (Name)state.getName("isValidFragment"), (Iterable)ImmutableList.of((Object)state.getTypeFromString("java.lang.String")), (Iterable)ImmutableList.of());
            methodNotImplemented = isValidFragmentMethodSymbol.owner.equals(preferenceActivityTypeSymbol);
        }
        catch (FatalError isValidFragmentMethodSymbol) {
            // empty catch block
        }
        if (methodNotImplemented && Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.ABSTRACT)).matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Class extending PreferenceActivity does not implement isValidFragment.").build();
        }
        MethodTree isValidFragmentMethodTree = FragmentInjection.getMethod(OVERRIDES_IS_VALID_FRAGMENT, tree, state);
        if (isValidFragmentMethodTree != null && isValidFragmentMethodTree.accept(ALWAYS_RETURNS_TRUE, null).booleanValue()) {
            return this.buildDescription(isValidFragmentMethodTree).setMessage("isValidFragment unconditionally returns true.").build();
        }
        return Description.NO_MATCH;
    }

    private static MethodTree getMethod(Matcher<MethodTree> methodMatcher, ClassTree classTree, VisitorState state) {
        for (Tree tree : classTree.getMembers()) {
            MethodTree memberTree;
            if (!(tree instanceof MethodTree) || !methodMatcher.matches((Tree)(memberTree = (MethodTree)tree), state)) continue;
            return memberTree;
        }
        return null;
    }
}

