/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="LocalDateTemporalAmount", summary="LocalDate.plus() and minus() does not work with Durations. LocalDate represents civil time (years/months/days), so java.time.Period is the appropriate thing to add or subtract instead.", severity=BugPattern.SeverityLevel.ERROR)
public final class LocalDateTemporalAmount
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("java.time.LocalDate").namedAnyOf(new String[]{"plus", "minus"}).withParameters(new String[]{"java.time.temporal.TemporalAmount"}), Matchers.argument((int)0, (Matcher)Matchers.isSameType((String)"java.time.Duration")), Matchers.not((Matcher)Matchers.packageStartsWith((String)"java."))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return MATCHER.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

