/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.Context;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import javax.tools.JavaFileManager;

public class MaskedClassLoader
extends ClassLoader {
    public static void preRegisterFileManager(Context context) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            @Override
            public JavaFileManager make(Context c) {
                return new MaskedFileManager(c);
            }
        });
    }

    public MaskedClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("com.google.errorprone.") || name.startsWith("org.checkerframework.shaded.dataflow.")) {
            return Class.forName(name);
        }
        throw new ClassNotFoundException(name);
    }

    @ClientCodeWrapper.Trusted
    static class MaskedFileManager
    extends JavacFileManager {
        public MaskedFileManager(Context context) {
            super(context, true, StandardCharsets.UTF_8);
        }

        public MaskedFileManager() {
            this(new Context());
        }

        @Override
        protected ClassLoader getClassLoader(URL[] urls) {
            return new URLClassLoader(urls, (ClassLoader)new MaskedClassLoader(JavacFileManager.class.getClassLoader()));
        }
    }
}

