/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Arrays;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.Identifier;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NullLiteral;

public class ReadParcelableDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"ParcelClassLoader", (String)"Default Parcel Class Loader", (String)"The documentation for `Parcel#readParcelable(ClassLoader)` (and its variations) says that you can pass in `null` to pick up the default class loader. However, that ClassLoader is a system class loader and is not able to find classes in your own application.\n\nIf you are writing your own classes into the `Parcel` (not just SDK classes like `String` and so on), then you should supply a `ClassLoader` for your application instead; a simple way to obtain one is to just call `getClass().getClassLoader()` from your own class.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(ReadParcelableDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/os/Parcel.html");

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("readParcelable", "readParcelableArray", "readBundle", "readArray", "readSparseArray", "readValue", "readPersistableBundle");
    }

    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation node) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (resolved instanceof JavaParser.ResolvedMethod && (method = (JavaParser.ResolvedMethod)resolved).getContainingClass().matches("android.os.Parcel")) {
            Expression parameter;
            int argumentCount = method.getArgumentCount();
            if (argumentCount == 0) {
                Identifier name = node.astName();
                String message = String.format("Using the default class loader will not work if you are restoring your own classes. Consider using for example `%1$s(getClass().getClassLoader())` instead.", name.astValue());
                Location location = context.getRangeLocation((Node)name, 0, (Node)name, 2);
                context.report(ISSUE, (Node)node, location, message);
            } else if (argumentCount == 1 && (parameter = (Expression)node.astArguments().first()) instanceof NullLiteral) {
                String message = "Passing null here (to use the default class loader) will not work if you are restoring your own classes. Consider using for example `getClass().getClassLoader()` instead.";
                Location location = context.getRangeLocation((Node)node.astName(), 0, (Node)parameter, 1);
                context.report(ISSUE, (Node)node, location, message);
            }
        }
    }
}

