/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Optional;

class Optional8Codec
implements ObjectCodec<Optional<?>> {
    Optional8Codec() {
    }

    @Override
    public Class<Optional<?>> getEncodedClass() {
        return Optional.class;
    }

    @Override
    public void serialize(SerializationContext context, Optional<?> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeBoolNoTag(obj.isPresent());
        if (obj.isPresent()) {
            context.serialize(obj.get(), codedOut);
        }
    }

    @Override
    public Optional<?> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        if (!codedIn.readBool()) {
            return Optional.empty();
        }
        return Optional.of(context.deserialize(codedIn));
    }
}

