/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jacoco.report.IMultiReportOutput;

public class ZipMultiReportOutput
implements IMultiReportOutput {
    private final ZipOutputStream zip;
    private OutputStream currentEntry;

    public ZipMultiReportOutput(ZipOutputStream zip) {
        this.zip = zip;
    }

    public ZipMultiReportOutput(OutputStream out) {
        this(new ZipOutputStream(out));
    }

    @Override
    public OutputStream createFile(String path) throws IOException {
        if (this.currentEntry != null) {
            this.currentEntry.close();
        }
        ZipEntry entry = new ZipEntry(path);
        this.zip.putNextEntry(entry);
        this.currentEntry = new EntryOutput();
        return this.currentEntry;
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    private final class EntryOutput
    extends OutputStream {
        private boolean closed = false;

        private EntryOutput() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureNotClosed();
            ZipMultiReportOutput.this.zip.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.ensureNotClosed();
            ZipMultiReportOutput.this.zip.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.ensureNotClosed();
            ZipMultiReportOutput.this.zip.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.ensureNotClosed();
            ZipMultiReportOutput.this.zip.flush();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                ZipMultiReportOutput.this.zip.closeEntry();
            }
        }

        private void ensureNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Zip entry already closed.");
            }
        }
    }
}

