/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.bugpatterns.AbstractPatternSyntaxChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="BareDotMetacharacter", summary="\".\" is rarely useful as a regex, as it matches any character. To match a literal '.' character, instead write \"\\\\.\".", severity=BugPattern.SeverityLevel.WARNING, altNames={"InvalidPatternSyntax"})
public class BareDotMetacharacter
extends AbstractPatternSyntaxChecker
implements BugChecker.MethodInvocationTreeMatcher {
    @Override
    protected final Description matchRegexLiteral(MethodInvocationTree tree, String regex) {
        if (regex.equals(".")) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree.getArguments().get(0), (String)"\"\\\\.\""));
        }
        return Description.NO_MATCH;
    }
}

