/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;

@BugPattern(name="InitializeInline", summary="Initializing variables in their declaring statement is clearer, where possible.", severity=BugPattern.SeverityLevel.WARNING)
public final class InitializeInline
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Tree declarationParent = state.getPath().getParentPath().getLeaf();
        if (declarationParent instanceof ClassTree) {
            return Description.NO_MATCH;
        }
        final Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (symbol == null || !ASTHelpers.isConsideredFinal((Symbol)symbol)) {
            return Description.NO_MATCH;
        }
        final ArrayList assignments = new ArrayList();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitAssignment(AssignmentTree node, Void unused) {
                if (symbol.equals(ASTHelpers.getSymbol((Tree)node.getVariable()))) {
                    assignments.add(this.getCurrentPath());
                }
                return (Void)super.visitAssignment(node, null);
            }
        }.scan(state.getPath().getParentPath(), (Void)null);
        if (assignments.size() != 1) {
            return Description.NO_MATCH;
        }
        TreePath soleAssignmentPath = (TreePath)Iterables.getOnlyElement(assignments);
        Tree grandParent = soleAssignmentPath.getParentPath().getParentPath().getLeaf();
        if (!(soleAssignmentPath.getParentPath().getLeaf() instanceof StatementTree) || !grandParent.equals(declarationParent)) {
            return Description.NO_MATCH;
        }
        ModifiersTree modifiersTree = tree.getModifiers();
        String modifiers = modifiersTree == null || state.getEndPosition((Tree)modifiersTree) == -1 ? "" : state.getSourceForNode((Tree)modifiersTree) + " ";
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace((Tree)tree, "").prefixWith(soleAssignmentPath.getLeaf(), modifiers + state.getSourceForNode(tree.getType()) + " ").build());
    }
}

