/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;

@BugPattern(name="MissingImplementsComparable", summary="Classes implementing valid compareTo function should implement Comparable interface", severity=BugPattern.SeverityLevel.WARNING)
public class MissingImplementsComparable
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> COMPARABLE_WITHOUT_OVERRIDE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.compareToMethodDeclaration(), Matchers.not((Matcher)Matchers.hasAnnotation((String)"java.lang.Override"))});
    private static final Matcher<ClassTree> IS_COMPARABLE = Matchers.isSubtypeOf((String)"java.lang.Comparable");

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!COMPARABLE_WITHOUT_OVERRIDE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ClassTree enclosingClass = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        if (enclosingClass == null || IS_COMPARABLE.matches((Tree)enclosingClass, state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getParameters()))), (Type)ASTHelpers.getType((ClassTree)enclosingClass), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

