/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.guice;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;

@BugPattern(name="BindingToUnqualifiedCommonType", summary="This code declares a binding for a common value type without a Qualifier annotation.", severity=BugPattern.SeverityLevel.WARNING)
public class BindingToUnqualifiedCommonType
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<Tree> IS_SIMPLE_TYPE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isPrimitiveOrBoxedPrimitiveType(), Matchers.isSameType(DayOfWeek.class), Matchers.isSameType(Duration.class), Matchers.isSameType(Instant.class), Matchers.isSameType(LocalDate.class), Matchers.isSameType(LocalDateTime.class), Matchers.isSameType(LocalTime.class), Matchers.isSameType(Month.class), Matchers.isSameType(MonthDay.class), Matchers.isSameType(OffsetDateTime.class), Matchers.isSameType(OffsetTime.class), Matchers.isSameType(Period.class), Matchers.isSameType(Year.class), Matchers.isSameType(YearMonth.class), Matchers.isSameType(ZonedDateTime.class), Matchers.isSameType(String.class), Matchers.isSameType(BigDecimal.class)});
    private static final Matcher<MethodTree> PROVIDES_UNQUALIFIED_CONSTANT = Matchers.allOf((Matcher[])new Matcher[]{Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"com.google.inject.Provides")), Matchers.not((Matcher)Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.symbolHasAnnotation((String)"com.google.inject.BindingAnnotation"), Matchers.symbolHasAnnotation((String)"javax.inject.Qualifier")}))), Matchers.methodReturns(IS_SIMPLE_TYPE)});
    private static final Matcher<MethodInvocationTree> BIND_TO_UNQUALIFIED_CONSTANT = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("com.google.inject.binder.LinkedBindingBuilder").namedAnyOf(new String[]{"to", "toInstance", "toProvider", "toConstructor"}), Matchers.receiverOfInvocation((Matcher)Matchers.methodInvocation((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("com.google.inject.AbstractModule").withSignature("<T>bind(java.lang.Class<T>)"), Matchers.instanceMethod().onDescendantOf("com.google.inject.Binder").withSignature("<T>bind(java.lang.Class<T>)")}), (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.ALL, (Matcher)Matchers.classLiteral(IS_SIMPLE_TYPE)))});

    public Description matchMethod(MethodTree method, VisitorState state) {
        if (PROVIDES_UNQUALIFIED_CONSTANT.matches((Tree)method, state) && !ASTHelpers.isJUnitTestCode((VisitorState)state)) {
            return this.describeMatch(method);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree methodInvocation, VisitorState state) {
        if (BIND_TO_UNQUALIFIED_CONSTANT.matches((Tree)methodInvocation, state) && !ASTHelpers.isJUnitTestCode((VisitorState)state)) {
            return this.describeMatch(methodInvocation);
        }
        return Description.NO_MATCH;
    }
}

