/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inlineme;

import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.inlineme.AutoValue_InlineMeData;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.google.errorprone.util.SourceCodeEscapers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;

@AutoValue
abstract class InlineMeData {
    private static final String INLINE_ME = "InlineMe";
    private static final CharMatcher SEMICOLON = CharMatcher.is((char)';');

    InlineMeData() {
    }

    static String buildAnnotation(String replacement, Set<String> imports, Set<String> staticImports) {
        String annotation = "@InlineMe(replacement = \"" + SourceCodeEscapers.javaCharEscaper().escape(replacement) + "\"";
        if (!imports.isEmpty()) {
            annotation = annotation + ", imports = " + InlineMeData.quote(imports);
        }
        if (!staticImports.isEmpty()) {
            annotation = annotation + ", staticImports = " + InlineMeData.quote(staticImports);
        }
        annotation = annotation + ")\n";
        return annotation;
    }

    String buildAnnotation() {
        return InlineMeData.buildAnnotation(this.replacement(), this.imports(), this.staticImports());
    }

    private static String quote(Set<String> imports) {
        String quoted = "\"" + Joiner.on((String)"\", \"").join(imports) + "\"";
        if (imports.size() == 1) {
            return quoted;
        }
        return "{" + quoted + "}";
    }

    abstract String replacement();

    abstract ImmutableSet<String> imports();

    abstract ImmutableSet<String> staticImports();

    static Optional<InlineMeData> createFromSymbol(Symbol.MethodSymbol symbol) {
        if (!ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)symbol, (String)INLINE_ME)) {
            return Optional.empty();
        }
        Attribute.Compound inlineMe = (Attribute.Compound)symbol.getRawAttributes().stream().filter(a -> ((Name)a.type.tsym.getSimpleName()).contentEquals(INLINE_ME)).collect(MoreCollectors.onlyElement());
        ImmutableSet<String> imports = InlineMeData.getStrings(inlineMe, "imports");
        ImmutableSet<String> staticImports = InlineMeData.getStrings(inlineMe, "staticImports");
        return MoreAnnotations.getValue((Attribute.Compound)inlineMe, (String)"replacement").flatMap(MoreAnnotations::asStringValue).map(InlineMeData::trimTrailingSemicolons).map(replacement -> InlineMeData.create(replacement, (Iterable<String>)imports, (Iterable<String>)staticImports));
    }

    private static InlineMeData create(String replacement, Iterable<String> imports, Iterable<String> staticImports) {
        return new AutoValue_InlineMeData(replacement, (ImmutableSet<String>)ImmutableSet.copyOf(imports), (ImmutableSet<String>)ImmutableSet.copyOf(staticImports));
    }

    static InlineMeData buildExpectedInlineMeAnnotation(VisitorState state, ExpressionTree expression) {
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)((ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class)));
        ImportAndQualificationFinder qualifier = new ImportAndQualificationFinder(classSymbol, state);
        qualifier.scan(TreePath.getPath(state.getPath(), (Tree)expression), null);
        return InlineMeData.create(InlineMeData.prettyPrint(new QualifyingTreeCopier(state, qualifier.qualifications).copy((JCTree.JCExpression)expression)), qualifier.imports, qualifier.staticImports);
    }

    private static String prettyPrint(JCTree tree) {
        StringWriter w = new StringWriter();
        tree.accept(new GooglePrinter(w));
        return w.toString();
    }

    private static ImmutableSet<String> getStrings(Attribute.Compound attribute, String name) {
        return (ImmutableSet)MoreAnnotations.getValue((Attribute.Compound)attribute, (String)name).map(MoreAnnotations::asStrings).orElse(Stream.empty()).collect(ImmutableSet.toImmutableSet());
    }

    private static String trimTrailingSemicolons(String s) {
        return SEMICOLON.trimTrailingFrom((CharSequence)s);
    }

    private static class ImportAndQualificationFinder
    extends TreePathScanner<Void, Void> {
        final IdentityHashMap<IdentifierTree, JCTree.JCExpression> qualifications = new IdentityHashMap();
        final Set<String> imports = new TreeSet<String>();
        final Set<String> staticImports = new TreeSet<String>();
        private final Symbol.ClassSymbol classSymbol;
        private final TreeMaker treeMaker;
        private final VisitorState state;

        ImportAndQualificationFinder(Symbol.ClassSymbol classSymbol, VisitorState state) {
            this.classSymbol = classSymbol;
            this.treeMaker = state.getTreeMaker();
            this.state = state;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, Void unused) {
            Symbol symbol;
            if (!(node.getExpression() instanceof MemberSelectTree) && (symbol = ASTHelpers.getSymbol((Tree)node)).isStatic()) {
                this.maybeAddImport(symbol.owner);
            }
            return (Void)super.visitMemberSelect(node, null);
        }

        private void maybeAddImport(Symbol symbol) {
            if (symbol != null) {
                this.addImport(symbol.getQualifiedName().toString());
            }
        }

        private void addImport(String clazzName) {
            if (!clazzName.isEmpty() && !clazzName.startsWith("java.lang")) {
                this.imports.add(clazzName);
            }
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
            if (identifierTree.getName().contentEquals("this")) {
                return (Void)super.visitIdentifier(identifierTree, unused);
            }
            Symbol symbol = ASTHelpers.getSymbol((Tree)identifierTree);
            if (symbol == null || ASTHelpers.isLocal((Symbol)symbol)) {
                return (Void)super.visitIdentifier(identifierTree, unused);
            }
            Tree parentNode = this.getCurrentPath().getParentPath().getLeaf();
            if (ImportAndQualificationFinder.nameUsageDoesntRequireQualificationOrImport(parentNode)) {
                return (Void)super.visitIdentifier(identifierTree, unused);
            }
            boolean isMemberOfThisClass = this.isMemberOfThisClass(symbol, parentNode);
            boolean nameUsageRequiresNoQualification = ImportAndQualificationFinder.nameUsageDoesntRequireQualification(parentNode);
            if (symbol.isStatic()) {
                if (isMemberOfThisClass) {
                    this.addImport(this.classSymbol.getQualifiedName().toString());
                    if (!nameUsageRequiresNoQualification) {
                        this.qualifications.put(identifierTree, this.treeMaker.Ident(this.classSymbol));
                    }
                } else if (parentNode instanceof NewClassTree) {
                    this.addImport(symbol.getQualifiedName().toString());
                } else {
                    this.staticImports.add(symbol.owner.getQualifiedName() + "." + symbol.getQualifiedName());
                }
            } else if (isMemberOfThisClass) {
                if (!nameUsageRequiresNoQualification) {
                    this.qualifications.put(identifierTree, this.treeMaker.This(this.classSymbol.type));
                }
            } else {
                this.addImport(symbol.getQualifiedName().toString());
            }
            return (Void)super.visitIdentifier(identifierTree, unused);
        }

        private boolean isMemberOfThisClass(Symbol symbol, Tree parentNode) {
            return symbol.owner != null && this.classSymbol.isSubClass(symbol.owner, this.state.getTypes()) && !(parentNode instanceof NewClassTree);
        }

        private static boolean nameUsageDoesntRequireQualificationOrImport(Tree parentNode) {
            return parentNode instanceof MemberSelectTree;
        }

        private static boolean nameUsageDoesntRequireQualification(Tree parentNode) {
            return parentNode instanceof NewClassTree || parentNode instanceof MemberReferenceTree || parentNode instanceof TypeCastTree || parentNode instanceof NewArrayTree;
        }
    }

    private static class GooglePrinter
    extends Pretty {
        private final StringWriter writer;

        public GooglePrinter(StringWriter writer) {
            super(writer, false);
            this.writer = writer;
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast jcTypeCast) {
            try {
                this.print("(");
                this.printExpr(jcTypeCast.clazz);
                this.print(") ");
                this.printExpr(jcTypeCast.expr);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void visitLambda(JCTree.JCLambda jcLambda) {
            try {
                boolean paramsNeedParentheses;
                boolean paramsAreExplicit = jcLambda.paramKind == JCTree.JCLambda.ParameterKind.EXPLICIT;
                boolean bl = paramsNeedParentheses = jcLambda.params.size() != 1 || paramsAreExplicit;
                if (paramsNeedParentheses) {
                    this.print("(");
                }
                if (paramsAreExplicit) {
                    this.printExprs(jcLambda.params);
                } else {
                    Joiner.on((String)", ").appendTo((Appendable)this.writer, jcLambda.params.map(JCTree.JCVariableDecl::getName));
                }
                if (paramsNeedParentheses) {
                    this.print(")");
                }
                this.print(" -> ");
                this.printExpr(jcLambda.body);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class QualifyingTreeCopier
    extends TreeCopier<Void> {
        private final TreeMaker treeMaker;
        private final VisitorState state;
        private final IdentityHashMap<IdentifierTree, JCTree.JCExpression> qualifications;

        public QualifyingTreeCopier(VisitorState state, IdentityHashMap<IdentifierTree, JCTree.JCExpression> qualifications) {
            super(state.getTreeMaker());
            this.state = state;
            this.treeMaker = state.getTreeMaker();
            this.qualifications = qualifications;
        }

        @Override
        public JCTree visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Void unused) {
            JCTree.JCLambda expr = (JCTree.JCLambda)lambdaExpressionTree;
            JCTree.JCLambda lambda = (JCTree.JCLambda)super.visitLambdaExpression(lambdaExpressionTree, unused);
            lambda.paramKind = expr.paramKind;
            return lambda;
        }

        @Override
        public JCTree visitIdentifier(IdentifierTree identifierTree, Void unused) {
            if (this.qualifications.containsKey(identifierTree)) {
                return this.treeMaker.Select(this.qualifications.get(identifierTree), this.state.getName(identifierTree.toString()));
            }
            return super.visitIdentifier(identifierTree, unused);
        }
    }
}

