/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inlineme;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.InlineMeValidationDisabled;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inlineme.InlinabilityResult;
import com.google.errorprone.bugpatterns.inlineme.InlineMeData;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Context;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

@BugPattern(name="InlineMeValidator", summary="Ensures that the @InlineMe annotation is used correctly.", suppressionAnnotations={InlineMeValidationDisabled.class}, documentSuppression=false, severity=BugPattern.SeverityLevel.ERROR)
public final class Validator
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final CharMatcher SEMICOLON = CharMatcher.is((char)';');

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return InlineMeData.createFromSymbol(ASTHelpers.getSymbol((MethodTree)tree)).map(data -> this.match((InlineMeData)data, tree, state)).orElse(Description.NO_MATCH);
    }

    private Description match(InlineMeData existingAnnotation, MethodTree tree, VisitorState state) {
        InlinabilityResult result = InlinabilityResult.forMethod(tree, state);
        if (!result.isValidForValidator()) {
            return this.buildDescription(tree).setMessage(result.errorMessage()).addFix((Fix)SuggestedFix.delete((Tree)Validator.getInlineMeAnnotationTree(tree))).build();
        }
        InlineMeData inferredFromMethodBody = InlineMeData.buildExpectedInlineMeAnnotation(state, result.body());
        Set<MismatchedInlineMeComponents> mismatches = Validator.compatibleWithAnnotation(inferredFromMethodBody, existingAnnotation, state.context);
        if (mismatches.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(Validator.renderInlineMeMismatch(inferredFromMethodBody, existingAnnotation, mismatches)).addFix((Fix)SuggestedFix.replace((Tree)Validator.getInlineMeAnnotationTree(tree), (String)inferredFromMethodBody.buildAnnotation())).build();
    }

    private static AnnotationTree getInlineMeAnnotationTree(MethodTree tree) {
        return ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"InlineMe");
    }

    private static String renderInlineMeMismatch(InlineMeData inferredFromMethodBody, InlineMeData existingAnnotation, Set<MismatchedInlineMeComponents> mismatches) {
        StringBuilder message = new StringBuilder("There is a mismatch between the implementation of the method and the replacement suggested in the annotation.");
        if (mismatches.contains((Object)MismatchedInlineMeComponents.REPLACEMENT_STRING)) {
            message.append(String.format("\nReplacement text: \n  InferredFromBody: %s\n  FromAnnotation: %s", inferredFromMethodBody.replacement(), existingAnnotation.replacement()));
        }
        if (mismatches.contains((Object)MismatchedInlineMeComponents.IMPORTS)) {
            message.append(String.format("\nImports: \n  InferredFromBody: %s\n  FromAnnotation: %s", inferredFromMethodBody.imports(), existingAnnotation.imports()));
        }
        if (mismatches.contains((Object)MismatchedInlineMeComponents.STATIC_IMPORTS)) {
            message.append(String.format("\nStatic imports: \n  InferredFromBody: %s\n  FromAnnotation: %s", inferredFromMethodBody.staticImports(), existingAnnotation.staticImports()));
        }
        return message.toString();
    }

    private static Set<MismatchedInlineMeComponents> compatibleWithAnnotation(InlineMeData inferredFromMethodBody, InlineMeData anno, Context context) {
        EnumSet<MismatchedInlineMeComponents> mismatches = EnumSet.noneOf(MismatchedInlineMeComponents.class);
        if (!Validator.parseAndCheckForTokenEquivalence(anno.replacement(), inferredFromMethodBody.replacement(), context)) {
            mismatches.add(MismatchedInlineMeComponents.REPLACEMENT_STRING);
        }
        if (!inferredFromMethodBody.imports().equals(anno.imports())) {
            mismatches.add(MismatchedInlineMeComponents.IMPORTS);
        }
        if (!inferredFromMethodBody.staticImports().equals(anno.staticImports())) {
            mismatches.add(MismatchedInlineMeComponents.STATIC_IMPORTS);
        }
        return mismatches;
    }

    private static boolean parseAndCheckForTokenEquivalence(String first, String second, Context context) {
        ImmutableList tokens1 = ErrorProneTokens.getTokens((String)SEMICOLON.trimTrailingFrom((CharSequence)first), (Context)context);
        ImmutableList tokens2 = ErrorProneTokens.getTokens((String)SEMICOLON.trimTrailingFrom((CharSequence)second), (Context)context);
        if (tokens1.size() != tokens2.size()) {
            return false;
        }
        for (int i = 0; i < tokens1.size(); ++i) {
            ErrorProneToken token1 = (ErrorProneToken)tokens1.get(i);
            ErrorProneToken token2 = (ErrorProneToken)tokens2.get(i);
            if (!token1.kind().equals(token2.kind())) {
                return false;
            }
            if (!Validator.mismatch(token1, token2, ErrorProneToken::hasName, ErrorProneToken::name) && !Validator.mismatch(token1, token2, ErrorProneToken::hasStringVal, ErrorProneToken::stringVal) && !Validator.mismatch(token1, token2, ErrorProneToken::hasRadix, ErrorProneToken::radix)) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean mismatch(ErrorProneToken first, ErrorProneToken second, Predicate<ErrorProneToken> guard, Function<ErrorProneToken, T> extractor) {
        return guard.test(first) && !extractor.apply(first).equals(extractor.apply(second));
    }

    private static enum MismatchedInlineMeComponents {
        REPLACEMENT_STRING,
        IMPORTS,
        STATIC_IMPORTS;

    }
}

