/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@BugPattern(name="UnnecessaryCheckNotNull", summary="This null check is unnecessary; the expression can never be null", severity=BugPattern.SeverityLevel.ERROR, altNames={"PreconditionsCheckNotNull", "PreconditionsCheckNotNullPrimitive"})
public class UnnecessaryCheckNotNull
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> CHECK_NOT_NULL_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), MethodMatchers.staticMethod().onClass("com.google.common.base.Verify").named("verifyNotNull"), MethodMatchers.staticMethod().onClass("java.util.Objects").named("requireNonNull")});
    private static final Matcher<MethodInvocationTree> NEW_INSTANCE_MATCHER = Matchers.argument((int)0, (Matcher)Matchers.kindAnyOf((Set)ImmutableSet.of((Object)((Object)Tree.Kind.NEW_CLASS), (Object)((Object)Tree.Kind.NEW_ARRAY))));
    private static final Matcher<MethodInvocationTree> STRING_LITERAL_ARG_MATCHER = Matchers.argument((int)0, (Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.STRING_LITERAL));
    private static final Matcher<MethodInvocationTree> PRIMITIVE_ARG_MATCHER = Matchers.argument((int)0, (Matcher)Matchers.isPrimitiveType());

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!CHECK_NOT_NULL_MATCHER.matches((Tree)tree, state) || tree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (NEW_INSTANCE_MATCHER.matches((Tree)tree, state)) {
            return this.matchNewInstance(tree, state);
        }
        if (STRING_LITERAL_ARG_MATCHER.matches((Tree)tree, state)) {
            return this.matchStringLiteral(tree, state);
        }
        if (PRIMITIVE_ARG_MATCHER.matches((Tree)tree, state)) {
            return this.describePrimitiveMatch(tree, state);
        }
        return Description.NO_MATCH;
    }

    private Description matchNewInstance(MethodInvocationTree tree, VisitorState state) {
        SuggestedFix fix = SuggestedFix.replace((Tree)tree, (String)state.getSourceForNode((Tree)tree.getArguments().get(0)));
        return this.describeMatch(tree, (Fix)fix);
    }

    private Description matchStringLiteral(MethodInvocationTree methodInvocationTree, VisitorState state) {
        List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        ExpressionTree stringLiteralValue = arguments.get(0);
        SuggestedFix fix = arguments.size() == 2 ? SuggestedFix.swap((Tree)arguments.get(0), (Tree)arguments.get(1)) : SuggestedFix.delete((Tree)state.getPath().getParentPath().getLeaf());
        return this.describeMatch(stringLiteralValue, (Fix)fix);
    }

    private Description describePrimitiveMatch(MethodInvocationTree methodInvocationTree, VisitorState state) {
        ExpressionTree arg1 = methodInvocationTree.getArguments().get(0);
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            return this.describeMatch(arg1, (Fix)SuggestedFix.replace((Tree)methodInvocationTree, (String)state.getSourceForNode((Tree)arg1)));
        }
        if (arg1.getKind() == Tree.Kind.EQUAL_TO || arg1.getKind() == Tree.Kind.NOT_EQUAL_TO) {
            BinaryTree binaryExpr = (BinaryTree)arg1;
            if (binaryExpr.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL) {
                return this.describeMatch(arg1, (Fix)SuggestedFix.replace((Tree)arg1, (String)state.getSourceForNode((Tree)binaryExpr.getRightOperand())));
            }
            if (binaryExpr.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
                return this.describeMatch(arg1, (Fix)SuggestedFix.replace((Tree)arg1, (String)state.getSourceForNode((Tree)binaryExpr.getLeftOperand())));
            }
        }
        if ((arg1 instanceof BinaryTree || arg1.getKind() == Tree.Kind.METHOD_INVOCATION || arg1.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) && state.getTypes().isSameType(ASTHelpers.getType((Tree)arg1), state.getSymtab().booleanType)) {
            return this.describeMatch(arg1, UnnecessaryCheckNotNull.createCheckArgumentOrStateCall(methodInvocationTree, state, arg1));
        }
        return this.describeMatch(arg1, (Fix)SuggestedFix.delete((Tree)parent));
    }

    private static Fix createCheckArgumentOrStateCall(MethodInvocationTree methodInvocationTree, VisitorState state, ExpressionTree arg1) {
        String replacementMethod = "checkState";
        if (UnnecessaryCheckNotNull.hasMethodParameter(state.getPath(), arg1)) {
            replacementMethod = "checkArgument";
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String name = SuggestedFixes.qualifyStaticImport((String)("com.google.common.base.Preconditions." + replacementMethod), (SuggestedFix.Builder)fix, (VisitorState)state);
        fix.replace((Tree)methodInvocationTree.getMethodSelect(), name);
        return fix.build();
    }

    private static boolean hasMethodParameter(TreePath path, ExpressionTree tree) {
        HashSet<Symbol> symbols = new HashSet<Symbol>();
        for (IdentifierTree ident : UnnecessaryCheckNotNull.getVariableUses(tree)) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)ident);
            if (!ASTHelpers.isLocal((Symbol)symbol)) continue;
            symbols.add(symbol);
        }
        while (path != null && !(path.getLeaf() instanceof MethodTree)) {
            path = path.getParentPath();
        }
        if (path == null) {
            throw new IllegalStateException("Should have an enclosing method declaration");
        }
        MethodTree methodDecl = (MethodTree)path.getLeaf();
        for (VariableTree variableTree : methodDecl.getParameters()) {
            if (!symbols.contains(ASTHelpers.getSymbol((VariableTree)variableTree))) continue;
            return true;
        }
        return false;
    }

    static List<IdentifierTree> getVariableUses(ExpressionTree tree) {
        final ArrayList<IdentifierTree> freeVars = new ArrayList<IdentifierTree>();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void v) {
                if (((JCTree.JCIdent)node).sym instanceof Symbol.VarSymbol) {
                    freeVars.add(node);
                }
                return (Void)super.visitIdentifier(node, v);
            }
        }.scan(tree, null);
        return freeVars;
    }
}

