/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="JavaDurationWithSeconds", summary="Use of java.time.Duration.withSeconds(long) is not allowed.", explanation="Duration's withSeconds(long) method is often a source of bugs because it returns a copy of the current Duration instance, but _only_ the seconds field is mutated (the nanos field is copied directly). Use Duration.ofSeconds(seconds, duration.getNano()) instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class JavaDurationWithSeconds
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onExactClass("java.time.Duration").named("withSeconds").withParameters("long", new String[0]), Matchers.not((Matcher)Matchers.packageStartsWith((String)"java.time"))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        ExpressionTree secondsArg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        String replacement = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (String)"java.time.Duration") + ".ofSeconds(" + state.getSourceForNode((Tree)secondsArg) + ", " + state.getSourceForNode((Tree)receiver) + ".getNano())";
        builder.replace((Tree)tree, replacement);
        return this.describeMatch(tree, (Fix)builder.build());
    }
}

