/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="JodaInstantWithMillis", summary="Use of instant.withMillis(long) is not allowed. Please use new Instant(long) instead.", explanation="Joda-Time's 'instant.withMillis(long)' method is often a source of bugs because it doesn't mutate the current instance but rather returns a new immutable Instant instance. Please use new Instant(long) instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class JodaInstantWithMillis
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onExactClass("org.joda.time.Instant").named("withMillis").withParameters("long", new String[0]), Matchers.not((Matcher)Matchers.packageStartsWith((String)"org.joda.time"))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        String replacement = "new " + SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (String)"org.joda.time.Instant") + "(";
        ExpressionTree millisArg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        builder.replace(ASTHelpers.getStartPosition((Tree)tree), ASTHelpers.getStartPosition((Tree)millisArg), replacement);
        return this.describeMatch(tree, (Fix)builder.build());
    }
}

