/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class NullnessAnnotations {
    private static final Predicate<String> ANNOTATION_RELEVANT_TO_NULLNESS = Pattern.compile(".*\\b((Recently)?Nullable(Decl|Type)?|(Recently)?NotNull|NonNull(Decl|Type)?|Nonnull|CheckForNull|PolyNull|MonotonicNonNull(Decl)?)$").asPredicate();
    private static final Predicate<String> NULLABLE_ANNOTATION = Pattern.compile(".*\\b((Recently)?Nullable(Decl|Type)?|CheckForNull|PolyNull|MonotonicNonNull(Decl)?)$").asPredicate();

    private NullnessAnnotations() {
    }

    public static Optional<Nullness> fromAnnotations(Collection<String> annotations) {
        return NullnessAnnotations.fromAnnotationStream(annotations.stream());
    }

    public static Optional<Nullness> fromAnnotationsOn(@Nullable Symbol sym) {
        TypeMirror elementType;
        if (sym == null) {
            return Optional.empty();
        }
        switch (sym.getKind()) {
            case METHOD: {
                elementType = ((ExecutableElement)((Object)sym)).getReturnType();
                break;
            }
            case FIELD: 
            case PARAMETER: {
                elementType = sym.asType();
                break;
            }
            default: {
                elementType = null;
            }
        }
        Optional<Nullness> fromElement = NullnessAnnotations.fromAnnotationsOn(elementType);
        if (fromElement.isPresent()) {
            return fromElement;
        }
        return NullnessAnnotations.fromAnnotationStream(MoreAnnotations.getDeclarationAndTypeAttributes(sym).map(Object::toString));
    }

    public static Optional<Nullness> fromAnnotationsOn(@Nullable TypeMirror type) {
        if (type != null) {
            return NullnessAnnotations.fromAnnotationList(type.getAnnotationMirrors());
        }
        return Optional.empty();
    }

    public static Optional<Nullness> fromDefaultAnnotations(@Nullable Element sym) {
        while (sym != null) {
            if (sym.getAnnotationMirrors().stream().map(Object::toString).anyMatch(it -> it.endsWith(".DefaultNotNull"))) {
                return Optional.of(Nullness.NONNULL);
            }
            sym = sym.getEnclosingElement();
        }
        return Optional.empty();
    }

    public static Optional<Nullness> getUpperBound(TypeVariable typeVar) {
        Element genericElt;
        Optional<Nullness> result = typeVar.getUpperBound() instanceof IntersectionType ? NullnessAnnotations.fromAnnotationStream(((IntersectionType)typeVar.getUpperBound()).getBounds().stream().map(AnnotatedConstruct::getAnnotationMirrors).map(Object::toString)) : NullnessAnnotations.fromAnnotationsOn(typeVar.getUpperBound());
        if (result.isPresent()) {
            return result;
        }
        if (typeVar.asElement().getKind() == ElementKind.TYPE_PARAMETER && ((genericElt = ((TypeParameterElement)typeVar.asElement()).getGenericElement()).getKind().isClass() || genericElt.getKind().isInterface() || genericElt.getKind() == ElementKind.METHOD)) {
            result = ((Parameterizable)genericElt).getTypeParameters().stream().filter(typeParam -> typeParam.getSimpleName().equals(typeVar.asElement().getSimpleName())).findFirst().flatMap(decl -> NullnessAnnotations.fromAnnotationList(decl.getAnnotationMirrors()));
        }
        return result.isPresent() ? result : NullnessAnnotations.fromDefaultAnnotations(typeVar.asElement());
    }

    private static Optional<Nullness> fromAnnotationList(List<?> annotations) {
        return NullnessAnnotations.fromAnnotationStream(annotations.stream().map(Object::toString));
    }

    private static Optional<Nullness> fromAnnotationStream(Stream<String> annotations) {
        return annotations.filter(ANNOTATION_RELEVANT_TO_NULLNESS).map(annot -> NULLABLE_ANNOTATION.test((String)annot) ? Nullness.NULLABLE : Nullness.NONNULL).reduce(Nullness::greatestLowerBound);
    }
}

