/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;

@BugPattern(name="DistinctVarargsChecker", summary="Method expects distinct arguments at some/all positions", severity=BugPattern.SeverityLevel.WARNING)
public final class DistinctVarargsChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> IMMUTABLE_SET_VARARGS_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSet").named("of"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSortedSet").named("of")});
    private static final Matcher<ExpressionTree> ALL_DISTINCT_ARG_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.util.concurrent.Futures").withSignature("<V>whenAllSucceed(com.google.common.util.concurrent.ListenableFuture<? extends V>...)"), MethodMatchers.staticMethod().onClass("com.google.common.util.concurrent.Futures").withSignature("<V>whenAllComplete(com.google.common.util.concurrent.ListenableFuture<? extends V>...)"), MethodMatchers.staticMethod().onClass("com.google.common.collect.Ordering").withSignature("<T>explicit(T,T...)")});
    private static final Matcher<ExpressionTree> EVEN_PARITY_DISTINCT_ARG_MATCHER = MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSortedMap").named("of");
    private static final Matcher<ExpressionTree> EVEN_AND_ODD_PARITY_DISTINCT_ARG_MATCHER = MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableBiMap").named("of");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (IMMUTABLE_SET_VARARGS_MATCHER.matches((Tree)tree, state)) {
            return this.checkDistinctArgumentsWithFix(tree, state);
        }
        if (ALL_DISTINCT_ARG_MATCHER.matches((Tree)tree, state)) {
            return this.checkDistinctArguments(tree, tree.getArguments());
        }
        if (EVEN_PARITY_DISTINCT_ARG_MATCHER.matches((Tree)tree, state)) {
            ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
            for (int index = 0; index < tree.getArguments().size(); index += 2) {
                arguments.add(tree.getArguments().get(index));
            }
            return this.checkDistinctArguments(tree, arguments);
        }
        if (EVEN_AND_ODD_PARITY_DISTINCT_ARG_MATCHER.matches((Tree)tree, state)) {
            ArrayList<ExpressionTree> evenParityArguments = new ArrayList<ExpressionTree>();
            ArrayList<ExpressionTree> oddParityArguments = new ArrayList<ExpressionTree>();
            for (int index = 0; index < tree.getArguments().size(); ++index) {
                if (index % 2 == 0) {
                    evenParityArguments.add(tree.getArguments().get(index));
                    continue;
                }
                oddParityArguments.add(tree.getArguments().get(index));
            }
            return this.checkDistinctArguments(tree, evenParityArguments, oddParityArguments);
        }
        return Description.NO_MATCH;
    }

    private Description checkDistinctArgumentsWithFix(MethodInvocationTree tree, VisitorState state) {
        SuggestedFix.Builder suggestedFix = SuggestedFix.builder();
        for (int index = 1; index < tree.getArguments().size(); ++index) {
            boolean isDistinctArgument = true;
            for (int prevElementIndex = 0; prevElementIndex < index; ++prevElementIndex) {
                if (!ASTHelpers.sameVariable((ExpressionTree)tree.getArguments().get(index), (ExpressionTree)tree.getArguments().get(prevElementIndex))) continue;
                isDistinctArgument = false;
                break;
            }
            if (isDistinctArgument) continue;
            suggestedFix.merge(SuggestedFix.replace((int)state.getEndPosition((Tree)tree.getArguments().get(index - 1)), (int)state.getEndPosition((Tree)tree.getArguments().get(index)), (String)""));
        }
        if (suggestedFix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)suggestedFix.build());
    }

    private Description checkDistinctArguments(MethodInvocationTree tree, List<? extends ExpressionTree> ... argumentsList) {
        for (List<? extends ExpressionTree> arguments : argumentsList) {
            for (int firstArgumentIndex = 0; firstArgumentIndex < arguments.size(); ++firstArgumentIndex) {
                for (int secondArgumentIndex = firstArgumentIndex + 1; secondArgumentIndex < arguments.size(); ++secondArgumentIndex) {
                    if (!ASTHelpers.sameVariable((ExpressionTree)arguments.get(firstArgumentIndex), (ExpressionTree)arguments.get(secondArgumentIndex))) continue;
                    return this.describeMatch(tree);
                }
            }
        }
        return Description.NO_MATCH;
    }
}

