/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inlineme;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inlineme.AutoValue_Inliner_Api;
import com.google.errorprone.bugpatterns.inlineme.InlineMeData;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.google.errorprone.util.SideEffectAnalysis;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

@BugPattern(name="InlineMeInliner", summary="Callers of this API should be inlined.", severity=BugPattern.SeverityLevel.WARNING, tags={"JavaInlineMe"})
public final class Inliner
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    public static final String FINDING_TAG = "JavaInlineMe";
    static final String PREFIX_FLAG = "InlineMe:Prefix";
    static final String SKIP_COMMENTS_FLAG = "InlineMe:SkipInliningsWithComments";
    private static final Splitter PACKAGE_SPLITTER = Splitter.on((char)'.');
    private static final String CHECK_FIX_COMPILES = "InlineMe:CheckFixCompiles";
    private static final String INLINE_ME = "InlineMe";
    private static final String VALIDATION_DISABLED = "InlineMeValidationDisabled";
    private final ImmutableSet<String> apiPrefixes;
    private final boolean skipCallsitesWithComments;
    private final boolean checkFixCompiles;

    public Inliner(ErrorProneFlags flags) {
        this.apiPrefixes = ImmutableSet.copyOf((Collection)((Collection)flags.getSet(PREFIX_FLAG).orElse(ImmutableSet.of())));
        this.skipCallsitesWithComments = flags.getBoolean(SKIP_COMMENTS_FLAG).orElse(true);
        this.checkFixCompiles = flags.getBoolean(CHECK_FIX_COMPILES).orElse(false);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((NewClassTree)tree);
        if (!ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)symbol, (String)INLINE_ME)) {
            return Description.NO_MATCH;
        }
        ImmutableList callingVars = (ImmutableList)tree.getArguments().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(ImmutableList.toImmutableList());
        String receiverString = "new " + state.getSourceForNode((Tree)tree.getIdentifier());
        return this.match(tree, symbol, (ImmutableList<String>)callingVars, receiverString, null, state);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree methodSelectTree;
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (!ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)symbol, (String)INLINE_ME)) {
            return Description.NO_MATCH;
        }
        ImmutableList callingVars = (ImmutableList)tree.getArguments().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(ImmutableList.toImmutableList());
        String receiverString = "";
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (receiver != null) {
            receiverString = state.getSourceForNode((Tree)receiver);
        }
        if ((methodSelectTree = tree.getMethodSelect()) != null) {
            String methodSelect = state.getSourceForNode((Tree)methodSelectTree);
            if ("super".equals(methodSelect)) {
                receiverString = methodSelect;
            }
            if ("this".equals(methodSelect)) {
                receiverString = methodSelect;
            }
        }
        return this.match(tree, symbol, (ImmutableList<String>)callingVars, receiverString, receiver, state);
    }

    private Description match(ExpressionTree tree, Symbol.MethodSymbol symbol, ImmutableList<String> callingVars, String receiverString, ExpressionTree receiver, VisitorState state) {
        Optional<InlineMeData> inlineMe = InlineMeData.createFromSymbol(symbol);
        if (inlineMe.isEmpty()) {
            return Description.NO_MATCH;
        }
        Api api = Api.create(symbol, state);
        if (!this.matchesApiPrefixes(api)) {
            return Description.NO_MATCH;
        }
        if (this.skipCallsitesWithComments && ASTHelpers.stringContainsComments((CharSequence)state.getSourceForNode((Tree)tree), (Context)state.context)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        HashMap<String, String> typeNames = new HashMap<String, String>();
        for (String newImport : inlineMe.get().imports()) {
            String typeName = (String)Iterables.getLast((Iterable)PACKAGE_SPLITTER.split((CharSequence)newImport));
            String qualifiedTypeName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (String)newImport);
            typeNames.put(typeName, qualifiedTypeName);
        }
        for (String newStaticImport : inlineMe.get().staticImports()) {
            builder.addStaticImport(newStaticImport);
        }
        ImmutableList varNames = (ImmutableList)symbol.getParameters().stream().map(varSymbol -> ((Name)varSymbol.getSimpleName()).toString()).collect(ImmutableList.toImmutableList());
        boolean varargsWithEmptyArguments = false;
        if (symbol.isVarArgs()) {
            if (callingVars.size() == varNames.size() - 1) {
                varargsWithEmptyArguments = true;
            } else {
                ImmutableList nonvarargs = callingVars.subList(0, varNames.size() - 1);
                String varargsJoined = Joiner.on((String)", ").join((Iterable)callingVars.subList(varNames.size() - 1, callingVars.size()));
                callingVars = ImmutableList.builderWithExpectedSize((int)varNames.size()).addAll((Iterable)nonvarargs).add((Object)varargsJoined).build();
            }
        }
        String replacement = inlineMe.get().replacement();
        int replacementStart = ((JCDiagnostic.DiagnosticPosition)((Object)tree)).getStartPosition();
        int replacementEnd = state.getEndPosition((Tree)tree);
        if (replacement.startsWith("this.") && receiver != null) {
            replacementStart = state.getEndPosition((Tree)receiver);
            replacement = replacement.substring("this".length());
        }
        if (Strings.isNullOrEmpty((String)receiverString)) {
            replacement = replacement.replaceAll("\\bthis\\.\\b", "");
        } else {
            Object parent;
            if (replacement.equals("this") && (parent = state.getPath().getParentPath().getLeaf()) instanceof ExpressionStatementTree && !SideEffectAnalysis.hasSideEffect((ExpressionTree)receiver)) {
                return this.describe((Tree)parent, SuggestedFix.delete((Tree)parent), api);
            }
            replacement = replacement.replaceAll("\\bthis\\b", receiverString);
        }
        for (Map.Entry typeName : typeNames.entrySet()) {
            replacement = replacement.replaceAll("\\b" + Pattern.quote((String)typeName.getKey()) + "\\b", Matcher.quoteReplacement((String)typeName.getValue()));
        }
        for (int i = 0; i < varNames.size(); ++i) {
            boolean terminalVarargsReplacement = varargsWithEmptyArguments && i == varNames.size() - 1;
            String capturePrefixForVarargs = terminalVarargsReplacement ? "(?:,\\s*)?" : "";
            Pattern extractArgAndNextToken = Pattern.compile("\\b" + capturePrefixForVarargs + Pattern.quote((String)varNames.get(i)) + "\\b([^(])");
            String replacementResult = Matcher.quoteReplacement(terminalVarargsReplacement ? "" : (String)callingVars.get(i)) + "$1";
            Matcher matcher = extractArgAndNextToken.matcher(replacement);
            replacement = matcher.replaceAll(replacementResult);
        }
        builder.replace(replacementStart, replacementEnd, replacement);
        SuggestedFix fix = builder.build();
        if (this.checkFixCompiles && fix.getImportsToAdd().isEmpty()) {
            return SuggestedFixes.compilesWithFix((Fix)fix, (VisitorState)state) ? this.describe(tree, fix, api) : Description.NO_MATCH;
        }
        return this.describe(tree, fix, api);
    }

    private static ImmutableList<String> getStrings(Attribute.Compound attribute, String name) {
        return (ImmutableList)MoreAnnotations.getValue((Attribute.Compound)attribute, (String)name).map(MoreAnnotations::asStrings).orElse(Stream.empty()).collect(ImmutableList.toImmutableList());
    }

    private Description describe(Tree tree, SuggestedFix fix, Api api) {
        return this.buildDescription(tree).setMessage(api.message()).addFix((Fix)fix).build();
    }

    private boolean matchesApiPrefixes(Api api) {
        if (this.apiPrefixes.isEmpty()) {
            return true;
        }
        for (String apiPrefix : this.apiPrefixes) {
            if (!api.methodId().startsWith(apiPrefix)) continue;
            return true;
        }
        return false;
    }

    @AutoValue
    static abstract class Api {
        private static final Splitter CLASS_NAME_SPLITTER = Splitter.on((char)'.');

        Api() {
        }

        static Api create(Symbol.MethodSymbol method, VisitorState state) {
            Object extraMessage = "";
            if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)method, (String)Inliner.VALIDATION_DISABLED)) {
                Attribute.Compound inlineMeValidationDisabled = (Attribute.Compound)method.getRawAttributes().stream().filter(a -> ((Name)a.type.tsym.getSimpleName()).contentEquals(Inliner.VALIDATION_DISABLED)).collect(MoreCollectors.onlyElement());
                String reason = (String)Iterables.getOnlyElement(Inliner.getStrings(inlineMeValidationDisabled, "value"));
                extraMessage = " NOTE: this is an unvalidated inlining! Reasoning: " + reason;
            }
            return new AutoValue_Inliner_Api(method.owner.getQualifiedName().toString(), ((Name)method.getSimpleName()).toString(), ASTHelpers.enclosingPackage((Symbol)method).toString(), method.isConstructor(), ASTHelpers.hasAnnotation((Symbol)method, (String)"java.lang.Deprecated", (VisitorState)state), (String)extraMessage);
        }

        abstract String className();

        abstract String methodName();

        abstract String packageName();

        abstract boolean isConstructor();

        abstract boolean isDeprecated();

        abstract String extraMessage();

        final String message() {
            return "Migrate (via inlining) from " + (this.isDeprecated() ? "deprecated " : "") + this.shortName() + " to its replacement" + this.extraMessage();
        }

        final String methodId() {
            return String.format("%s#%s", this.className(), this.methodName());
        }

        final String shortName() {
            String humanReadableClassName = this.className().replaceFirst(this.packageName() + ".", "");
            return String.format("`%s.%s()`", humanReadableClassName, this.methodName());
        }

        final String simpleClassName() {
            return (String)Iterables.getLast((Iterable)CLASS_NAME_SPLITTER.split((CharSequence)this.className()));
        }
    }
}

