/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class SortIndex<T> {
    private final Comparator<? super T> comparator;
    private final List<Entry> list = new ArrayList<Entry>();
    private int[] positions;

    public SortIndex(Comparator<? super T> comparator) {
        this.comparator = comparator;
    }

    public void init(List<? extends T> items) {
        this.list.clear();
        int idx = 0;
        for (T i : items) {
            Entry entry = new Entry(idx++, i);
            this.list.add(entry);
        }
        Collections.sort(this.list);
        if (this.positions == null || this.positions.length < items.size()) {
            this.positions = new int[items.size()];
        }
        int pos = 0;
        for (Entry e : this.list) {
            this.positions[e.idx] = pos++;
        }
    }

    public int getPosition(int idx) {
        return this.positions[idx];
    }

    private class Entry
    implements Comparable<Entry> {
        final int idx;
        final T item;

        Entry(int idx, T item) {
            this.idx = idx;
            this.item = item;
        }

        @Override
        public int compareTo(Entry o) {
            return SortIndex.this.comparator.compare(this.item, o.item);
        }
    }
}

