/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import javax.lang.model.type.TypeMirror;

@BugPattern(summary="IdentityHashMap usage shouldn't be intermingled with Map", severity=BugPattern.SeverityLevel.WARNING)
public class IdentityHashMapUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String IDENTITY_HASH_MAP = "java.util.IdentityHashMap";
    private static final Matcher<ExpressionTree> IHM_ONE_ARG_METHODS = MethodMatchers.instanceMethod().onExactClass("java.util.IdentityHashMap").namedAnyOf(new String[]{"equals", "putAll"});
    private static final Matcher<ExpressionTree> IHM_CTOR_MAP_ARG = MethodMatchers.constructor().forClass("java.util.IdentityHashMap").withParameters("java.util.Map", new String[0]);
    private static final Supplier<Type> JAVA_UTIL_IDENTITYHASHMAP = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString(IDENTITY_HASH_MAP));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (IHM_ONE_ARG_METHODS.matches((Tree)tree, state) && !ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getArguments().get(0)), (Type)((Type)JAVA_UTIL_IDENTITYHASHMAP.get(state)), (VisitorState)state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        Type ihmType = (Type)JAVA_UTIL_IDENTITYHASHMAP.get(state);
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getExpression()), (Type)ihmType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getVariable()), (Type)ihmType, (VisitorState)state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() == null) {
            return Description.NO_MATCH;
        }
        Type ihmType = (Type)JAVA_UTIL_IDENTITYHASHMAP.get(state);
        if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getType()), (Type)ihmType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Type type = ASTHelpers.getType((Tree)tree.getInitializer());
        if (ASTHelpers.isSameType((Type)type, (Type)ihmType, (VisitorState)state)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            fix.replace(tree.getType(), SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)type));
            return this.describeMatch(tree, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (IHM_CTOR_MAP_ARG.matches((Tree)tree, state) && !ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getArguments().get(0)), (Type)((Type)JAVA_UTIL_IDENTITYHASHMAP.get(state)), (VisitorState)state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

