/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.org.plumelib.util;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.checkerframework.errorprone.checker.formatter.qual.UnknownFormat;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.interning.qual.Interned;
import org.checkerframework.errorprone.checker.interning.qual.UnknownInterned;
import org.checkerframework.errorprone.checker.lock.qual.GuardedBy;
import org.checkerframework.errorprone.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.errorprone.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.errorprone.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.regex.qual.UnknownRegex;
import org.checkerframework.errorprone.checker.signature.qual.SignatureUnknown;
import org.checkerframework.errorprone.common.initializedfields.qual.InitializedFields;
import org.checkerframework.errorprone.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;

public class DumpHeap {
    private static volatile @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object hotspotMBean;
    private static @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Method dumpHeapMethod;

    @EnsuresNonNull(value={"hotspotMBean", "dumpHeapMethod"})
    private static synchronized void initializeFields() {
        try {
            Class<?> mxbeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", mxbeanClass);
            dumpHeapMethod = mxbeanClass.getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (IOException | ClassNotFoundException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public static void dumpHeap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String fileName) {
        DumpHeap.dumpHeap(fileName, true);
    }

    public static void dumpHeap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String fileName, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean live) {
        DumpHeap.initializeFields();
        File heapFile = new File(fileName);
        if (heapFile.exists()) {
            heapFile.delete();
        }
        try {
            dumpHeapMethod.invoke(hotspotMBean, fileName, live);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Error(e);
        }
    }
}

