/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation.common.collect;

import com.google.monitoring.runtime.instrumentation.checker.nullness.compatqual.NullableDecl;
import com.google.monitoring.runtime.instrumentation.common.annotations.GwtCompatible;
import com.google.monitoring.runtime.instrumentation.common.annotations.GwtIncompatible;
import com.google.monitoring.runtime.instrumentation.common.collect.ImmutableList;
import com.google.monitoring.runtime.instrumentation.common.collect.ImmutableMap;
import com.google.monitoring.runtime.instrumentation.common.collect.ImmutableSet;
import com.google.monitoring.runtime.instrumentation.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Map;

@GwtCompatible(emulated=true)
abstract class ImmutableMapEntrySet<K, V>
extends ImmutableSet<Map.Entry<K, V>> {
    ImmutableMapEntrySet() {
    }

    abstract ImmutableMap<K, V> map();

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            V value = this.map().get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }
        return false;
    }

    @Override
    boolean isPartialView() {
        return this.map().isPartialView();
    }

    @Override
    @GwtIncompatible
    boolean isHashCodeFast() {
        return this.map().isHashCodeFast();
    }

    @Override
    public int hashCode() {
        return this.map().hashCode();
    }

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new EntrySetSerializedForm<K, V>(this.map());
    }

    @GwtIncompatible
    private static class EntrySetSerializedForm<K, V>
    implements Serializable {
        final ImmutableMap<K, V> map;
        private static final long serialVersionUID = 0L;

        EntrySetSerializedForm(ImmutableMap<K, V> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.entrySet();
        }
    }

    static final class RegularEntrySet<K, V>
    extends ImmutableMapEntrySet<K, V> {
        private final transient ImmutableMap<K, V> map;
        private final transient ImmutableList<Map.Entry<K, V>> entries;

        RegularEntrySet(ImmutableMap<K, V> map, Map.Entry<K, V>[] entries) {
            this(map, ImmutableList.asImmutableList(entries));
        }

        RegularEntrySet(ImmutableMap<K, V> map, ImmutableList<Map.Entry<K, V>> entries) {
            this.map = map;
            this.entries = entries;
        }

        @Override
        ImmutableMap<K, V> map() {
            return this.map;
        }

        @Override
        @GwtIncompatible(value="not used in GWT")
        int copyIntoArray(Object[] dst, int offset) {
            return this.entries.copyIntoArray(dst, offset);
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.entries.iterator();
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return this.entries;
        }
    }
}

