/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractMethodReturnsNull;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.Optional;

abstract class AbstractAsyncTypeReturnsNull
extends AbstractMethodReturnsNull {
    AbstractAsyncTypeReturnsNull(Class<?> asyncClass) {
        super(AbstractAsyncTypeReturnsNull.overridesMethodOfClass(asyncClass));
    }

    @Override
    protected Optional<Fix> provideFix(ReturnTree tree) {
        return Optional.of(SuggestedFix.builder().replace((Tree)tree.getExpression(), "immediateFuture(null)").addStaticImport(Futures.class.getName() + ".immediateFuture").build());
    }

    private static Matcher<MethodTree> overridesMethodOfClass(final Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        return new Matcher<MethodTree>(){

            public boolean matches(MethodTree tree, VisitorState state) {
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
                for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)state.getTypes())) {
                    if (superMethod.owner == null || !superMethod.owner.getQualifiedName().contentEquals(clazz.getName())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

