/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.flogger.GoogleLogger;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.unsafe.UnsafeProvider;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public final class DynamicCodec
implements ObjectCodec<Object> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final Class<?> type;
    private final TypeAndOffset[] fields;

    public DynamicCodec(Class<?> type) {
        this.type = type;
        this.fields = DynamicCodec.getOffsets(type);
    }

    @Override
    public Class<?> getEncodedClass() {
        return this.type;
    }

    @Override
    public ObjectCodec.MemoizationStrategy getStrategy() {
        return ObjectCodec.MemoizationStrategy.MEMOIZE_BEFORE;
    }

    @Override
    public void serialize(SerializationContext context, Object obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        for (TypeAndOffset fieldInfo : this.fields) {
            this.serializeField(context, codedOut, obj, fieldInfo.type, fieldInfo.offset);
        }
    }

    private void serializeField(SerializationContext context, CodedOutputStream codedOut, Object obj, Class<?> type, long offset) throws SerializationException, IOException {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                codedOut.writeBoolNoTag(UnsafeProvider.unsafe().getBoolean(obj, offset));
            } else if (type.equals(Byte.TYPE)) {
                codedOut.writeRawByte(UnsafeProvider.unsafe().getByte(obj, offset));
            } else if (type.equals(Short.TYPE)) {
                ByteBuffer buffer = ByteBuffer.allocate(2).putShort(UnsafeProvider.unsafe().getShort(obj, offset));
                codedOut.writeRawBytes(buffer);
            } else if (type.equals(Character.TYPE)) {
                ByteBuffer buffer = ByteBuffer.allocate(2).putChar(UnsafeProvider.unsafe().getChar(obj, offset));
                codedOut.writeRawBytes(buffer);
            } else if (type.equals(Integer.TYPE)) {
                codedOut.writeInt32NoTag(UnsafeProvider.unsafe().getInt(obj, offset));
            } else if (type.equals(Long.TYPE)) {
                codedOut.writeInt64NoTag(UnsafeProvider.unsafe().getLong(obj, offset));
            } else if (type.equals(Float.TYPE)) {
                codedOut.writeFloatNoTag(UnsafeProvider.unsafe().getFloat(obj, offset));
            } else if (type.equals(Double.TYPE)) {
                codedOut.writeDoubleNoTag(UnsafeProvider.unsafe().getDouble(obj, offset));
            } else if (!type.equals(Void.TYPE)) {
                throw new UnsupportedOperationException("Unknown primitive type: " + type);
            }
        } else if (type.isArray()) {
            Object arr = UnsafeProvider.unsafe().getObject(obj, offset);
            if (type.getComponentType().equals(Byte.TYPE)) {
                if (arr == null) {
                    codedOut.writeBoolNoTag(false);
                } else {
                    codedOut.writeBoolNoTag(true);
                    codedOut.writeByteArrayNoTag((byte[])arr);
                }
                return;
            }
            if (arr == null) {
                codedOut.writeInt32NoTag(-1);
                return;
            }
            int length = Array.getLength(arr);
            codedOut.writeInt32NoTag(length);
            int base = UnsafeProvider.unsafe().arrayBaseOffset(type);
            int scale = UnsafeProvider.unsafe().arrayIndexScale(type);
            if (scale == 0) {
                throw new SerializationException("Failed to get index scale for type: " + type);
            }
            for (int i = 0; i < length; ++i) {
                this.serializeField(context, codedOut, arr, type.getComponentType(), base + scale * i);
            }
        } else {
            try {
                context.serialize(UnsafeProvider.unsafe().getObject(obj, offset), codedOut);
            }
            catch (SerializationException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Unserializable object and superclass: %s %s", obj, obj.getClass().getSuperclass());
                e.addTrail(this.type);
                throw e;
            }
        }
    }

    @Override
    public Object deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        Object instance;
        try {
            instance = UnsafeProvider.unsafe().allocateInstance(this.type);
        }
        catch (ReflectiveOperationException e) {
            throw new SerializationException("Could not instantiate object of type: " + this.type, e);
        }
        context.registerInitialValue(instance);
        for (TypeAndOffset fieldInfo : this.fields) {
            this.deserializeField(context, codedIn, instance, fieldInfo.type, fieldInfo.offset);
        }
        return instance;
    }

    private void deserializeField(DeserializationContext context, CodedInputStream codedIn, Object obj, Class<?> fieldType, long offset) throws SerializationException, IOException {
        if (fieldType.isPrimitive()) {
            if (fieldType.equals(Boolean.TYPE)) {
                UnsafeProvider.unsafe().putBoolean(obj, offset, codedIn.readBool());
            } else if (fieldType.equals(Byte.TYPE)) {
                UnsafeProvider.unsafe().putByte(obj, offset, codedIn.readRawByte());
            } else if (fieldType.equals(Short.TYPE)) {
                ByteBuffer buffer = ByteBuffer.allocate(2).put(codedIn.readRawBytes(2));
                UnsafeProvider.unsafe().putShort(obj, offset, buffer.getShort(0));
            } else if (fieldType.equals(Character.TYPE)) {
                ByteBuffer buffer = ByteBuffer.allocate(2).put(codedIn.readRawBytes(2));
                UnsafeProvider.unsafe().putChar(obj, offset, buffer.getChar(0));
            } else if (fieldType.equals(Integer.TYPE)) {
                UnsafeProvider.unsafe().putInt(obj, offset, codedIn.readInt32());
            } else if (fieldType.equals(Long.TYPE)) {
                UnsafeProvider.unsafe().putLong(obj, offset, codedIn.readInt64());
            } else if (fieldType.equals(Float.TYPE)) {
                UnsafeProvider.unsafe().putFloat(obj, offset, codedIn.readFloat());
            } else if (fieldType.equals(Double.TYPE)) {
                UnsafeProvider.unsafe().putDouble(obj, offset, codedIn.readDouble());
            } else if (!fieldType.equals(Void.TYPE)) {
                throw new UnsupportedOperationException("Unknown primitive field type " + fieldType + " for " + this.type);
            }
        } else if (fieldType.isArray()) {
            if (fieldType.getComponentType().equals(Byte.TYPE)) {
                if (codedIn.readBool()) {
                    UnsafeProvider.unsafe().putObject(obj, offset, codedIn.readByteArray());
                }
                return;
            }
            int length = codedIn.readInt32();
            if (length < 0) {
                return;
            }
            Object arr = Array.newInstance(fieldType.getComponentType(), length);
            UnsafeProvider.unsafe().putObject(obj, offset, arr);
            int base = UnsafeProvider.unsafe().arrayBaseOffset(fieldType);
            int scale = UnsafeProvider.unsafe().arrayIndexScale(fieldType);
            if (scale == 0) {
                throw new SerializationException("Failed to get index scale for field type " + fieldType + " for " + this.type);
            }
            for (int i = 0; i < length; ++i) {
                this.deserializeField(context, codedIn, arr, fieldType.getComponentType(), base + scale * i);
            }
        } else {
            Object fieldValue;
            try {
                fieldValue = context.deserialize(codedIn);
            }
            catch (SerializationException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Failed to deserialize object with superclass: %s %s", obj, obj.getClass().getSuperclass());
                e.addTrail(this.type);
                throw e;
            }
            if (fieldValue == null) {
                return;
            }
            if (!fieldType.isInstance(fieldValue)) {
                throw new SerializationException("Field " + fieldValue + " was not instance of " + fieldType + " (was " + fieldValue.getClass() + ") for " + this.type);
            }
            UnsafeProvider.unsafe().putObject(obj, offset, fieldValue);
        }
    }

    private static <T> TypeAndOffset[] getOffsets(Class<T> type) {
        TreeMap<Field, Long> fields = new TreeMap<Field, Long>(new FieldComparator());
        for (Class<T> next = type; next != null; next = next.getSuperclass()) {
            for (Field field : next.getDeclaredFields()) {
                if ((field.getModifiers() & 0x88) != 0) continue;
                fields.put(field, UnsafeProvider.unsafe().objectFieldOffset(field));
            }
        }
        TypeAndOffset[] fieldsArr = new TypeAndOffset[fields.size()];
        int i = 0;
        for (Map.Entry entry : fields.entrySet()) {
            fieldsArr[i++] = new TypeAndOffset(entry.getKey().getType(), (Long)entry.getValue());
        }
        return fieldsArr;
    }

    private static final class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field f1, Field f2) {
            int classCompare = f1.getDeclaringClass().getName().compareTo(f2.getDeclaringClass().getName());
            if (classCompare != 0) {
                return classCompare;
            }
            return f1.getName().compareTo(f2.getName());
        }
    }

    private static final class TypeAndOffset {
        private final Class<?> type;
        private final long offset;

        private TypeAndOffset(Class<?> type, long offset) {
            this.type = type;
            this.offset = offset;
        }
    }
}

