/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

public class ImmutableTableCodec<R, C, V>
implements ObjectCodec<ImmutableTable<R, C, V>> {
    @Override
    public Class<ImmutableTable<R, C, V>> getEncodedClass() {
        return ImmutableTable.class;
    }

    @Override
    public void serialize(SerializationContext context, ImmutableTable<R, C, V> object, CodedOutputStream codedOut) throws SerializationException, IOException {
        ImmutableSet cellSet = object.cellSet();
        codedOut.writeInt32NoTag(cellSet.size());
        for (Table.Cell cell : cellSet) {
            context.serialize(cell.getRowKey(), codedOut);
            context.serialize(cell.getColumnKey(), codedOut);
            context.serialize(cell.getValue(), codedOut);
        }
    }

    @Override
    public ImmutableTable<R, C, V> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int length = codedIn.readInt32();
        if (length < 0) {
            throw new SerializationException("Expected non-negative length: " + length);
        }
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (int i = 0; i < length; ++i) {
            builder.put(context.deserialize(codedIn), context.deserialize(codedIn), context.deserialize(codedIn));
        }
        return builder.buildOrThrow();
    }
}

