/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Return;
import lombok.ast.StrictListAccessor;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;

public class CleanupDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue RECYCLE_RESOURCE = Issue.create((String)"Recycle", (String)"Missing `recycle()` calls", (String)"Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled (with a `recycle()` call) after use. This lint check looks for missing `recycle()` calls.", (Category)Category.PERFORMANCE, (int)7, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue COMMIT_FRAGMENT = Issue.create((String)"CommitTransaction", (String)"Missing `commit()` calls", (String)"After creating a `FragmentTransaction`, you typically need to commit it as well", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    private static final String RECYCLE = "recycle";
    private static final String RELEASE = "release";
    private static final String OBTAIN = "obtain";
    private static final String SHOW = "show";
    private static final String ACQUIRE_CPC = "acquireContentProviderClient";
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    private static final String COMMIT = "commit";
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    private static final String QUERY = "query";
    private static final String RAW_QUERY = "rawQuery";
    private static final String QUERY_WITH_FACTORY = "queryWithFactory";
    private static final String RAW_QUERY_WITH_FACTORY = "rawQueryWithFactory";
    private static final String CLOSE = "close";
    private static final String MOTION_EVENT_CLS = "android.view.MotionEvent";
    private static final String PARCEL_CLS = "android.os.Parcel";
    private static final String TYPED_ARRAY_CLS = "android.content.res.TypedArray";
    private static final String VELOCITY_TRACKER_CLS = "android.view.VelocityTracker";
    private static final String DIALOG_FRAGMENT = "android.app.DialogFragment";
    private static final String DIALOG_V4_FRAGMENT = "android.support.v4.app.DialogFragment";
    private static final String FRAGMENT_MANAGER_CLS = "android.app.FragmentManager";
    private static final String FRAGMENT_MANAGER_V4_CLS = "android.support.v4.app.FragmentManager";
    private static final String FRAGMENT_TRANSACTION_CLS = "android.app.FragmentTransaction";
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android.support.v4.app.FragmentTransaction";
    public static final String SURFACE_CLS = "android.view.Surface";
    public static final String SURFACE_TEXTURE_CLS = "android.graphics.SurfaceTexture";
    public static final String CONTENT_PROVIDER_CLIENT_CLS = "android.content.ContentProviderClient";
    public static final String CONTENT_RESOLVER_CLS = "android.content.ContentResolver";
    public static final String CONTENT_PROVIDER_CLS = "android.content.ContentProvider";
    public static final String SQLITE_DATABASE_CLS = "android.database.sqlite.SQLiteDatabase";
    public static final String CURSOR_CLS = "android.database.Cursor";

    public List<String> getApplicableMethodNames() {
        return Arrays.asList(BEGIN_TRANSACTION, OBTAIN, OBTAIN_NO_HISTORY, OBTAIN_STYLED_ATTRIBUTES, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, ACQUIRE_CPC, QUERY, RAW_QUERY, QUERY_WITH_FACTORY, RAW_QUERY_WITH_FACTORY);
    }

    public List<String> getApplicableConstructorTypes() {
        return Arrays.asList(SURFACE_TEXTURE_CLS, SURFACE_CLS);
    }

    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation node) {
        String name = node.astName().astValue();
        if (BEGIN_TRANSACTION.equals(name)) {
            CleanupDetector.checkTransactionCommits(context, node);
        } else {
            CleanupDetector.checkResourceRecycled(context, node, name);
        }
    }

    public void visitConstructor(JavaContext context, AstVisitor visitor, ConstructorInvocation node, JavaParser.ResolvedMethod constructor) {
        CleanupDetector.checkRecycled(context, (Node)node, constructor.getContainingClass().getSignature(), RELEASE);
    }

    private static void checkResourceRecycled(JavaContext context, MethodInvocation node, String name) {
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        JavaParser.ResolvedClass containingClass = method.getContainingClass();
        if ((OBTAIN.equals(name) || OBTAIN_NO_HISTORY.equals(name)) && containingClass.isSubclassOf(MOTION_EVENT_CLS, false)) {
            CleanupDetector.checkRecycled(context, (Node)node, MOTION_EVENT_CLS, RECYCLE);
        } else if (OBTAIN.equals(name) && containingClass.isSubclassOf(PARCEL_CLS, false)) {
            CleanupDetector.checkRecycled(context, (Node)node, PARCEL_CLS, RECYCLE);
        } else if (OBTAIN.equals(name) && containingClass.isSubclassOf(VELOCITY_TRACKER_CLS, false)) {
            CleanupDetector.checkRecycled(context, (Node)node, VELOCITY_TRACKER_CLS, RECYCLE);
        } else if ((OBTAIN_STYLED_ATTRIBUTES.equals(name) || OBTAIN_ATTRIBUTES.equals(name) || OBTAIN_TYPED_ARRAY.equals(name)) && (containingClass.isSubclassOf("android.content.Context", false) || containingClass.isSubclassOf("android.content.res.Resources", false))) {
            JavaParser.TypeDescriptor returnType = method.getReturnType();
            if (returnType != null && returnType.matchesSignature(TYPED_ARRAY_CLS)) {
                CleanupDetector.checkRecycled(context, (Node)node, TYPED_ARRAY_CLS, RECYCLE);
            }
        } else if (ACQUIRE_CPC.equals(name) && containingClass.isSubclassOf(CONTENT_RESOLVER_CLS, false)) {
            CleanupDetector.checkRecycled(context, (Node)node, CONTENT_PROVIDER_CLIENT_CLS, RELEASE);
        } else if ((QUERY.equals(name) || RAW_QUERY.equals(name) || QUERY_WITH_FACTORY.equals(name) || RAW_QUERY_WITH_FACTORY.equals(name)) && (containingClass.isSubclassOf(SQLITE_DATABASE_CLS, false) || containingClass.isSubclassOf(CONTENT_RESOLVER_CLS, false) || containingClass.isSubclassOf(CONTENT_PROVIDER_CLS, false) || containingClass.isSubclassOf(CONTENT_PROVIDER_CLIENT_CLS, false))) {
            CleanupDetector.checkRecycled(context, (Node)node, CURSOR_CLS, CLOSE);
        }
    }

    private static void checkRecycled(JavaContext context, Node node, final String recycleType, final String recycleName) {
        Node variableNode = CleanupDetector.getVariableNode(node);
        if (variableNode == null) {
            return;
        }
        JavaParser.ResolvedVariable boundVariable = CleanupDetector.getResolvedVariable(context, variableNode);
        if (boundVariable == null) {
            return;
        }
        Node method = JavaContext.findSurroundingMethod((Node)node);
        if (method == null) {
            return;
        }
        FinishVisitor visitor = new FinishVisitor(context, variableNode, boundVariable){

            @Override
            protected boolean isCleanupCall(MethodInvocation call) {
                Expression operand;
                JavaParser.ResolvedClass containingClass;
                String methodName = call.astName().astValue();
                if (!recycleName.equals(methodName)) {
                    return false;
                }
                JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)call);
                return resolved instanceof JavaParser.ResolvedMethod && (containingClass = ((JavaParser.ResolvedMethod)resolved).getContainingClass()).isSubclassOf(recycleType, false) && (operand = call.astOperand()) != null && (resolved = this.mContext.resolve((Node)operand)) != null && this.mVariables.contains(resolved);
            }
        };
        method.accept((AstVisitor)visitor);
        if (visitor.isCleanedUp() || visitor.variableEscapes()) {
            return;
        }
        String className = recycleType.substring(recycleType.lastIndexOf(46) + 1);
        String message = RECYCLE.equals(recycleName) ? String.format("This `%1$s` should be recycled after use with `#recycle()`", className) : String.format("This `%1$s` should be freed up after use with `#%2$s()`", className, recycleName);
        Node locationNode = node instanceof MethodInvocation ? ((MethodInvocation)node).astName() : node;
        Location location = context.getLocation(locationNode);
        context.report(RECYCLE_RESOURCE, node, location, message);
    }

    private static boolean checkTransactionCommits(JavaContext context, MethodInvocation node) {
        if (CleanupDetector.isBeginTransaction(context, node)) {
            JavaParser.ResolvedVariable boundVariable;
            Node variableNode = CleanupDetector.getVariableNode((Node)node);
            JavaParser.ResolvedVariable resolvedVariable = boundVariable = variableNode != null ? CleanupDetector.getResolvedVariable(context, variableNode) : null;
            if (boundVariable == null && CleanupDetector.isCommittedInChainedCalls(context, node)) {
                return true;
            }
            if (boundVariable != null) {
                Node method = JavaContext.findSurroundingMethod((Node)node);
                if (method == null) {
                    return true;
                }
                FinishVisitor commitVisitor = new FinishVisitor(context, variableNode, boundVariable){

                    @Override
                    protected boolean isCleanupCall(MethodInvocation call) {
                        Expression first;
                        JavaParser.ResolvedNode resolved;
                        StrictListAccessor arguments;
                        if (CleanupDetector.isTransactionCommitMethodCall(this.mContext, call)) {
                            Expression operand = call.astOperand();
                            if (operand != null) {
                                JavaParser.ResolvedNode resolved2 = this.mContext.resolve((Node)operand);
                                if (resolved2 != null && this.mVariables.contains(resolved2)) {
                                    return true;
                                }
                                if (resolved2 instanceof JavaParser.ResolvedMethod && operand instanceof MethodInvocation && CleanupDetector.isCommittedInChainedCalls(this.mContext, (MethodInvocation)operand)) {
                                    while (operand instanceof MethodInvocation) {
                                        operand = ((MethodInvocation)operand).astOperand();
                                    }
                                    if (operand instanceof VariableReference && (resolved2 = this.mContext.resolve((Node)operand)) != null && this.mVariables.contains(resolved2)) {
                                        return true;
                                    }
                                }
                            }
                        } else if (CleanupDetector.isShowFragmentMethodCall(this.mContext, call) && (arguments = call.astArguments()).size() == 2 && (resolved = this.mContext.resolve((Node)(first = (Expression)arguments.first()))) != null && this.mVariables.contains(resolved)) {
                            return true;
                        }
                        return false;
                    }
                };
                method.accept((AstVisitor)commitVisitor);
                if (commitVisitor.isCleanedUp() || commitVisitor.variableEscapes()) {
                    return true;
                }
            }
            String message = "This transaction should be completed with a `commit()` call";
            context.report(COMMIT_FRAGMENT, (Node)node, context.getLocation((Node)node.astName()), message);
        }
        return false;
    }

    private static boolean isCommittedInChainedCalls(JavaContext context, MethodInvocation node) {
        Node parent = node.getParent();
        while (parent instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)parent;
            if (CleanupDetector.isTransactionCommitMethodCall(context, methodInvocation) || CleanupDetector.isShowFragmentMethodCall(context, methodInvocation)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static boolean isTransactionCommitMethodCall(JavaContext context, MethodInvocation call) {
        String methodName = call.astName().astValue();
        return (COMMIT.equals(methodName) || COMMIT_ALLOWING_LOSS.equals(methodName)) && CleanupDetector.isMethodOnFragmentClass(context, call, FRAGMENT_TRANSACTION_CLS, FRAGMENT_TRANSACTION_V4_CLS, true);
    }

    private static boolean isShowFragmentMethodCall(JavaContext context, MethodInvocation call) {
        String methodName = call.astName().astValue();
        return SHOW.equals(methodName) && CleanupDetector.isMethodOnFragmentClass(context, call, DIALOG_FRAGMENT, DIALOG_V4_FRAGMENT, true);
    }

    private static boolean isMethodOnFragmentClass(JavaContext context, MethodInvocation call, String fragmentClass, String v4FragmentClass, boolean returnForUnresolved) {
        JavaParser.ResolvedNode resolved = context.resolve((Node)call);
        if (resolved instanceof JavaParser.ResolvedMethod) {
            JavaParser.ResolvedClass containingClass = ((JavaParser.ResolvedMethod)resolved).getContainingClass();
            return containingClass.isSubclassOf(fragmentClass, false) || containingClass.isSubclassOf(v4FragmentClass, false);
        }
        if (resolved == null) {
            return returnForUnresolved;
        }
        return false;
    }

    public static Node getVariableNode(Node expression) {
        Node parent = expression.getParent();
        if (parent instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)parent;
            if (binaryExpression.astOperator() == BinaryOperator.ASSIGN) {
                return binaryExpression.astLeft();
            }
        } else if (parent instanceof VariableDefinitionEntry) {
            return parent;
        }
        return null;
    }

    public static JavaParser.ResolvedVariable getResolvedVariable(JavaContext context, Node variable) {
        JavaParser.ResolvedNode resolved = context.resolve(variable);
        if (resolved instanceof JavaParser.ResolvedVariable) {
            return (JavaParser.ResolvedVariable)resolved;
        }
        return null;
    }

    private static boolean isBeginTransaction(JavaContext context, MethodInvocation node) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedClass containingClass;
        JavaParser.ResolvedNode resolved;
        String methodName = node.astName().astValue();
        assert (methodName.equals(BEGIN_TRANSACTION)) : methodName;
        return BEGIN_TRANSACTION.equals(methodName) && (resolved = context.resolve((Node)node)) instanceof JavaParser.ResolvedMethod && ((containingClass = (method = (JavaParser.ResolvedMethod)resolved).getContainingClass()).isSubclassOf(FRAGMENT_MANAGER_CLS, false) || containingClass.isSubclassOf(FRAGMENT_MANAGER_V4_CLS, false));
    }

    private static abstract class FinishVisitor
    extends ForwardingAstVisitor {
        protected final JavaContext mContext;
        protected final List<JavaParser.ResolvedVariable> mVariables;
        private final Node mOriginalVariableNode;
        private boolean mContainsCleanup;
        private boolean mEscapes;

        public FinishVisitor(JavaContext context, Node variableNode, JavaParser.ResolvedVariable variable) {
            this.mContext = context;
            this.mOriginalVariableNode = variableNode;
            this.mVariables = Lists.newArrayList((Object[])new JavaParser.ResolvedVariable[]{variable});
        }

        public boolean isCleanedUp() {
            return this.mContainsCleanup;
        }

        public boolean variableEscapes() {
            return this.mEscapes;
        }

        public boolean visitNode(Node node) {
            return this.mContainsCleanup || super.visitNode(node);
        }

        protected abstract boolean isCleanupCall(MethodInvocation var1);

        public boolean visitMethodInvocation(MethodInvocation call) {
            if (this.mContainsCleanup) {
                return true;
            }
            super.visitMethodInvocation(call);
            if (!this.mEscapes) {
                for (Expression expression : call.astArguments()) {
                    JavaParser.ResolvedMethod method;
                    JavaParser.ResolvedClass cls;
                    JavaParser.ResolvedNode r;
                    JavaParser.ResolvedNode resolved;
                    if (!(expression instanceof VariableReference) || (resolved = this.mContext.resolve((Node)expression)) == null || !this.mVariables.contains(resolved)) continue;
                    this.mEscapes = true;
                    if (!CleanupDetector.OBTAIN.equals(call.astName().astValue()) || !((r = this.mContext.resolve((Node)call)) instanceof JavaParser.ResolvedMethod) || !(cls = (method = (JavaParser.ResolvedMethod)r).getContainingClass()).matches(CleanupDetector.MOTION_EVENT_CLS)) continue;
                    this.mEscapes = false;
                }
            }
            if (this.isCleanupCall(call)) {
                this.mContainsCleanup = true;
                return true;
            }
            return false;
        }

        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
            JavaParser.ResolvedNode resolved;
            Expression initializer = node.astInitializer();
            if (initializer instanceof VariableReference && (resolved = this.mContext.resolve((Node)initializer)) != null && this.mVariables.contains(resolved)) {
                JavaParser.ResolvedNode resolvedVariable = this.mContext.resolve((Node)node);
                if (resolvedVariable instanceof JavaParser.ResolvedVariable) {
                    JavaParser.ResolvedVariable variable = (JavaParser.ResolvedVariable)resolvedVariable;
                    this.mVariables.add(variable);
                } else if (resolvedVariable instanceof JavaParser.ResolvedField) {
                    this.mEscapes = true;
                }
            }
            return super.visitVariableDefinitionEntry(node);
        }

        public boolean visitBinaryExpression(BinaryExpression node) {
            if (node.astOperator() == BinaryOperator.ASSIGN) {
                Expression lhs;
                JavaParser.ResolvedNode resolved;
                JavaParser.ResolvedNode resolved2;
                Expression rhs = node.astRight();
                boolean clearLhs = false;
                if (rhs instanceof VariableReference && (resolved2 = this.mContext.resolve((Node)rhs)) != null && this.mVariables.contains(resolved2)) {
                    clearLhs = false;
                    JavaParser.ResolvedNode resolvedLhs = this.mContext.resolve((Node)node.astLeft());
                    if (resolvedLhs instanceof JavaParser.ResolvedVariable) {
                        JavaParser.ResolvedVariable variable = (JavaParser.ResolvedVariable)resolvedLhs;
                        this.mVariables.add(variable);
                    } else if (resolvedLhs instanceof JavaParser.ResolvedField) {
                        this.mEscapes = true;
                    }
                }
                if (clearLhs && (resolved = this.mContext.resolve((Node)(lhs = node.astLeft()))) != null && !lhs.equals(this.mOriginalVariableNode) && this.mVariables.contains(resolved)) {
                    this.mVariables.remove(resolved);
                }
            }
            return super.visitBinaryExpression(node);
        }

        public boolean visitReturn(Return node) {
            JavaParser.ResolvedNode resolved;
            Expression value = node.astValue();
            if (value instanceof VariableReference && (resolved = this.mContext.resolve((Node)value)) != null && this.mVariables.contains(resolved)) {
                this.mEscapes = true;
            }
            return super.visitReturn(node);
        }
    }
}

