/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import java.util.OptionalInt;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class OptionalIntSubject
extends Subject {
    private final OptionalInt actual;

    OptionalIntSubject(FailureMetadata failureMetadata, @NullableDecl OptionalInt subject, @NullableDecl String typeDescription) {
        super(failureMetadata, (Object)subject, typeDescription);
        this.actual = subject;
    }

    public void isPresent() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact((String)"expected present optional"), new Fact[0]);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact((String)"expected to be present"), new Fact[0]);
        }
    }

    public void isEmpty() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact((String)"expected empty optional"), new Fact[0]);
        } else if (this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact((String)"expected to be empty"), new Fact[]{Fact.fact((String)"but was present with value", (Object)this.actual.getAsInt())});
        }
    }

    public void hasValue(int expected) {
        if (this.actual == null) {
            this.failWithActual("expected an optional with value", expected);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.fact((String)"expected to have value", (Object)expected), new Fact[]{Fact.simpleFact((String)"but was absent")});
        } else {
            this.checkNoNeedToDisplayBothValues("getAsInt()", new Object[0]).that(Integer.valueOf(this.actual.getAsInt())).isEqualTo((Object)expected);
        }
    }

    public static Subject.Factory<OptionalIntSubject, OptionalInt> optionalInts() {
        return (metadata, subject) -> new OptionalIntSubject(metadata, (OptionalInt)subject, "optionalInt");
    }
}

