/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.List;

@BugPattern(summary="BigDecimal#equals has surprising behavior: it also compares scale.", severity=BugPattern.SeverityLevel.WARNING)
public final class BigDecimalEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String BIG_DECIMAL = "java.math.BigDecimal";
    private static final Supplier<Type> JAVA_MATH_BIGDECIMAL = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString(BIG_DECIMAL));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Tree argument;
        Tree receiver;
        boolean handleNulls;
        List<? extends ExpressionTree> arguments = tree.getArguments();
        Type bigDecimal = (Type)JAVA_MATH_BIGDECIMAL.get(state);
        if (Matchers.staticEqualsInvocation().matches((Tree)tree, state)) {
            handleNulls = true;
            receiver = arguments.get(arguments.size() - 2);
            argument = (Tree)Iterables.getLast(arguments);
        } else if (Matchers.instanceEqualsInvocation().matches((Tree)tree, state)) {
            handleNulls = false;
            receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            argument = arguments.get(0);
        } else {
            return Description.NO_MATCH;
        }
        MethodTree enclosingMethod = (MethodTree)state.findEnclosing(new Class[]{MethodTree.class});
        if (enclosingMethod != null && Matchers.equalsMethodDeclaration().matches((Tree)enclosingMethod, state)) {
            return Description.NO_MATCH;
        }
        boolean isReceiverBigDecimal = ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)receiver), (Type)bigDecimal, (VisitorState)state);
        boolean isTargetBigDecimal = ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)argument), (Type)bigDecimal, (VisitorState)state);
        if (!isReceiverBigDecimal && !isTargetBigDecimal) {
            return Description.NO_MATCH;
        }
        if (isReceiverBigDecimal != isTargetBigDecimal) {
            return this.describeMatch(tree);
        }
        return this.describe(tree, state, receiver, argument, handleNulls);
    }

    private Description describe(MethodInvocationTree tree, VisitorState state, Tree receiver, Tree argument, boolean handleNulls) {
        return this.describeMatch(tree);
    }
}

