//
//  AppController.m
//  BinaryClocken
//
//  Created by John Schilling on Thu Jan 15 2004.
//  Copyright (c) 2004 John Schilling. All rights reserved.
//

#import "AppController.h"

#define CLOCK_CHECK_SECS 0.50

@implementation AppController



#pragma mark
#pragma mark PUBLIC INSTANCE METHODS
#pragma mark

- (id)init
{
        if( ![super init] ) return nil;
        return self;
}


- (void)awakeFromNib
{
        [_clockWindow setAlphaValue:0.0];
        [[_clockWindow contentView] setMenu:_clockMenu];
        
        [_LED_H0_01 setMenu:_clockMenu];
        [_LED_H0_02 setMenu:_clockMenu];
        [_LED_H1_01 setMenu:_clockMenu];
        [_LED_H1_02 setMenu:_clockMenu];
        [_LED_H1_03 setMenu:_clockMenu];
        [_LED_H1_04 setMenu:_clockMenu];
        [_LED_M0_01 setMenu:_clockMenu];
        [_LED_M0_02 setMenu:_clockMenu];
        [_LED_M0_03 setMenu:_clockMenu];
        [_LED_M1_01 setMenu:_clockMenu];
        [_LED_M1_02 setMenu:_clockMenu];
        [_LED_M1_03 setMenu:_clockMenu];
        [_LED_M1_04 setMenu:_clockMenu];
        [_LED_S0_01 setMenu:_clockMenu];
        [_LED_S0_02 setMenu:_clockMenu];
        [_LED_S0_03 setMenu:_clockMenu];
        [_LED_S1_01 setMenu:_clockMenu];
        [_LED_S1_02 setMenu:_clockMenu];
        [_LED_S1_03 setMenu:_clockMenu];
        [_LED_S1_04 setMenu:_clockMenu];
        
        [_prefsWindow center];

        _pref_handler = [[NSUserDefaults standardUserDefaults] retain];
        [self loadPrefs];
        
        [self setLEDcolors];
        [self setWindowLevel];
        [self setWindowStyle];
        [self setWindowShadow];
        [self setNeverHide];
        
        [self getCurrentTime:nil];
        [self initClocken];
        
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
        [self beginFade];
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
        [self savePrefs];
        [self restoreDockIcon]; 
}

- (void)applicationDidHide:(NSNotification *)aNotification
{
        if (_neverHide) [NSApp unhideWithoutActivation];
}

- (void)dealloc
{
        [_clockenTimer release];
        [_pref_handler release];
        [super dealloc];
}

- (void)restoreDockIcon
{
        [NSApp setApplicationIconImage: [NSImage imageNamed:@"NSApplicationIcon"]]; 
}

- (void)setAllMenuItems
{
        [self setWindowColorMenuItem];
        [self setWindowLevelMenuItem];
        [self setWindowStyleMenuItem];
        [self setWindowShadowMenuItem];
        [self setNeverHideMenuItem];
        [self setDockIconShitMenuItem];
        [self set24HourMenuItem];
}

- (IBAction)terminate:(id)sender
{
    if (!_fadeInProgress)
    {
        _fadeInProgress = YES;
        _fadeTimer = [[NSTimer scheduledTimerWithTimeInterval:0.05 target:self selector:@selector(fadeOut:) userInfo:nil repeats:YES] retain];
    }
}

- (void)beginFade
{
    if (!_fadeInProgress)
    {
        _fadeInProgress = YES;
        _fadeTimer = [[NSTimer scheduledTimerWithTimeInterval:0.05 target:self selector:@selector(fadeIn:) userInfo:nil repeats:YES] retain];
    }
}


- (void)fadeOut:(NSTimer *)theTimer
{
    if ([_clockWindow alphaValue] > 0.0) {
        [_clockWindow setAlphaValue:[_clockWindow alphaValue] - 0.2];
    } else {
        [_fadeTimer invalidate];
        [_fadeTimer release];
        _fadeTimer = nil;
        [NSApp terminate:self];
    }
}

- (void)fadeIn:(NSTimer *)theTimer
{
    if ([_clockWindow alphaValue] < 1.0) {
        [_clockWindow setAlphaValue:[_clockWindow alphaValue] + 0.2];
    } else {
        [_fadeTimer invalidate];
        [_fadeTimer release];
        [self setAllMenuItems];
        _fadeInProgress = NO;
    }
}


- (void)loadPrefs
{
        if ( ![_clockWindow  setFrameUsingName:@"clockWindow"] ) { [_clockWindow center]; }
        
        NSDictionary *appDefaults = [NSDictionary dictionaryWithObjectsAndKeys: 
                                        @"5", @"LEDcolor", 
                                        @"0", @"twentyFourHour", 
                                        @"0", @"windowLevel", 
                                        @"0", @"windowStyle", 
                                        @"1", @"windowShadowed", 
                                        @"0", @"neverHide", 
                                        @"0", @"doDockIconShit", 
                                        nil];
                                        
        [_pref_handler registerDefaults:appDefaults];
        
        _LEDcolor       = [_pref_handler integerForKey:@"LEDcolor"];
        _twentyFourHour = [_pref_handler integerForKey:@"twentyFourHour"];
        _windowLevel    = [_pref_handler integerForKey:@"windowLevel"];
        _windowStyle    = [_pref_handler integerForKey:@"windowStyle"];
        _windowShadowed = [_pref_handler integerForKey:@"windowShadowed"];
        _neverHide      = [_pref_handler integerForKey:@"neverHide"];
        _doDockIconShit = [_pref_handler integerForKey:@"doDockIconShit"];
}

- (void)savePrefs
{
        if (_prefs_saved) return;
        
        _prefs_saved = YES;
        
        [_clockWindow  saveFrameUsingName:@"clockWindow"];
        [_pref_handler setInteger: _LEDcolor forKey:@"LEDcolor"];
        [_pref_handler setInteger: _twentyFourHour forKey:@"twentyFourHour"];
        [_pref_handler setInteger: _windowLevel forKey:@"windowLevel"];
        [_pref_handler setInteger: _windowStyle forKey:@"windowStyle"];
        [_pref_handler setInteger: _windowShadowed forKey:@"windowShadowed"];
        [_pref_handler setInteger: _neverHide forKey:@"neverHide"];
        [_pref_handler setInteger: _doDockIconShit forKey:@"doDockIconShit"];
        
        [_pref_handler synchronize];
}

- (IBAction)openPrefsWindow:(id)sender
{
        [_PFColorMenu selectItemAtIndex:[_PFColorMenu indexOfItemWithTag:_LEDcolor]];
        [_PFStyleMatrix setState:YES atRow:0 column:_windowStyle];
        [_PFLevelMatrix setState:YES atRow:0 column:_windowLevel];
        
        [_PFWindowShadowedButton setState:_windowShadowed];
        [_PFNeverHideButton setState:_neverHide];
        [_PFDockIconShitButton setState:_doDockIconShit];
        
        [_prefsWindow makeKeyAndOrderFront:nil];
        [_prefsWindow display];
}






#pragma mark
#pragma mark INTERNAL INTERFACE METHODS
#pragma mark

- (void)setLEDcolors
{
        if (_LEDcolor == 1) {
            // red
            _LED_H0_num = 1;
            _LED_H1_num = 1;
            _LED_M0_num = 1;
            _LED_M1_num = 1;
            _LED_S0_num = 1;
            _LED_S1_num = 1;
        } else if (_LEDcolor == 2) {
            // orange
            _LED_H0_num = 2;
            _LED_H1_num = 2;
            _LED_M0_num = 2;
            _LED_M1_num = 2;
            _LED_S0_num = 2;
            _LED_S1_num = 2;
        } else if (_LEDcolor == 3) {
            // yellow
            _LED_H0_num = 3;
            _LED_H1_num = 3;
            _LED_M0_num = 3;
            _LED_M1_num = 3;
            _LED_S0_num = 3;
            _LED_S1_num = 3;
        } else if (_LEDcolor == 4) {
            // green
            _LED_H0_num = 4;
            _LED_H1_num = 4;
            _LED_M0_num = 4;
            _LED_M1_num = 4;
            _LED_S0_num = 4;
            _LED_S1_num = 4;
        } else if (_LEDcolor == 5) {
            // blue
            _LED_H0_num = 5;
            _LED_H1_num = 5;
            _LED_M0_num = 5;
            _LED_M1_num = 5;
            _LED_S0_num = 5;
            _LED_S1_num = 5;
        } else if (_LEDcolor == 6) {
            // purple
            _LED_H0_num = 6;
            _LED_H1_num = 6;
            _LED_M0_num = 6;
            _LED_M1_num = 6;
            _LED_S0_num = 6;
            _LED_S1_num = 6;
        } else if (_LEDcolor == 7) {
            // Mixed 1
            _LED_H0_num = 1;
            _LED_H1_num = 1;
            _LED_M0_num = 4;
            _LED_M1_num = 4;
            _LED_S0_num = 5;
            _LED_S1_num = 5;
        } else if (_LEDcolor == 8) {
            // Mixed 2
            _LED_H0_num = 1;
            _LED_H1_num = 1;
            _LED_M0_num = 2;
            _LED_M1_num = 2;
            _LED_S0_num = 3;
            _LED_S1_num = 3;
        } else if (_LEDcolor == 9) {
            // Mixed 3
            _LED_H0_num = 4;
            _LED_H1_num = 4;
            _LED_M0_num = 5;
            _LED_M1_num = 5;
            _LED_S0_num = 6;
            _LED_S1_num = 6;
        } else if (_LEDcolor == 10) {
            // Mixed 4
            _LED_H0_num = 1;
            _LED_H1_num = 2;
            _LED_M0_num = 3;
            _LED_M1_num = 4;
            _LED_S0_num = 5;
            _LED_S1_num = 6;
        } else if (_LEDcolor == 99) {
            // Pasty
            _LED_H0_num = 7;
            _LED_M0_num = 7;
            _LED_S0_num = 7;
            _LED_H1_num = 7;
            _LED_M1_num = 7;
            _LED_S1_num = 7;
        }


        [self setWindowColorMenuItem];
        [_PFColorMenu selectItemAtIndex:[_PFColorMenu indexOfItemWithTag:_LEDcolor]];
}

- (void)setWindowLevel
{
        if (_windowLevel == 0) {
            [_clockWindow setLevel: NSNormalWindowLevel];
        } else if (_windowLevel == 1) {
            [_clockWindow setLevel: NSFloatingWindowLevel];
        } else if (_windowLevel == 2) {
            [_clockWindow setLevel: CGWindowLevelForKey(kCGDesktopWindowLevelKey)];
        }
        
        [_PFLevelMatrix setState:YES atRow:0 column:_windowLevel];
        [self setWindowLevelMenuItem];
}

- (void)setWindowStyle
{
        if (_windowStyle == 0) {
            [_clockWindow setOpaque:YES];
            [_clockWindow setBackgroundColor:NULL];
        } else if (_windowStyle == 1) {
            [_clockWindow setOpaque:YES];
            [_clockWindow setBackgroundColor:[NSColor colorWithPatternImage:[NSImage imageNamed:@"wood.tif"]]];
        } else if (_windowStyle == 2) {
            [_clockWindow setOpaque:YES];
            [_clockWindow setBackgroundColor: [NSColor blackColor]];
        } else if (_windowStyle == 3) {
            [_clockWindow setOpaque:NO];
            [_clockWindow setBackgroundColor: [NSColor clearColor]];
        }
        
        [_clockWindow display];
        [_clockWindow invalidateShadow];
        
        [_PFStyleMatrix setState:YES atRow:0 column:_windowStyle];
        [self setWindowStyleMenuItem];
}

- (void)setWindowShadow
{
        [_clockWindow setHasShadow:_windowShadowed];
        [_clockWindow invalidateShadow];
        [_PFWindowShadowedButton setState:_windowShadowed];
        [self setWindowShadowMenuItem];
}

- (void)setNeverHide
{
        if ( _neverHide ) {
            if ( [NSApp isHidden] ) {
                [NSApp unhideWithoutActivation];
            }
        }
        [_PFNeverHideButton setState:_neverHide];
        [self setNeverHideMenuItem];
}


- (void)setDockIcon
{
        if ( !_doDockIconShit ) {
            [self restoreDockIcon];
        }
        [_PFDockIconShitButton setState:_doDockIconShit];
        [self setDockIconShitMenuItem];
}




#pragma mark
#pragma mark MENU ITEM APPEARANCE METHODS
#pragma mark

- (void)setWindowColorMenuItem
{
        [_CM_WindowColor1MenuItem setState:NSOffState];
        [_CM_WindowColor2MenuItem setState:NSOffState];
        [_CM_WindowColor3MenuItem setState:NSOffState];
        [_CM_WindowColor4MenuItem setState:NSOffState];
        [_CM_WindowColor5MenuItem setState:NSOffState];
        [_CM_WindowColor6MenuItem setState:NSOffState];
        [_CM_WindowColor7MenuItem setState:NSOffState];
        [_CM_WindowColor8MenuItem setState:NSOffState];
        [_CM_WindowColor9MenuItem setState:NSOffState];
        [_CM_WindowColor10MenuItem setState:NSOffState];
        
        if (_LEDcolor == 1) {
            [_CM_WindowColor1MenuItem setState:NSOnState];
        } else if (_LEDcolor == 2) {
            [_CM_WindowColor2MenuItem setState:NSOnState];
        } else if (_LEDcolor == 3) {
            [_CM_WindowColor3MenuItem setState:NSOnState];
        } else if (_LEDcolor == 4) {
            [_CM_WindowColor4MenuItem setState:NSOnState];
        } else if (_LEDcolor == 5) {
            [_CM_WindowColor5MenuItem setState:NSOnState];
        } else if (_LEDcolor == 6) {
            [_CM_WindowColor6MenuItem setState:NSOnState];
        } else if (_LEDcolor == 7) {
            [_CM_WindowColor7MenuItem setState:NSOnState];
        } else if (_LEDcolor == 8) {
            [_CM_WindowColor8MenuItem setState:NSOnState];
        } else if (_LEDcolor == 9) {
            [_CM_WindowColor9MenuItem setState:NSOnState];
        } else if (_LEDcolor == 10) {
            [_CM_WindowColor10MenuItem setState:NSOnState];
        }
}

- (void)set24HourMenuItem
{
        if (_twentyFourHour) {
            [_24hourMenuItem setState:NSOnState];
            [_CM_24hourMenuItem setState:NSOnState];
        } else {
            [_24hourMenuItem setState:NSOffState];
            [_CM_24hourMenuItem setState:NSOffState];
        }
}

- (void)setWindowLevelMenuItem
{
        [_CM_WindowLevelNormalMenuItem setState:NSOffState];
        [_CM_WindowLevelFloatingMenuItem setState:NSOffState];
        [_CM_WindowLevelDesktopMenuItem setState:NSOffState];
        
        if (_windowLevel == 0) {
            [_CM_WindowLevelNormalMenuItem setState:NSOnState];
        } else if (_windowLevel == 1) {
            [_CM_WindowLevelFloatingMenuItem setState:NSOnState];
        } else if (_windowLevel == 2) {
            [_CM_WindowLevelDesktopMenuItem setState:NSOnState];
        }
}

- (void)setWindowStyleMenuItem
{
        [_CM_WindowStyleWoodMenuItem setState:NSOffState];
        [_CM_WindowStyleMetalMenuItem setState:NSOffState];
        [_CM_WindowStyleBlackMenuItem setState:NSOffState];
        [_CM_WindowStyleClearMenuItem setState:NSOffState];
        
        if (_windowStyle == 0) {
            [_CM_WindowStyleMetalMenuItem setState:NSOnState];
        } else if (_windowStyle == 1) {
            [_CM_WindowStyleWoodMenuItem setState:NSOnState];
        } else if (_windowStyle == 2) {
            [_CM_WindowStyleBlackMenuItem setState:NSOnState];
        } else if (_windowStyle == 3) {
            [_CM_WindowStyleClearMenuItem setState:NSOnState];
        }
}

- (void)setWindowShadowMenuItem
{
        [_CM_WindowShadowedMenuItem setState:NSOffState];
        
        if (_windowShadowed) {
            [_CM_WindowShadowedMenuItem setState:NSOnState];
        }
}

- (void)setNeverHideMenuItem
{
        [_CM_NeverHideMenuItem setState:NSOnState];
        
        if (!_neverHide) {
            [_CM_NeverHideMenuItem setState:NSOffState];
        }
}

- (void)setDockIconShitMenuItem
{
        [_CM_DoDockIconShit setState:NSOffState];
        
        if (_doDockIconShit) {
            [_CM_DoDockIconShit setState:NSOnState];
        }
}








#pragma mark
#pragma mark PUBLIC IBACTION METHODS
#pragma mark

// Menu item sets
- (IBAction)handle24hour:(id)sender
{
        _twentyFourHour = !_twentyFourHour;
        [self set24HourMenuItem];
}

- (IBAction)handleClockColor:(id)sender
{
        _LEDcolor = [sender tag];
        [self setLEDcolors];
}

- (IBAction)handleWindowLevel:(id)sender
{
        _windowLevel = [sender tag];
        [self setWindowLevel];
}

- (IBAction)handleWindowStyle:(id)sender
{
        _windowStyle = [sender tag];
        [self setWindowStyle];
}

- (IBAction)toggleWindowShadow:(id)sender
{
        // For menu item
        _windowShadowed = !_windowShadowed;
        [self setWindowShadow];
}

- (IBAction)toggleNeverHide:(id)sender
{
        // For menu item
        _neverHide = !_neverHide;
        [self setNeverHide];
}


- (IBAction)toggleDockIconShit:(id)sender
{
        // For menu item
        _doDockIconShit = !_doDockIconShit;
        [self setDockIcon];
}


// Prefs window sets
- (IBAction)switchClockColor:(id)sender
{
        _LEDcolor = [[sender selectedItem] tag];
        [self setLEDcolors];
}

- (IBAction)switchWindowLevel:(id)sender
{
        _windowLevel = [[sender selectedCell] tag];
        [self setWindowLevel];
}

- (IBAction)switchWindowStyle:(id)sender
{
        _windowStyle = [[sender selectedCell] tag];
        [self setWindowStyle];
}

- (IBAction)switchWindowShadow:(id)sender
{
        // For NSButton
        _windowShadowed = [sender state];
        [self setWindowShadow];
}

- (IBAction)switchNeverHide:(id)sender
{
        // For NSButton
        _neverHide = [sender state];
        [self setNeverHide];
}


- (IBAction)switchDockIconShit:(id)sender
{
        // For NSButton
        _doDockIconShit = [sender state];
        [self setDockIcon];
}




#pragma mark
#pragma mark FOO METHODS
#pragma mark

- (void)setDockIconImage
{
        if ( !_doDockIconShit ) return;
        
        NSView *winView = [_clockWindow contentView];
        
        [winView lockFocus];
        
        NSBitmapImageRep *bits = [[[NSBitmapImageRep alloc] initWithFocusedViewRect:[winView bounds]] autorelease];
        
        [winView unlockFocus];
        
        NSImage *myImage = [[[NSImage alloc] init] autorelease];
        
        [myImage addRepresentation:bits];
        
        [NSApp setApplicationIconImage: myImage];
}



- (IBAction)eatPaste:(id)sender
{
        _LEDcolor = 99;
        [self setLEDcolors];
}




#pragma mark
#pragma mark CLOCK TIMER METHODS
#pragma mark


- (void)initClocken
{
        if ( _clockenTimer != nil ) { [_clockenTimer invalidate]; }
        if ( _clockenTimer != nil ) { [_clockenTimer release]; }
        _clockenTimer = [[NSTimer scheduledTimerWithTimeInterval:(float)CLOCK_CHECK_SECS target:self selector:@selector(getCurrentTime:) userInfo:nil repeats:YES] retain];
}



- (void)getCurrentTime:(NSTimer *)timer
{
        NSCalendarDate *today = [NSCalendarDate calendarDate];
        
        int nhour = [today hourOfDay];
        
        if (nhour == NULL || nhour == 0) {
            if (_twentyFourHour) {
                nhour = 0;
            } else {
                nhour = 12;
            }
        }
        
        if (!_twentyFourHour && nhour > 12 ) {
                nhour = nhour - 12;
        }
        
        NSString *hour = [NSString stringWithFormat:@"%02d", nhour];
        int h1 = [[hour substringWithRange:NSMakeRange(0,1)] intValue];
        int h2 = [[hour substringWithRange:NSMakeRange(1,1)] intValue];
        
        [self setHourFirst:h1];
        [self setHourSecond:h2];
        
        NSString *min = [NSString stringWithFormat:@"%02d", [today minuteOfHour]];
        int m1 = [[min substringWithRange:NSMakeRange(0,1)] intValue];
        int m2 = [[min substringWithRange:NSMakeRange(1,1)] intValue];
        [self setMinuteFirst:m1];
        [self setMinuteSecond:m2];
        
        NSString *sec = [NSString stringWithFormat:@"%02d", [today secondOfMinute]];
        int s1 = [[sec substringWithRange:NSMakeRange(0,1)] intValue];
        int s2 = [[sec substringWithRange:NSMakeRange(1,1)] intValue];
        [self setSecondFirst:s1];
        [self setSecondSecond:s2];
        
        [_clockWindow update];
        [self setDockIconImage];
}





// OK folks. I know there is a more elegant way to write this code.
// But I'm lazy. Please don't send me any emails with "tips" on
// how to be a better programmer, damnit.

#pragma mark
#pragma mark TIME DISPLAY METHODS
#pragma mark


- (void)setHourFirst:(int)h
{
    if (h == 0) {
        [_LED_H0_01 setImage:0];
        [_LED_H0_02 setImage:0];
    } else if (h == 1) {
        [_LED_H0_01 setImage:_LED_H0_num];
        [_LED_H0_02 setImage:0];
    } else if (h == 2) {
        [_LED_H0_01 setImage:0];
        [_LED_H0_02 setImage:_LED_H0_num];
    }
}

- (void)setHourSecond:(int)h
{
    if (h == 0) {
        [_LED_H1_01 setImage:0];
        [_LED_H1_02 setImage:0];
        [_LED_H1_03 setImage:0];
        [_LED_H1_04 setImage:0];
    } else if (h == 1) {
        [_LED_H1_01 setImage:_LED_H1_num];
        [_LED_H1_02 setImage:0];
        [_LED_H1_03 setImage:0];
        [_LED_H1_04 setImage:0];
    } else if (h == 2) {
        [_LED_H1_01 setImage:0];
        [_LED_H1_02 setImage:_LED_H1_num];
        [_LED_H1_03 setImage:0];
        [_LED_H1_04 setImage:0];
    } else if (h == 3) {
        [_LED_H1_01 setImage:_LED_H1_num];
        [_LED_H1_02 setImage:_LED_H1_num];
        [_LED_H1_03 setImage:0];
        [_LED_H1_04 setImage:0];    
    } else if (h == 4) {
        [_LED_H1_01 setImage:0];
        [_LED_H1_02 setImage:0];
        [_LED_H1_03 setImage:_LED_H1_num];
        [_LED_H1_04 setImage:0];    
    } else if (h == 5) {
        [_LED_H1_01 setImage:_LED_H1_num];
        [_LED_H1_02 setImage:0];
        [_LED_H1_03 setImage:_LED_H1_num];
        [_LED_H1_04 setImage:0];    
    } else if (h == 6) {
        [_LED_H1_01 setImage:0];
        [_LED_H1_02 setImage:_LED_H1_num];
        [_LED_H1_03 setImage:_LED_H1_num];
        [_LED_H1_04 setImage:0];    
    } else if (h == 7) {
        [_LED_H1_01 setImage:_LED_H1_num];
        [_LED_H1_02 setImage:_LED_H1_num];
        [_LED_H1_03 setImage:_LED_H1_num];
        [_LED_H1_04 setImage:0];    
    } else if (h == 8) {
        [_LED_H1_01 setImage:0];
        [_LED_H1_02 setImage:0];
        [_LED_H1_03 setImage:0];
        [_LED_H1_04 setImage:_LED_H1_num];    
    } else if (h == 9) {
        [_LED_H1_01 setImage:_LED_H1_num];
        [_LED_H1_02 setImage:0];
        [_LED_H1_03 setImage:0];
        [_LED_H1_04 setImage:_LED_H1_num];    
    }
}

- (void)setMinuteFirst:(int)m
{
    if (m == 0) {
        [_LED_M0_01 setImage:0];
        [_LED_M0_02 setImage:0];
        [_LED_M0_03 setImage:0];
    } else if (m == 1) {
        [_LED_M0_01 setImage:_LED_M0_num];
        [_LED_M0_02 setImage:0];
        [_LED_M0_03 setImage:0];
    } else if (m == 2) {
        [_LED_M0_01 setImage:0];
        [_LED_M0_02 setImage:_LED_M0_num];
        [_LED_M0_03 setImage:0];
    } else if (m == 3) {
        [_LED_M0_01 setImage:_LED_M0_num];
        [_LED_M0_02 setImage:_LED_M0_num];
        [_LED_M0_03 setImage:0];  
    } else if (m == 4) {
        [_LED_M0_01 setImage:0];
        [_LED_M0_02 setImage:0];
        [_LED_M0_03 setImage:_LED_M0_num];  
    } else if (m == 5) {
        [_LED_M0_01 setImage:_LED_M0_num];
        [_LED_M0_02 setImage:0];
        [_LED_M0_03 setImage:_LED_M0_num]; 
    }
}

- (void)setMinuteSecond:(int)m
{
    if (m == 0) {
        [_LED_M1_01 setImage:0];
        [_LED_M1_02 setImage:0];
        [_LED_M1_03 setImage:0];
        [_LED_M1_04 setImage:0];
    } else if (m == 1) {
        [_LED_M1_01 setImage:_LED_M1_num];
        [_LED_M1_02 setImage:0];
        [_LED_M1_03 setImage:0];
        [_LED_M1_04 setImage:0];
    } else if (m == 2) {
        [_LED_M1_01 setImage:0];
        [_LED_M1_02 setImage:_LED_M1_num];
        [_LED_M1_03 setImage:0];
        [_LED_M1_04 setImage:0];
    } else if (m == 3) {
        [_LED_M1_01 setImage:_LED_M1_num];
        [_LED_M1_02 setImage:_LED_M1_num];
        [_LED_M1_03 setImage:0];
        [_LED_M1_04 setImage:0];    
    } else if (m == 4) {
        [_LED_M1_01 setImage:0];
        [_LED_M1_02 setImage:0];
        [_LED_M1_03 setImage:_LED_M1_num];
        [_LED_M1_04 setImage:0];    
    } else if (m == 5) {
        [_LED_M1_01 setImage:_LED_M1_num];
        [_LED_M1_02 setImage:0];
        [_LED_M1_03 setImage:_LED_M1_num];
        [_LED_M1_04 setImage:0];    
    } else if (m == 6) {
        [_LED_M1_01 setImage:0];
        [_LED_M1_02 setImage:_LED_M1_num];
        [_LED_M1_03 setImage:_LED_M1_num];
        [_LED_M1_04 setImage:0];    
    } else if (m == 7) {
        [_LED_M1_01 setImage:_LED_M1_num];
        [_LED_M1_02 setImage:_LED_M1_num];
        [_LED_M1_03 setImage:_LED_M1_num];
        [_LED_M1_04 setImage:0];    
    } else if (m == 8) {
        [_LED_M1_01 setImage:0];
        [_LED_M1_02 setImage:0];
        [_LED_M1_03 setImage:0];
        [_LED_M1_04 setImage:_LED_M1_num];    
    } else if (m == 9) {
        [_LED_M1_01 setImage:_LED_M1_num];
        [_LED_M1_02 setImage:0];
        [_LED_M1_03 setImage:0];
        [_LED_M1_04 setImage:_LED_M1_num];    
    }
}

- (void)setSecondFirst:(int)s
{
    if (s == 0) {
        [_LED_S0_01 setImage:0];
        [_LED_S0_02 setImage:0];
        [_LED_S0_03 setImage:0];
    } else if (s == 1) {
        [_LED_S0_01 setImage:_LED_S0_num];
        [_LED_S0_02 setImage:0];
        [_LED_S0_03 setImage:0];
    } else if (s == 2) {
        [_LED_S0_01 setImage:0];
        [_LED_S0_02 setImage:_LED_S0_num];
        [_LED_S0_03 setImage:0];
    } else if (s == 3) {
        [_LED_S0_01 setImage:_LED_S0_num];
        [_LED_S0_02 setImage:_LED_S0_num];
        [_LED_S0_03 setImage:0];  
    } else if (s == 4) {
        [_LED_S0_01 setImage:0];
        [_LED_S0_02 setImage:0];
        [_LED_S0_03 setImage:_LED_S0_num];  
    } else if (s == 5) {
        [_LED_S0_01 setImage:_LED_S0_num];
        [_LED_S0_02 setImage:0];
        [_LED_S0_03 setImage:_LED_S0_num]; 
    }
}

- (void)setSecondSecond:(int)s
{
    if (s == 0) {
        [_LED_S1_01 setImage:0];
        [_LED_S1_02 setImage:0];
        [_LED_S1_03 setImage:0];
        [_LED_S1_04 setImage:0];
    } else if (s == 1) {
        [_LED_S1_01 setImage:_LED_S1_num];
        [_LED_S1_02 setImage:0];
        [_LED_S1_03 setImage:0];
        [_LED_S1_04 setImage:0];
    } else if (s == 2) {
        [_LED_S1_01 setImage:0];
        [_LED_S1_02 setImage:_LED_S1_num];
        [_LED_S1_03 setImage:0];
        [_LED_S1_04 setImage:0];
    } else if (s == 3) {
        [_LED_S1_01 setImage:_LED_S1_num];
        [_LED_S1_02 setImage:_LED_S1_num];
        [_LED_S1_03 setImage:0];
        [_LED_S1_04 setImage:0];    
    } else if (s == 4) {
        [_LED_S1_01 setImage:0];
        [_LED_S1_02 setImage:0];
        [_LED_S1_03 setImage:_LED_S1_num];
        [_LED_S1_04 setImage:0];    
    } else if (s == 5) {
        [_LED_S1_01 setImage:_LED_S1_num];
        [_LED_S1_02 setImage:0];
        [_LED_S1_03 setImage:_LED_S1_num];
        [_LED_S1_04 setImage:0];    
    } else if (s == 6) {
        [_LED_S1_01 setImage:0];
        [_LED_S1_02 setImage:_LED_S1_num];
        [_LED_S1_03 setImage:_LED_S1_num];
        [_LED_S1_04 setImage:0];    
    } else if (s == 7) {
        [_LED_S1_01 setImage:_LED_S1_num];
        [_LED_S1_02 setImage:_LED_S1_num];
        [_LED_S1_03 setImage:_LED_S1_num];
        [_LED_S1_04 setImage:0];    
    } else if (s == 8) {
        [_LED_S1_01 setImage:0];
        [_LED_S1_02 setImage:0];
        [_LED_S1_03 setImage:0];
        [_LED_S1_04 setImage:_LED_S1_num];    
    } else if (s == 9) {
        [_LED_S1_01 setImage:_LED_S1_num];
        [_LED_S1_02 setImage:0];
        [_LED_S1_03 setImage:0];
        [_LED_S1_04 setImage:_LED_S1_num];    
    }
}

@end
