/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import java.io.IOException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;

public class JDAPExtendedResponse
extends JDAPResult
implements JDAPProtocolOp {
    protected String m_oid = null;
    protected byte[] m_value = null;

    public JDAPExtendedResponse(BERElement bERElement) throws IOException {
        super(((BERTag)bERElement).getValue());
        BERSequence bERSequence = (BERSequence)((BERTag)bERElement).getValue();
        for (int i = 0; i < bERSequence.size(); ++i) {
            try {
                BERElement bERElement2 = bERSequence.elementAt(i);
                if (bERElement2.getType() != -1) continue;
                BERTag bERTag = (BERTag)bERElement2;
                switch (bERTag.getTag() & 0xF) {
                    case 10: {
                        BEROctetString bEROctetString = (BEROctetString)bERTag.getValue();
                        try {
                            this.m_oid = new String(bEROctetString.getValue(), "UTF8");
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                    case 11: {
                        BEROctetString bEROctetString = (BEROctetString)bERTag.getValue();
                        this.m_value = bEROctetString.getValue();
                    }
                }
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public int getType() {
        return 24;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public String getID() {
        return this.m_oid;
    }

    public String toString() {
        return "ExtendedResponse " + super.getParamString();
    }
}

