/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.factory;

import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPTLSSocketFactory;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;

public class JSSSocketFactory
implements Serializable,
LDAPTLSSocketFactory,
SSLCertificateApprovalCallback {
    static final long serialVersionUID = -6926469178017736903L;

    public JSSSocketFactory() throws LDAPException {
        JSSSocketFactory.initialize(".");
    }

    public JSSSocketFactory(String string) throws LDAPException {
        JSSSocketFactory.initialize(string);
    }

    public static void initialize(String string) throws LDAPException {
        try {
            CryptoManager.initialize((String)string);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to initialize JSSSocketFactory: " + exception.getMessage(), 80);
        }
    }

    public Socket makeSocket(String string, int n) throws LDAPException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = new SSLSocket(string, n, null, 0, (SSLCertificateApprovalCallback)this, null);
            sSLSocket.forceHandshake();
        }
        catch (UnknownHostException unknownHostException) {
            throw new LDAPException("JSSSocketFactory.makeSocket - Unknown host: " + string, 91);
        }
        catch (Exception exception) {
            throw new LDAPException("JSSSocketFactory.makeSocket " + string + ":" + n + ", " + exception.getMessage(), 91);
        }
        return sSLSocket;
    }

    public boolean approve(X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        return true;
    }

    public Socket makeSocket(Socket socket) throws LDAPException {
        SSLSocket sSLSocket = null;
        String string = socket.getInetAddress().getHostName();
        int n = socket.getPort();
        try {
            sSLSocket = new SSLSocket(socket, string, (SSLCertificateApprovalCallback)this, null);
            sSLSocket.forceHandshake();
        }
        catch (Exception exception) {
            throw new LDAPException("JSSSocketFactory - start TLS, " + exception.getMessage(), 112);
        }
        return sSLSocket;
    }
}

