/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.CompilerConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.classgen.CompilerFacade;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.syntax.SyntaxException;
import org.objectweb.asm.ClassWriter;

public class GroovyClassLoader
extends ClassLoader {
    private Map cache = new HashMap();
    private CompilerConfig config;
    private String[] paths;

    public GroovyClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public GroovyClassLoader(ClassLoader loader) {
        this(loader, new CompilerConfig());
    }

    public GroovyClassLoader(GroovyClassLoader parent) {
        this(parent, parent.config);
    }

    public GroovyClassLoader(ClassLoader loader, CompilerConfig config) {
        super(loader);
        this.config = config;
    }

    public Class defineClass(ClassNode classNode, String file) {
        CompileUnit unit = new CompileUnit(this.getParent(), this.config);
        ClassCollector compiler = this.createCollector(unit);
        compiler.generateClass(new GeneratorContext(unit), classNode, file);
        return compiler.generatedClass;
    }

    public Class parseClass(File file) throws SyntaxException, IOException {
        return this.parseClass(new FileInputStream(file), file.getName());
    }

    public Class parseClass(String text, String fileName) throws SyntaxException, IOException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), fileName);
    }

    public Class parseClass(String text) throws SyntaxException, IOException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(InputStream in) throws SyntaxException, IOException {
        return this.parseClass(in, "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(InputStream in, String fileName) throws SyntaxException, IOException {
        Class answer = (Class)this.cache.get(fileName);
        if (answer == null) {
            CompileUnit unit = new CompileUnit(this, this.config);
            ClassCollector compiler = this.createCollector(unit);
            compiler.parseClass(in, fileName);
            answer = compiler.generatedClass;
            this.cache.put(fileName, answer);
        }
        return answer;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String filename = name.replace('.', File.separatorChar) + ".groovy";
        String[] paths = this.getClassPath();
        for (int i = 0; i < paths.length; ++i) {
            String pathName = paths[i];
            File path = new File(pathName);
            if (!path.exists()) continue;
            if (path.isDirectory()) {
                File file = new File(path, filename);
                if (!file.exists()) continue;
                try {
                    return this.parseClass(file);
                }
                catch (SyntaxException e) {
                    e.printStackTrace();
                    throw new ClassNotFoundException("Syntax error in groovy file: " + filename, e);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ClassNotFoundException("Error reading groovy file: " + filename, e);
                }
            }
            try {
                JarFile jarFile = new JarFile(path);
                ZipEntry entry = jarFile.getEntry(filename);
                if (entry == null) continue;
                InputStream is = jarFile.getInputStream(entry);
                try {
                    return this.parseClass(is, filename);
                }
                catch (SyntaxException e1) {
                    e1.printStackTrace();
                    throw new ClassNotFoundException("Syntax error in groovy file: " + filename, e1);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    throw new ClassNotFoundException("Error reading groovy file: " + filename, e1);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    private String[] getClassPath() {
        if (this.paths == null) {
            ArrayList pathList = new ArrayList();
            String classpath = System.getProperty("java.class.path", ".");
            this.expandClassPath(pathList, "", classpath);
            this.paths = new String[pathList.size()];
            this.paths = pathList.toArray(this.paths);
            System.out.println(pathList);
        }
        return this.paths;
    }

    private void expandClassPath(List pathList, String base, String classpath) {
        this.paths = classpath.split(File.pathSeparator);
        for (int i = 0; i < this.paths.length; ++i) {
            File path = new File(base, this.paths[i]);
            if (!path.exists()) continue;
            if (!path.isDirectory()) {
                try {
                    JarFile jar = new JarFile(path);
                    pathList.add(this.paths[i]);
                    Manifest manifest = jar.getManifest();
                    Attributes classPathAttributes = manifest.getMainAttributes();
                    String manifestClassPath = classPathAttributes.getValue("Class-Path");
                    this.expandClassPath(pathList, this.paths[i], manifestClassPath);
                }
                catch (IOException e) {}
                continue;
            }
            pathList.add(this.paths[i]);
        }
    }

    protected Class loadClass(String name, byte[] bytecode) {
        return this.defineClass(name, bytecode, 0, bytecode.length);
    }

    protected ClassCollector createCollector(CompileUnit unit) {
        return new ClassCollector(this, unit);
    }

    private void debugWriteClassfile(ClassNode classNode, byte[] code) {
        String outputDir = this.config.getOutputDir();
        if (outputDir != null) {
            String filename = classNode.getName().replace('.', File.separatorChar) + ".class";
            int index = filename.lastIndexOf(File.separator);
            String dirname = index != -1 ? filename.substring(0, index) : "";
            File outputFile = new File(new File(outputDir), filename);
            System.err.println("Writing: " + outputFile);
            try {
                new File(new File(outputDir), dirname).mkdirs();
                FileOutputStream fos = new FileOutputStream(outputFile);
                fos.write(code, 0, code.length);
                fos.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    protected static class ClassCollector
    extends CompilerFacade {
        private Class generatedClass;
        private GroovyClassLoader cl;

        protected ClassCollector(GroovyClassLoader cl, CompileUnit unit) {
            super(cl, unit);
            this.cl = cl;
        }

        protected Class onClassNode(ClassWriter classWriter, ClassNode classNode) {
            byte[] code = classWriter.toByteArray();
            this.cl.debugWriteClassfile(classNode, code);
            Class theClass = this.cl.defineClass(classNode.getName(), code, 0, code.length);
            if (this.generatedClass == null) {
                this.generatedClass = theClass;
            }
            return theClass;
        }

        protected void onClass(ClassWriter classWriter, ClassNode classNode) {
            this.onClassNode(classWriter, classNode);
        }
    }
}

