/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import [Ljava.lang.Object;;
import groovy.lang.Closure;
import groovy.lang.CompilerConfig;
import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import groovy.lang.Tuple;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.classgen.CompilerFacade;
import org.codehaus.groovy.classgen.ReflectorGenerator;
import org.codehaus.groovy.runtime.ClosureListener;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.MethodHelper;
import org.codehaus.groovy.runtime.NewStaticMetaMethod;
import org.codehaus.groovy.runtime.ReflectionMetaMethod;
import org.codehaus.groovy.runtime.Reflector;
import org.codehaus.groovy.runtime.TemporaryMethodKey;
import org.codehaus.groovy.runtime.TransformMetaMethod;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class MetaClass {
    private static final Logger log = Logger.getLogger(MetaClass.class.getName());
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static Class[] EMPTY_TYPE_ARRAY = new Class[0];
    protected static final Object[] ARRAY_WITH_NULL = new Object[]{null};
    private static boolean useReflection = false;
    private MetaClassRegistry registry;
    private Class theClass;
    private ClassNode classNode;
    private Map methodIndex = new HashMap();
    private Map staticMethodIndex = new HashMap();
    private List newGroovyMethodsList = new ArrayList();
    private Map propertyDescriptors = Collections.synchronizedMap(new HashMap());
    private Map listeners = new HashMap();
    private Map methodCache = Collections.synchronizedMap(new HashMap());
    private Map staticMethodCache = Collections.synchronizedMap(new HashMap());
    private MetaMethod genericGetMethod;
    private MetaMethod genericSetMethod;
    private List constructors;
    private List allMethods = new ArrayList();
    private List interfaceMethods;
    private Reflector reflector;
    private boolean initialised;

    public MetaClass(MetaClassRegistry registry, Class theClass) throws IntrospectionException {
        this.registry = registry;
        this.theClass = theClass;
        this.constructors = Arrays.asList(theClass.getDeclaredConstructors());
        this.addMethods(theClass);
        BeanInfo info = Introspector.getBeanInfo(theClass);
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            this.propertyDescriptors.put(descriptor.getName(), descriptor);
        }
        EventSetDescriptor[] eventDescriptors = info.getEventSetDescriptors();
        for (int i = 0; i < eventDescriptors.length; ++i) {
            EventSetDescriptor descriptor = eventDescriptors[i];
            Method[] listenerMethods = descriptor.getListenerMethods();
            for (int j = 0; j < listenerMethods.length; ++j) {
                Method listenerMethod = listenerMethods[j];
                MetaMethod metaMethod = this.createMetaMethod(descriptor.getAddListenerMethod());
                this.listeners.put(listenerMethod.getName(), metaMethod);
            }
        }
    }

    public static boolean isUseReflection() {
        return useReflection;
    }

    public static void setUseReflection(boolean useReflection) {
        MetaClass.useReflection = useReflection;
    }

    private void addInheritendMethods(Class theClass) {
        Class c = theClass;
        if (c != Object.class) {
            while ((c = c.getSuperclass()) != (class$java$lang$Object == null ? MetaClass.class$("java.lang.Object") : class$java$lang$Object) && c != null) {
                this.addMethods(c);
                this.addNewStaticMethodsFrom(c);
            }
        }
        Class<?>[] interfaces = theClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.addNewStaticMethodsFrom(interfaces[i]);
        }
        if (theClass != Object.class) {
            this.addMethods(Object.class);
            this.addNewStaticMethodsFrom(Object.class);
        }
        if (theClass.isArray() && !theClass.equals(Object;.class)) {
            this.addNewStaticMethodsFrom(Object;.class);
        }
    }

    public List getMethods(String name) {
        List answer = (List)this.methodIndex.get(name);
        if (answer == null) {
            return Collections.EMPTY_LIST;
        }
        return answer;
    }

    public List getStaticMethods(String name) {
        List answer = (List)this.staticMethodIndex.get(name);
        if (answer == null) {
            return Collections.EMPTY_LIST;
        }
        return answer;
    }

    protected void addNewStaticInstanceMethod(Method method) {
        if (this.initialised) {
            throw new RuntimeException("Already initialized, cannot add new method: " + method);
        }
        NewStaticMetaMethod newMethod = new NewStaticMetaMethod(this.createMetaMethod(method));
        this.addMethod(newMethod);
        this.addNewStaticInstanceMethod(newMethod);
    }

    protected void addNewStaticInstanceMethod(MetaMethod method) {
        this.newGroovyMethodsList.add(method);
    }

    public Object invokeMethod(Object object, String methodName, Object arguments) {
        return this.invokeMethod(object, methodName, this.asArray(arguments));
    }

    public Object invokeMethod(Object object, String methodName, Object[] arguments) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method: " + methodName + " on null object");
        }
        TemporaryMethodKey methodKey = new TemporaryMethodKey(methodName, arguments);
        MetaMethod method = (MetaMethod)this.methodCache.get(methodKey);
        if (method == null && (method = this.pickMethod(object, methodName, arguments)) != null) {
            this.methodCache.put(methodKey.createCopy(), method);
        }
        if (method != null) {
            return this.doMethodInvoke(object, method, arguments);
        }
        throw new MissingMethodException(methodName, this.theClass, arguments);
    }

    protected MetaMethod pickMethod(Object object, String methodName, Object[] arguments) {
        MetaMethod method = null;
        List methods = this.getMethods(methodName);
        if (!methods.isEmpty() && (method = (MetaMethod)this.chooseMethod(methodName, methods, arguments, false)) == null && (method = (MetaMethod)this.chooseMethod(methodName, methods, arguments, true)) == null) {
            Object firstArgument;
            int size;
            int n = size = arguments != null ? arguments.length : 0;
            if (size == 1 && (firstArgument = arguments[0]) instanceof List) {
                List list = (List)firstArgument;
                arguments = list.toArray();
                method = (MetaMethod)this.chooseMethod(methodName, methods, arguments, true);
                return new TransformMetaMethod(method){

                    public Object invoke(Object object, Object[] arguments) throws Exception {
                        Object firstArgument = arguments[0];
                        List list = (List)firstArgument;
                        arguments = list.toArray();
                        return super.invoke(object, arguments);
                    }
                };
            }
        }
        return method;
    }

    public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
        TemporaryMethodKey methodKey = new TemporaryMethodKey(methodName, arguments);
        MetaMethod method = (MetaMethod)this.staticMethodCache.get(methodKey);
        if (method == null && (method = this.pickStaticMethod(object, methodName, arguments)) != null) {
            this.staticMethodCache.put(methodKey.createCopy(), method);
        }
        if (method != null) {
            return this.doMethodInvoke(object, method, arguments);
        }
        throw new MissingMethodException(methodName, this.theClass, arguments);
    }

    protected MetaMethod pickStaticMethod(Object object, String methodName, Object[] arguments) {
        MetaMethod method = null;
        List methods = this.getStaticMethods(methodName);
        if (!methods.isEmpty()) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, arguments, false);
        }
        if (method == null && this.theClass != Class.class) {
            MetaClass classMetaClass = this.registry.getMetaClass(Class.class);
            method = classMetaClass.pickMethod(object, methodName, arguments);
        }
        return method;
    }

    public Object invokeConstructor(Object[] arguments) {
        Object firstArgument;
        Constructor constructor = (Constructor)this.chooseMethod("<init>", this.constructors, arguments, false);
        if (constructor != null) {
            return this.doConstructorInvoke(constructor, arguments);
        }
        constructor = (Constructor)this.chooseMethod("<init>", this.constructors, arguments, true);
        if (constructor != null) {
            return this.doConstructorInvoke(constructor, arguments);
        }
        if (arguments.length == 1 && (firstArgument = arguments[0]) instanceof Map && (constructor = (Constructor)this.chooseMethod("<init>", this.constructors, EMPTY_ARRAY, false)) != null) {
            Object bean = this.doConstructorInvoke(constructor, EMPTY_ARRAY);
            this.setProperties(bean, (Map)firstArgument);
            return bean;
        }
        throw new GroovyRuntimeException("Could not find matching constructor for class: " + this.theClass.getName());
    }

    public void setProperties(Object bean, Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            this.setProperty(bean, key, value);
        }
    }

    public Object getProperty(Object object, String property) {
        Object[] arguments;
        Object answer;
        MetaMethod metaMethod = null;
        PropertyDescriptor descriptor = (PropertyDescriptor)this.propertyDescriptors.get(property);
        if (descriptor != null) {
            Method method = descriptor.getReadMethod();
            if (method == null) {
                throw new GroovyRuntimeException("Cannot read property: " + property);
            }
            metaMethod = this.findMethod(method);
            if (metaMethod == null) {
                metaMethod = this.findGetter(object, "get" + this.capitalize(property));
            }
        }
        if (metaMethod != null) {
            return this.doMethodInvoke(object, metaMethod, EMPTY_ARRAY);
        }
        if (this.genericGetMethod != null && (answer = this.doMethodInvoke(object, this.genericGetMethod, arguments = new Object[]{property})) != null) {
            return answer;
        }
        List methods = this.getMethods(property);
        if (!methods.isEmpty()) {
            return new MethodClosure(object, property);
        }
        GroovyRuntimeException lastException = null;
        try {
            MetaMethod method = this.findGetter(object, "get" + this.capitalize(property));
            if (method != null) {
                return this.doMethodInvoke(object, method, EMPTY_ARRAY);
            }
        }
        catch (GroovyRuntimeException e) {
            lastException = e;
        }
        if (this.genericGetMethod != null) {
            return null;
        }
        if (object instanceof Class) {
            return this.getStaticProperty((Class)object, property);
        }
        if (object instanceof Collection) {
            return DefaultGroovyMethods.getAt((Collection)object, property);
        }
        if (object instanceof Object[]) {
            return DefaultGroovyMethods.getAt(Arrays.asList((Object[])object), property);
        }
        MetaMethod addListenerMethod = (MetaMethod)this.listeners.get(property);
        if (addListenerMethod != null) {
            return null;
        }
        if (lastException == null) {
            throw new MissingPropertyException(property, this.theClass);
        }
        throw new MissingPropertyException(property, this.theClass, lastException);
    }

    public void setProperty(Object object, String property, Object newValue) {
        PropertyDescriptor descriptor = (PropertyDescriptor)this.propertyDescriptors.get(property);
        if (descriptor != null) {
            Method method = descriptor.getWriteMethod();
            if (method == null) {
                throw new ReadOnlyPropertyException(property, this.theClass);
            }
            MetaMethod metaMethod = this.findMethod(method);
            Object[] arguments = new Object[]{newValue};
            try {
                this.doMethodInvoke(object, metaMethod, arguments);
            }
            catch (GroovyRuntimeException e) {
                if (newValue instanceof List) {
                    List list = (List)newValue;
                    int params = list.size();
                    Constructor<?>[] constructors = descriptor.getPropertyType().getConstructors();
                    for (int i = 0; i < constructors.length; ++i) {
                        Constructor<?> constructor = constructors[i];
                        if (constructor.getParameterTypes().length != params) continue;
                        Object value = this.doConstructorInvoke(constructor, list.toArray());
                        this.doMethodInvoke(object, metaMethod, new Object[]{value});
                        return;
                    }
                }
                throw new MissingPropertyException(property, this.theClass, e);
            }
            return;
        }
        try {
            MetaMethod addListenerMethod = (MetaMethod)this.listeners.get(property);
            if (addListenerMethod != null && newValue instanceof Closure) {
                Object proxy = this.createListenerProxy(addListenerMethod.getParameterTypes()[0], property, (Closure)newValue);
                this.doMethodInvoke(object, addListenerMethod, new Object[]{proxy});
                return;
            }
            if (this.genericSetMethod != null) {
                Object[] arguments = new Object[]{property, newValue};
                this.doMethodInvoke(object, this.genericSetMethod, arguments);
                return;
            }
            String method = "set" + this.capitalize(property);
            this.invokeMethod(object, method, new Object[]{newValue});
        }
        catch (GroovyRuntimeException e) {
            throw new MissingPropertyException(property, this.theClass, e);
        }
    }

    public ClassNode getClassNode() {
        if (this.classNode == null && GroovyObject.class.isAssignableFrom(this.theClass)) {
            String className = this.theClass.getName();
            String groovyFile = className;
            int idx = groovyFile.indexOf(36);
            if (idx > 0) {
                groovyFile = groovyFile.substring(0, idx);
            }
            groovyFile = groovyFile.replace('.', '/') + ".groovy";
            URL url = this.theClass.getClassLoader().getResource(groovyFile);
            if (url == null) {
                url = Thread.currentThread().getContextClassLoader().getResource(groovyFile);
            }
            if (url != null) {
                try {
                    InputStream in = url.openStream();
                    CompilerFacade compiler = new CompilerFacade(this.theClass.getClassLoader(), new CompileUnit(this.getClass().getClassLoader(), new CompilerConfig())){

                        protected void onClass(ClassWriter classWriter, ClassNode classNode) {
                            if (classNode.getName().equals(MetaClass.this.theClass.getName())) {
                                MetaClass.this.classNode = classNode;
                            }
                        }
                    };
                    compiler.parseClass(in, groovyFile);
                }
                catch (Exception e) {
                    throw new GroovyRuntimeException("Exception thrown parsing: " + groovyFile + ". Reason: " + e, e);
                }
            }
        }
        return this.classNode;
    }

    public String toString() {
        return super.toString() + "[" + this.theClass + "]";
    }

    protected Object[] asArray(Object arguments) {
        if (arguments == null) {
            return EMPTY_ARRAY;
        }
        if (arguments instanceof Tuple) {
            Tuple tuple = (Tuple)arguments;
            return tuple.toArray();
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    protected Object createListenerProxy(Class listenerType, String listenerMethodName, Closure closure) {
        ClosureListener handler = new ClosureListener(listenerMethodName, closure);
        return Proxy.newProxyInstance(listenerType.getClassLoader(), new Class[]{listenerType}, (InvocationHandler)handler);
    }

    protected void addMethods(Class theClass) {
        Method[] methodArray = theClass.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            MetaMethod method = this.createMetaMethod(methodArray[i]);
            this.addMethod(method);
        }
    }

    protected void addMethod(MetaMethod method) {
        ArrayList<MetaMethod> list;
        String name = method.getName();
        if (this.isGenericGetMethod(method) && this.genericGetMethod == null) {
            this.genericGetMethod = method;
        } else if (this.isGenericSetMethod(method) && this.genericSetMethod == null) {
            this.genericSetMethod = method;
        }
        if (method.isStatic()) {
            list = (ArrayList<MetaMethod>)this.staticMethodIndex.get(name);
            if (list == null) {
                list = new ArrayList<MetaMethod>();
                this.staticMethodIndex.put(name, list);
                list.add(method);
            } else if (!this.containsMatchingMethod(list, method)) {
                list.add(method);
            }
        }
        if ((list = (List)this.methodIndex.get(name)) == null) {
            list = new ArrayList();
            this.methodIndex.put(name, list);
            list.add(method);
        } else if (!this.containsMatchingMethod(list, method)) {
            list.add(method);
        }
    }

    protected boolean containsMatchingMethod(List list, MetaMethod method) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Class[] params2;
            MetaMethod aMethod = (MetaMethod)iter.next();
            Class[] params1 = aMethod.getParameterTypes();
            if (params1.length != (params2 = method.getParameterTypes()).length) continue;
            boolean matches = true;
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    protected void addNewStaticMethodsFrom(Class theClass) {
        MetaClass interfaceMetaClass = this.registry.getMetaClass(theClass);
        Iterator iter = interfaceMetaClass.newGroovyMethodsList.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            this.addMethod(method);
            this.newGroovyMethodsList.add(method);
        }
    }

    protected Object getStaticProperty(Class aClass, String property) {
        Exception lastException = null;
        try {
            Field field = aClass.getField(property);
            if (field != null && (field.getModifiers() & 8) != 0) {
                return field.get(null);
            }
        }
        catch (Exception e) {
            lastException = e;
        }
        try {
            MetaMethod method = this.findStaticGetter(aClass, "get" + this.capitalize(property));
            if (method != null) {
                return this.doMethodInvoke(aClass, method, EMPTY_ARRAY);
            }
        }
        catch (GroovyRuntimeException e) {
            throw new MissingPropertyException(property, aClass, e);
        }
        if (lastException == null) {
            throw new MissingPropertyException(property, aClass);
        }
        throw new MissingPropertyException(property, aClass, lastException);
    }

    protected MetaMethod findMethod(Method aMethod) {
        List methods = this.getMethods(aMethod.getName());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (!method.isMethod(aMethod)) continue;
            return method;
        }
        return new ReflectionMetaMethod(aMethod);
    }

    protected MetaMethod findGetter(Object object, String name) {
        List methods = this.getMethods(name);
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    protected MetaMethod findStaticGetter(Class type, String name) {
        List methods = this.getStaticMethods(name);
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (method.getParameterTypes().length != 0) continue;
            return method;
        }
        try {
            Method method = type.getMethod(name, EMPTY_TYPE_ARRAY);
            if ((method.getModifiers() & 8) != 0) {
                return this.findMethod(method);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Object doMethodInvoke(Object object, MetaMethod method, Object[] argumentArray) {
        try {
            if (argumentArray == null) {
                argumentArray = EMPTY_ARRAY;
            } else if (method.getParameterTypes().length == 1 && argumentArray.length == 0) {
                argumentArray = ARRAY_WITH_NULL;
            }
            return method.invoke(object, argumentArray);
        }
        catch (ClassCastException e) {
            if (this.coerceGStrings(argumentArray)) {
                try {
                    return this.doMethodInvoke(object, method, argumentArray);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw new GroovyRuntimeException("failed to invoke method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                Error error = (Error)t;
                throw error;
            }
            if (t instanceof RuntimeException) {
                RuntimeException runtimeEx = (RuntimeException)t;
                throw runtimeEx;
            }
            throw new InvokerInvocationException(e);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException("could not access method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            if (this.coerceGStrings(argumentArray)) {
                try {
                    return this.doMethodInvoke(object, method, argumentArray);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw new GroovyRuntimeException("failed to invoke method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("failed to invoke method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
    }

    protected Object doConstructorInvoke(Constructor constructor, Object[] argumentArray) {
        try {
            return constructor.newInstance(argumentArray);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                Error error = (Error)t;
                throw error;
            }
            if (t instanceof RuntimeException) {
                RuntimeException runtimeEx = (RuntimeException)t;
                throw runtimeEx;
            }
            throw new InvokerInvocationException(e);
        }
        catch (IllegalArgumentException e) {
            if (this.coerceGStrings(argumentArray)) {
                try {
                    return constructor.newInstance(argumentArray);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw new GroovyRuntimeException("failed to invoke constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException("could not access constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("failed to invoke constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
    }

    protected Object chooseMethod(String methodName, List methods, Object[] arguments, boolean coerce) {
        int methodCount = methods.size();
        if (methodCount <= 0) {
            return null;
        }
        if (methodCount == 1) {
            Object method = methods.get(0);
            if (this.isValidMethod(method, arguments, coerce)) {
                return method;
            }
            return null;
        }
        Object answer = null;
        if (arguments == null || arguments.length == 0) {
            answer = this.chooseEmptyMethodParams(methods);
        } else if (arguments.length == 1 && arguments[0] == null) {
            answer = this.chooseMostGeneralMethodWith1Param(methods);
        } else {
            ArrayList matchingMethods = new ArrayList();
            Iterator iter = methods.iterator();
            while (iter.hasNext()) {
                Object method = iter.next();
                if (!this.isValidMethod(method, arguments, coerce)) continue;
                matchingMethods.add(method);
            }
            if (matchingMethods.isEmpty()) {
                return null;
            }
            if (matchingMethods.size() == 1) {
                return matchingMethods.get(0);
            }
            return this.chooseMostSpecificParams(methodName, matchingMethods, arguments);
        }
        if (answer != null) {
            return answer;
        }
        throw new GroovyRuntimeException("Could not find which method to invoke from this list: " + methods + " for arguments: " + InvokerHelper.toString(arguments));
    }

    protected boolean isValidMethod(Object method, Object[] arguments, boolean includeCoerce) {
        Class[] paramTypes = this.getParameterTypes(method);
        return MetaClass.isValidMethod(paramTypes, arguments, includeCoerce);
    }

    protected static boolean isValidMethod(Class[] paramTypes, Object[] arguments, boolean includeCoerce) {
        if (arguments == null) {
            return true;
        }
        int size = arguments.length;
        boolean validMethod = false;
        if (paramTypes.length == size) {
            validMethod = true;
            for (int i = 0; i < size; ++i) {
                Object value = arguments[i];
                if (MetaClass.isCompatibleInstance(paramTypes[i], value, includeCoerce)) continue;
                validMethod = false;
            }
        } else if (paramTypes.length == 1 && size == 0) {
            return true;
        }
        return validMethod;
    }

    protected Object chooseMostSpecificParams(String name, List matchingMethods, Object[] arguments) {
        Object answer = null;
        int size = arguments.length;
        Class[] mostSpecificTypes = null;
        Iterator iter = matchingMethods.iterator();
        while (iter.hasNext()) {
            Object method = iter.next();
            Class[] paramTypes = this.getParameterTypes(method);
            if (answer == null) {
                answer = method;
                mostSpecificTypes = paramTypes;
                continue;
            }
            boolean useThisMethod = false;
            for (int i = 0; i < size; ++i) {
                Class mostSpecificType = mostSpecificTypes[i];
                Class type = paramTypes[i];
                if (this.isAssignableFrom(mostSpecificType, type)) continue;
                useThisMethod = true;
                break;
            }
            if (!useThisMethod) continue;
            if (size > 1) {
                this.checkForInvalidOverloading(name, mostSpecificTypes, paramTypes);
            }
            answer = method;
            mostSpecificTypes = paramTypes;
        }
        return answer;
    }

    protected void checkForInvalidOverloading(String name, Class[] baseTypes, Class[] derivedTypes) {
        int size = baseTypes.length;
        for (int i = 0; i < size; ++i) {
            Class derivedType = derivedTypes[i];
            Class baseType = baseTypes[i];
            if (this.isAssignableFrom(derivedType, baseType)) continue;
            throw new GroovyRuntimeException("Ambiguous method overloading for method: " + name + ". Cannot resolve which method to invoke due to overlapping prototypes between: " + InvokerHelper.toString(baseTypes) + " and: " + InvokerHelper.toString(derivedTypes));
        }
    }

    protected Class[] getParameterTypes(Object methodOrConstructor) {
        if (methodOrConstructor instanceof MetaMethod) {
            MetaMethod method = (MetaMethod)methodOrConstructor;
            return method.getParameterTypes();
        }
        if (methodOrConstructor instanceof Method) {
            Method method = (Method)methodOrConstructor;
            return method.getParameterTypes();
        }
        if (methodOrConstructor instanceof Constructor) {
            Constructor constructor = (Constructor)methodOrConstructor;
            return constructor.getParameterTypes();
        }
        throw new IllegalArgumentException("Must be a Method or Constructor");
    }

    protected Object chooseMostGeneralMethodWith1Param(List methods) {
        Class closestClass = null;
        Object answer = null;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Object method = iter.next();
            Class[] paramTypes = this.getParameterTypes(method);
            int paramLength = paramTypes.length;
            if (paramLength != 1) continue;
            Class theType = paramTypes[0];
            if (closestClass != null && !this.isAssignableFrom(closestClass, theType)) continue;
            closestClass = theType;
            answer = method;
        }
        return answer;
    }

    protected Object chooseEmptyMethodParams(List methods) {
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Object method = iter.next();
            Class[] paramTypes = this.getParameterTypes(method);
            int paramLength = paramTypes.length;
            if (paramLength != 0) continue;
            return method;
        }
        return null;
    }

    protected static boolean isCompatibleInstance(Class type, Object value, boolean includeCoerce) {
        boolean answer;
        boolean bl = answer = value == null || type.isInstance(value);
        if (!answer) {
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    return value instanceof Integer;
                }
                if (type == Double.TYPE) {
                    return value instanceof Double || value instanceof Float || value instanceof Integer;
                }
                if (type == Boolean.TYPE) {
                    return value instanceof Boolean;
                }
                if (type == Long.TYPE) {
                    return value instanceof Long || value instanceof Integer;
                }
                if (type == Float.TYPE) {
                    return value instanceof Float || value instanceof Integer;
                }
                if (type == Character.TYPE) {
                    return value instanceof Character;
                }
                if (type == Byte.TYPE) {
                    return value instanceof Byte;
                }
                if (type == Short.TYPE) {
                    return value instanceof Short;
                }
            } else if (includeCoerce) {
                if (type == String.class && value instanceof GString) {
                    return true;
                }
                if (value instanceof Number) {
                    return Number.class.isAssignableFrom(type);
                }
            }
        }
        return answer;
    }

    protected boolean isAssignableFrom(Class mostSpecificType, Class type) {
        boolean answer = type.isAssignableFrom(mostSpecificType);
        if (!answer) {
            answer = this.autoboxType(type).isAssignableFrom(this.autoboxType(mostSpecificType));
        }
        return answer;
    }

    private Class autoboxType(Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
        }
        return type;
    }

    protected boolean coerceGStrings(Object[] arguments) {
        boolean coerced = false;
        int size = arguments.length;
        for (int i = 0; i < size; ++i) {
            Object argument = arguments[i];
            if (!(argument instanceof GString)) continue;
            arguments[i] = argument.toString();
            coerced = true;
        }
        return coerced;
    }

    protected boolean isGenericSetMethod(MetaMethod method) {
        return (method.getName().equals("set") || method.getName().equals("setAttribute")) && method.getParameterTypes().length == 2;
    }

    protected boolean isGenericGetMethod(MetaMethod method) {
        if (method.getName().equals("get") || method.getName().equals("getAttribute")) {
            Class[] parameterTypes = method.getParameterTypes();
            return parameterTypes.length == 1 && parameterTypes[0] == String.class;
        }
        return false;
    }

    protected void registerStaticMethods() {
        Method[] methods = this.theClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes;
            Method method = methods[i];
            if (!MethodHelper.isStatic(method) || (paramTypes = method.getParameterTypes()).length <= 0) continue;
            Class<?> owner = paramTypes[0];
            this.registry.lookup(owner).addNewStaticInstanceMethod(method);
        }
    }

    protected String capitalize(String property) {
        return property.substring(0, 1).toUpperCase() + property.substring(1, property.length());
    }

    protected synchronized void onMethodChange() {
        this.reflector = null;
    }

    protected synchronized void checkInitialised() {
        if (!this.initialised) {
            this.initialised = true;
            this.addInheritendMethods(this.theClass);
        }
        if (this.reflector == null) {
            this.generateReflector();
        }
    }

    protected MetaMethod createMetaMethod(Method method) {
        if (this.registry.useAccessible()) {
            method.setAccessible(true);
        }
        if (useReflection) {
            return new ReflectionMetaMethod(method);
        }
        MetaMethod answer = new MetaMethod(method);
        if (this.isValidReflectorMethod(answer)) {
            this.allMethods.add(answer);
            answer.setMethodIndex(this.allMethods.size());
        } else {
            answer = new ReflectionMetaMethod(method);
        }
        return answer;
    }

    protected boolean isValidReflectorMethod(MetaMethod method) {
        if (method.isPrivate() || method.isProtected()) {
            return false;
        }
        Class declaringClass = method.getDeclaringClass();
        if (!Modifier.isPublic(declaringClass.getModifiers())) {
            List list = this.getInterfaceMethods();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                MetaMethod aMethod = (MetaMethod)iter.next();
                if (!method.isSame(aMethod)) continue;
                method.setInterfaceClass(aMethod.getDeclaringClass());
                return true;
            }
            return false;
        }
        return true;
    }

    protected void generateReflector() {
        this.reflector = this.loadReflector(this.allMethods);
        if (this.reflector == null) {
            throw new RuntimeException("Should have a reflector!");
        }
        Iterator iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            MetaMethod metaMethod = (MetaMethod)iter.next();
            metaMethod.setReflector(this.reflector);
        }
    }

    protected Reflector loadReflector(List methods) {
        ReflectorGenerator generator = new ReflectorGenerator(methods);
        String className = this.theClass.getName();
        String packagePrefix = "gjdk.";
        String name = packagePrefix + className + "_GroovyReflector";
        if (this.theClass.isArray()) {
            String componentName = this.theClass.getComponentType().getName();
            name = packagePrefix + componentName + "_GroovyReflectorArray";
        }
        try {
            Class type = this.loadReflectorClass(name);
            return (Reflector)type.newInstance();
        }
        catch (Exception e) {
            ClassWriter cw = new ClassWriter(true);
            generator.generate((ClassVisitor)cw, name);
            byte[] bytecode = cw.toByteArray();
            try {
                Class type = this.loadReflectorClass(name, bytecode);
                return (Reflector)type.newInstance();
            }
            catch (Exception e2) {
                throw new GroovyRuntimeException("Could not load the reflector for class: " + name + ". Reason: " + e2, e2);
            }
        }
    }

    protected Class loadReflectorClass(String name, byte[] bytecode) throws ClassNotFoundException {
        ClassLoader loader = this.theClass.getClassLoader();
        if (loader instanceof GroovyClassLoader) {
            GroovyClassLoader gloader = (GroovyClassLoader)loader;
            return gloader.loadClass(name, bytecode);
        }
        return this.registry.loadClass(name, bytecode);
    }

    protected Class loadReflectorClass(String name) throws ClassNotFoundException {
        ClassLoader loader = this.theClass.getClassLoader();
        if (loader instanceof GroovyClassLoader) {
            GroovyClassLoader gloader = (GroovyClassLoader)loader;
            return gloader.loadClass(name);
        }
        return this.registry.loadClass(name);
    }

    public List getMethods() {
        return this.allMethods;
    }

    protected synchronized List getInterfaceMethods() {
        if (this.interfaceMethods == null) {
            this.interfaceMethods = new ArrayList();
            for (Class type = this.theClass; type != null; type = type.getSuperclass()) {
                Class<?>[] interfaces = type.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> iface = interfaces[i];
                    Method[] methods = iface.getMethods();
                    this.addInterfaceMethods(this.interfaceMethods, methods);
                }
            }
        }
        return this.interfaceMethods;
    }

    private void addInterfaceMethods(List list, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            list.add(this.createMetaMethod(methods[i]));
        }
    }
}

