/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.codehaus.groovy.syntax.lexer.CharStream;
import org.codehaus.groovy.syntax.lexer.FileCharStream;
import org.codehaus.groovy.tools.Compiler;
import org.codehaus.groovy.tools.ErrorReporter;
import org.codehaus.groovy.tools.GroovyClass;

public class FileSystemCompiler {
    private Compiler compiler = new Compiler();
    private File outputDir;

    public void setVerbose(boolean verbose) {
        this.compiler.setVerbose(verbose);
    }

    protected Compiler getCompiler() {
        return this.compiler;
    }

    public void setOutputDir(String outputDir) {
        this.setOutputDir(new File(outputDir));
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setClasspath(String classpath) throws Exception {
        this.getCompiler().setClasspath(classpath);
    }

    public void compile(String[] paths) throws Exception {
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(paths[i]);
        }
        this.compile(files);
    }

    public void compile(File[] files) throws Exception {
        CharStream[] fileCharStreams = new FileCharStream[files.length];
        for (int i = 0; i < fileCharStreams.length; ++i) {
            fileCharStreams[i] = new FileCharStream(files[i]);
        }
        GroovyClass[] classes = this.getCompiler().compile(fileCharStreams);
        for (int i = 0; i < classes.length; ++i) {
            this.dumpClassFile(classes[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpClassFile(GroovyClass groovyClass) throws IOException {
        byte[] bytes = groovyClass.getBytes();
        File outputFile = this.createOutputFile(groovyClass.getName());
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            outputStream.write(bytes, 0, bytes.length);
        }
        finally {
            outputStream.close();
        }
    }

    protected File createOutputFile(String className) {
        String path = className.replace('.', File.separatorChar) + ".class";
        return new File(this.getOutputDir(), path);
    }

    public static void displayHelp() {
        System.err.println("Usage: groovy <options> <source files>");
        System.err.println("where possible options include: ");
        System.err.println("  --classpath <path>        Specify where to find user class files");
        System.err.println("  -d <directory>            Specify where to place generated class files");
        System.err.println("  --strict                  Turn on strict type safety");
        System.err.println("  --version                 Print the verion");
        System.err.println("  --help                    Print a synopsis of standard options");
        System.err.println("  --exception               Print stack trace on error");
        System.err.println("");
    }

    public static void displayVersion() {
        System.err.println("groovy compiler version 1.0-alpha-1");
        System.err.println("Copyright 2003 The Codehaus. http://groovy.codehaus.org/");
        System.err.println("");
    }

    public static int checkFiles(String[] filenames) {
        int errors = 0;
        for (int i = 0; i < filenames.length; ++i) {
            File file = new File(filenames[i]);
            if (!file.exists()) {
                System.err.println("error: file not found: " + file);
                ++errors;
                continue;
            }
            if (file.canRead()) continue;
            System.err.println("error: file not readable: " + file);
            ++errors;
        }
        return errors;
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"classpath");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"classpath");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"sourcepath");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"sourcepath");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"strict");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"exception");
        options.addOption(OptionBuilder.create((char)'e'));
        PosixParser cliParser = new PosixParser();
        CommandLine cli = cliParser.parse(options, args);
        if (cli.hasOption('h')) {
            FileSystemCompiler.displayHelp();
            return;
        }
        if (cli.hasOption('v')) {
            FileSystemCompiler.displayVersion();
        }
        FileSystemCompiler compiler = new FileSystemCompiler();
        if (cli.hasOption("classpath")) {
            compiler.getCompiler().setClasspath(cli.getOptionValue("classpath"));
        } else {
            compiler.getCompiler().setClasspath(System.getProperty("java.class.path"));
        }
        if (cli.hasOption('d')) {
            compiler.setOutputDir(cli.getOptionValue('d'));
        } else {
            compiler.setOutputDir(System.getProperty("user.dir"));
        }
        String[] filenames = cli.getArgs();
        if (filenames.length == 0) {
            FileSystemCompiler.displayHelp();
            return;
        }
        int errors = FileSystemCompiler.checkFiles(filenames);
        if (errors == 0) {
            try {
                compiler.compile(filenames);
            }
            catch (Throwable e) {
                new ErrorReporter(e, cli.hasOption('e')).write(System.err);
            }
        }
    }
}

