/*
 * Decompiled with CFR 0.152.
 */
package javancss.test;

import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javancss.Javancss;
import javancss.JavancssConstants;
import javancss.PackageMetric;
import javancss.test.XmlFormatterTest;

public class JavancssTest
extends Test
implements JavancssConstants {
    private String _sTestDir = null;

    private void _doNcssTest(int testNumber, int expectedNcss) {
        Javancss pJavancss = new Javancss(FileUtil.concatPath(this._sTestDir, "Test" + testNumber + ".java"));
        int ncss = pJavancss.getNcss();
        this.bugIf(ncss != expectedNcss, "Parsing file Test" + testNumber + ".java failed. Ncss is " + ncss + " and not " + expectedNcss + ".");
    }

    private void _doNcssTest(int testNumber) {
        Javancss pJavancss = new Javancss(FileUtil.concatPath(this._sTestDir, "Test" + testNumber + ".java"));
        int ncss = pJavancss.getNcss();
        this.bugIf(ncss == 0, "Parsing file Test" + testNumber + ".java failed. Ncss is 0");
    }

    private void _checkJavadocs() {
        Javancss pJavancss = new Javancss(FileUtil.concatPath(this._sTestDir, "Test20.java"));
        Vector vObjectMetrics = pJavancss.getObjectMetrics();
        Vector vClassMetrics = (Vector)vObjectMetrics.elementAt(0);
        int jvdcs = (Integer)vClassMetrics.elementAt(6);
        this.assert(jvdcs == 7, "Expected 7 Javadocs in in file Test20.java but got " + jvdcs + "!");
    }

    private void _checkJavadocLines() {
        this._checkJavadocLines(FileUtil.concatPath(this._sTestDir, "Test28.java"), "jacob", 0);
        Vector<String> vArgs = new Vector<String>();
        vArgs.addElement(FileUtil.concatPath(this._sTestDir, "Test20.java"));
        vArgs.addElement(FileUtil.concatPath(this._sTestDir, "Test21.java"));
        vArgs.addElement(FileUtil.concatPath(this._sTestDir, "Test28.java"));
        this._checkJavadocLines(vArgs, "jacob", 0);
        this._checkJavadocLines(68, ".", 6);
        this._checkJavadocLines(69, ".", 4);
        this._checkJavadocLines(new int[]{68, 69}, ".", 10);
        this._checkJavadocLines(65, "idebughc.testsuite", 14);
    }

    private void _checkJavadocLines(Vector vJavaSources, String sPackage, int javadocLines) {
        Javancss pJavancss = new Javancss(vJavaSources);
        this._checkJavadocLines(pJavancss, sPackage, javadocLines);
    }

    private void _checkJavadocLines(String sJavaSource, String sPackage, int javadocLines) {
        Javancss pJavancss = new Javancss(sJavaSource);
        this._checkJavadocLines(pJavancss, sPackage, javadocLines);
    }

    private void _checkJavadocLines(int testFile, String sPackage, int javadocLines) {
        String sSourceFile = FileUtil.concatPath(this._sTestDir, "Test" + testFile + ".java");
        this._checkJavadocLines(sSourceFile, sPackage, javadocLines);
    }

    private void _checkJavadocLines(int[] aTestFile, String sPackage, int javadocLines) {
        Vector<String> vArgs = new Vector<String>();
        int i = 0;
        while (i < aTestFile.length) {
            int next = aTestFile[i];
            String sSourceFile = FileUtil.concatPath(this._sTestDir, "Test" + next + ".java");
            vArgs.addElement(sSourceFile);
            ++i;
        }
        this._checkJavadocLines(vArgs, sPackage, javadocLines);
    }

    private void _checkJavadocLines(Javancss pJavancss, String sPackage, int javadocLines) {
        Vector vPackageMetrics = pJavancss.getPackageMetrics();
        this.assert(vPackageMetrics.size() >= 1);
        PackageMetric pmPackage = null;
        Enumeration ePackageMetrics = vPackageMetrics.elements();
        while (ePackageMetrics.hasMoreElements()) {
            PackageMetric pmNext = (PackageMetric)ePackageMetrics.nextElement();
            if (!pmNext.name.equals(sPackage)) continue;
            pmPackage = pmNext;
        }
        this.assert(pmPackage != null);
        this.assert(pmPackage.javadocsLn == javadocLines, "pmJacob.javadocsLn: " + pmPackage + ": " + pmPackage.javadocsLn);
    }

    private void _checkInnerClasses() {
        this._doNcssTest(70, 4);
    }

    public JavancssTest() {
    }

    public JavancssTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        String sLocalPath = this._sTestDir;
        Util.debug(this, "_doIt()._sTestDir: " + this._sTestDir);
        boolean bSkip = false;
        Javancss pJavancss = null;
        if (!bSkip) {
            String[] asArg;
            this._checkInnerClasses();
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test1.java"));
            int ncss1 = pJavancss.getNcss();
            this.bugIf(ncss1 != 318, "Ncss: " + ncss1);
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test2.java"));
            this.bugIf(pJavancss.getNcss() != 8);
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test3.java"));
            this.bugIf(pJavancss.getNcss() != 69);
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test4.java"));
            this.bugIf(pJavancss.getNcss() != 11);
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test5.java"));
            this.bugIf(pJavancss.getNcss() != 16);
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test6.java"));
            int ncss6 = pJavancss.getNcss();
            this.bugIf(ncss6 != 565, "Ncss: " + ncss6);
            this.bugIf(pJavancss.getLOC() != 1254, "LOC: " + pJavancss.getLOC());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test7.java"));
            this.bugIf(pJavancss.getNcss() != 30, "Ncss: " + pJavancss.getNcss());
            Javancss pJavancss8 = new Javancss(FileUtil.concatPath(sLocalPath, "Test8.java"));
            this.bugIf(pJavancss.getNcss() != pJavancss8.getNcss());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test9.java"));
            this.bugIf(ncss1 != pJavancss.getLOC(), "LOC: " + pJavancss.getLOC());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test10.java"));
            this.bugIf(pJavancss.getLOC() != ncss6, "LOC: " + pJavancss.getLOC());
            this.bugIf(pJavancss.getLOC() != pJavancss.getNcss(), "NCSS: " + pJavancss.getNcss());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test11.java"));
            this.bugIf(pJavancss.getLOC() != pJavancss.getNcss(), "NCSS: " + pJavancss.getNcss() + ", LOC: " + pJavancss.getLOC());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test12.java"));
            this.bugIf(pJavancss.getLOC() != pJavancss.getNcss(), "NCSS: " + pJavancss.getNcss() + ", LOC: " + pJavancss.getLOC());
            Vector vFunctions = pJavancss.getFunctionMetrics();
            String sFirstFunction = (String)((Vector)vFunctions.elementAt(0)).elementAt(0);
            this.bugIf(!sFirstFunction.equals("Test12.readFile(URL)"));
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test13.java"));
            this.bugIf(pJavancss.getLOC() != pJavancss.getNcss(), "NCSS: " + pJavancss.getNcss() + ", LOC: " + pJavancss.getLOC());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test14.java"));
            this.bugIf(pJavancss.getLOC() != pJavancss.getNcss(), "NCSS: " + pJavancss.getNcss() + ", LOC: " + pJavancss.getLOC());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test15.java"));
            this.bugIf(pJavancss.getLOC() != pJavancss.getNcss(), "NCSS: " + pJavancss.getNcss() + ", LOC: " + pJavancss.getLOC());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test16.java"));
            this.bugIf(pJavancss.getNcss() != 4);
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test17.java"));
            this.bugIf(pJavancss.getLOC() != pJavancss.getNcss(), "NCSS: " + pJavancss.getNcss() + ", LOC: " + pJavancss.getLOC());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test18.java"));
            this.bugIf(pJavancss.getLOC() != pJavancss.getNcss(), "NCSS: " + pJavancss.getNcss() + ", LOC: " + pJavancss.getLOC());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test19.java"));
            vFunctions = pJavancss.getFunctionMetrics();
            sFirstFunction = (String)((Vector)vFunctions.elementAt(0)).elementAt(0);
            this.bugIf(!sFirstFunction.equals("test.Test19.foo(String[],Controller)"));
            sFirstFunction = (String)((Vector)vFunctions.elementAt(3)).elementAt(0);
            this.bugIf(!sFirstFunction.equals("test.Test19.main(String[])"));
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test20.java"));
            this.bugIf(pJavancss.getNcss() != 46, "NCSS: " + pJavancss.getNcss());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test21.java"));
            this.bugIf(pJavancss.getNcss() != 67, "NCSS: " + pJavancss.getNcss());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test22.java"));
            this.bugIf(pJavancss.getNcss() != 283, "NCSS: " + pJavancss.getNcss());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test23.java"));
            this.bugIf(pJavancss.getNcss() != 10, "NCSS: " + pJavancss.getNcss());
            vFunctions = pJavancss.getFunctionMetrics();
            this.bugIf(vFunctions.size() != 7);
            this.bugIf(new Javancss(FileUtil.concatPath(sLocalPath, "Test24.java")).getFunctionMetrics().size() != vFunctions.size());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test25.java"));
            this.bugIf(pJavancss.getNcss() != 12);
            this.bugIf(pJavancss.getFunctionMetrics().size() != 9);
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test26.java"));
            this.bugIf(pJavancss.getNcss() != 47, "NCSS: " + pJavancss.getNcss());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test27.java"));
            this.bugIf(pJavancss.getNcss() != 4, "NCSS: " + pJavancss.getNcss());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test28.java"));
            this.bugIf(pJavancss.getNcss() != 465, "NCSS: " + pJavancss.getNcss());
            String sTest11 = "";
            String sTest12 = "";
            try {
                sTest11 = FileUtil.readFile(FileUtil.concatPath(sLocalPath, "Test11.java"));
                sTest12 = FileUtil.readFile(FileUtil.concatPath(sLocalPath, "Test12.java"));
                this.bugIf(false);
            }
            catch (Exception e) {
                this.bugIf(true);
            }
            String sTogether = sTest11 + sTest12;
            pJavancss = new Javancss(new StringBufferInputStream(sTogether));
            vFunctions = pJavancss.getFunctionMetrics();
            Util.debug("JavancssTest._doIt().vFunctions: " + vFunctions);
            sFirstFunction = (String)((Vector)vFunctions.elementAt(0)).elementAt(0);
            this.bugIf(!sFirstFunction.equals("ccl.util.Test11.atoi(String)"));
            String sSomeFunction = (String)((Vector)vFunctions.elementAt(32)).elementAt(0);
            this.bugIf(!sSomeFunction.equals("Test12.readFile(URL)"), "Function: " + sSomeFunction);
            Vector vPackages = pJavancss.getPackageMetrics();
            this.bugIf(vPackages.size() != 2);
            asArg = new String[]{FileUtil.concatPath(sLocalPath, "Test11.java"), asArg[0], FileUtil.concatPath(sLocalPath, "Test12.java")};
            int ncss38 = pJavancss.getNcss();
            PrintStream psStdout = System.out;
            System.setOut(new PrintStream(new ByteArrayOutputStream()));
            pJavancss = new Javancss(asArg, "$Header: /home/clemens/src/java/javancss/src/javancss/test/RCS/JavancssTest.java,v 1.26 2002/05/11 10:38:59 clemens Exp clemens $");
            System.setOut(psStdout);
            vPackages = pJavancss.getPackageMetrics();
            this.bugIf(vPackages.size() != 2);
            this.bugIf(ncss38 == pJavancss.getNcss());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test29.java"));
            this.bugIf(pJavancss.getNcss() != 1, "NCSS: " + pJavancss.getNcss());
            try {
                pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test35.java"));
                this.bugIf(pJavancss.getNcss() != 1);
            }
            catch (Exception eEOF) {
                this.bugIf(true, "}<EOF>");
            }
            try {
                pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test36.java"));
                this.bugIf(pJavancss.getNcss() != 1);
            }
            catch (Error eEOF) {
                this.bugIf(true, "//<EOF>");
            }
            try {
                pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test37.java"));
                this.bugIf(pJavancss.getNcss() != 1);
            }
            catch (Error eCTRLZ) {
                this.bugIf(true, "//ctrl-Z");
            }
            try {
                pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test38.java"));
                this.bugIf(pJavancss.getNcss() != 1);
            }
            catch (Error eCTRLZ) {
                this.bugIf(true, "0x0actrl-Z");
            }
            try {
                pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test39.java"));
                this.bugIf(pJavancss.getNcss() != 5);
            }
            catch (Error eEmptyStatements) {
                this.bugIf(true, "Empty statments.");
            }
            try {
                pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test32.java"));
                this.bugIf(pJavancss.getNcss() != 26, "Test32.java: ncss should be 26 but is: " + pJavancss.getNcss());
            }
            catch (Error eJavaSQLConnection) {
                this.bugIf(true, "java.sql.Connection double semicolon");
            }
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test40.java"));
            vFunctions = pJavancss.getFunctionMetrics();
            this.bugIf(vFunctions.size() != 1);
            int ccn = (Integer)((Vector)vFunctions.elementAt(0)).elementAt(2);
            this.bugIf(ccn != 3, "CCN in constructor of Test40 should be 3, it is: " + ccn);
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test41.java"));
            vFunctions = pJavancss.getFunctionMetrics();
            ccn = (Integer)((Vector)vFunctions.elementAt(0)).elementAt(2);
            this.bugIf(ccn != 3, "CCN in constructor of Test41 should be 3, it is: " + ccn);
            ccn = (Integer)((Vector)vFunctions.elementAt(1)).elementAt(2);
            this.bugIf(ccn != 1, "CCN in constructor of Test41 should be 1, it is: " + ccn);
            ccn = (Integer)((Vector)vFunctions.elementAt(2)).elementAt(2);
            this.bugIf(ccn != 3, "CCN in constructor of Test41 should be 3, it is: " + ccn);
            ccn = (Integer)((Vector)vFunctions.elementAt(3)).elementAt(2);
            this.bugIf(ccn != 3, "CCN in constructor of Test41 should be 3, it is: " + ccn);
            ccn = (Integer)((Vector)vFunctions.elementAt(4)).elementAt(2);
            this.bugIf(ccn != 1, "CCN in constructor of Test41 should be 1, it is: " + ccn);
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test42.java"));
            this.bugIf(pJavancss.getLastErrorMessage() == null, "Test42 should be parsed *and* result in an exception.");
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test43.java"));
            this.bugIf(pJavancss.getNcss() != 0);
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test1.java"));
            int ncss57 = pJavancss.getNcss();
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test2.java"));
            ncss57 += pJavancss.getNcss();
            Vector<String> vFiles = new Vector<String>();
            vFiles.addElement(FileUtil.concatPath(sLocalPath, "Test1.java"));
            vFiles.addElement(FileUtil.concatPath(sLocalPath, "Test42.java"));
            vFiles.addElement(FileUtil.concatPath(sLocalPath, "Test2.java"));
            pJavancss = new Javancss(vFiles);
            this.bugIf(pJavancss.getNcss() != ncss57, "ncss57: " + ncss57 + " pJavancss.getNcss(): " + pJavancss.getNcss());
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test48.java"));
            this.bugIf(pJavancss.getNcss() <= 0, "Parsing file Test48.java failed!");
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test49.java"));
            this.bugIf(pJavancss.getNcss() != 3, "Parsing file Test49.java failed!");
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test50.java"));
            this.bugIf(pJavancss.getNcss() <= 0, "Parsing file Test50.java failed!");
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test51.java"));
            this.bugIf(pJavancss.getNcss() != 8, "Parsing file Test51.java failed!");
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test52.java"));
            int test52ncss = pJavancss.getNcss();
            this.bugIf(test52ncss != 12, "Parsing file Test52.java failed. Ncss is " + test52ncss + " and not 12.");
            pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test53.java"));
            int test53ncss = pJavancss.getNcss();
            this.bugIf(test53ncss != 4, "Parsing file Test53.java failed. Ncss is " + test53ncss + " and not 4.");
            this._doNcssTest(54, 9);
            this._doNcssTest(55, 5);
            this._doNcssTest(56);
            this._doNcssTest(57);
        }
        pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test56.java"));
        String sOutput56 = pJavancss.printPackageNcss();
        sOutput56 = sOutput56 + "\n";
        sOutput56 = sOutput56 + pJavancss.printObjectNcss();
        sOutput56 = sOutput56 + "\n";
        sOutput56 = sOutput56 + pJavancss.printFunctionNcss();
        sOutput56 = Util.replace(sOutput56, "\r\n", "\n");
        String sCompare56 = FileUtil.readFile(FileUtil.concatPath(sLocalPath, "Output56.txt"));
        this.assert(sOutput56.equals(sCompare56), "File test/Output56.txt and javancss output differs:\n" + sOutput56);
        XmlFormatterTest xmlTest = new XmlFormatterTest(this);
        xmlTest.setTestDir(this._sTestDir);
        xmlTest.run();
        this.setTests(xmlTest);
        this._doNcssTest(58, 37);
        this._doNcssTest(59, 122);
        this._doNcssTest(60, 35);
        this._doNcssTest(61, 203);
        this._doNcssTest(62, 616);
        this._doNcssTest(63, 330);
        this._doNcssTest(64, 70);
        this._doNcssTest(65, 301);
        this._doNcssTest(66, 3);
        this._doNcssTest(67, 31);
        pJavancss = new Javancss(FileUtil.concatPath(sLocalPath, "Test32.java"));
        String sOutput32 = pJavancss.printPackageNcss();
        sOutput32 = sOutput32 + "\n";
        sOutput32 = sOutput32 + pJavancss.printObjectNcss();
        sOutput32 = sOutput32 + "\n";
        sOutput32 = sOutput32 + pJavancss.printFunctionNcss();
        sOutput32 = Util.replace(sOutput32, "\r\n", "\n");
        String sCompare32 = FileUtil.readFile(FileUtil.concatPath(sLocalPath, "Output32.txt"));
        this.assert(sOutput32.equals(sCompare32), "File test/Output32.txt and javancss output differs:\n" + sOutput32);
        this._doNcssTest(68, 3);
        pJavancss = new Javancss(FileUtil.concatPath(this._sTestDir, "Test68.java"));
        Vector vObjectMetrics = pJavancss.getObjectMetrics();
        Vector vClassMetrics = (Vector)vObjectMetrics.elementAt(0);
        int jvdcs = (Integer)vClassMetrics.elementAt(6);
        int jvdc = pJavancss.getJvdc();
        this.bugIf(jvdcs != 2, "Parsing file Test68.java failed. Jvdc is " + jvdcs + " and not 2.");
        this._checkJavadocs();
        this._doNcssTest(69, 1);
    }

    public void setTestDir(String sTestDir_) {
        this._sTestDir = sTestDir_;
    }
}

