/*
 * Decompiled with CFR 0.152.
 */
package ccl.servlet;

import ccl.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.servlet.http.HttpServletResponse;

public class CSV {
    private PrintWriter _out = null;
    private boolean _bFirstColumn = true;

    public CSV(HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        this._out = response.getWriter();
        this._bFirstColumn = true;
    }

    public void endLine() {
        this._out.print("\n");
        this._bFirstColumn = true;
    }

    public void printValue(String value) {
        if (!this._bFirstColumn) {
            this._out.print("\t");
        }
        this._out.print(Util.replace(value, "\t", " "));
        this._bFirstColumn = false;
    }

    public void close() {
        this._out.close();
    }

    private static String untabify(String s) {
        return Util.replace(s, "\t", " ");
    }

    public static void exportCSV(HttpServletResponse response, ResultSet result) throws IOException, SQLException {
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        ResultSetMetaData metaData = result.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        int column = 1;
        while (column <= numberOfColumns) {
            String sColumnName = metaData.getColumnName(column);
            if (column > 1) {
                out.print("\t");
            }
            out.print(CSV.untabify(sColumnName));
            ++column;
        }
        out.println();
        while (result.next()) {
            int column2 = 1;
            while (column2 <= numberOfColumns) {
                Object oValue = result.getObject(column2);
                if (oValue == null) {
                    oValue = "";
                }
                String sValue = CSV.untabify(String.valueOf(oValue).trim());
                if (column2 > 1) {
                    out.print("\t");
                }
                out.print(sValue);
                ++column2;
            }
            out.println();
        }
    }
}

