/*
 * Decompiled with CFR 0.152.
 */
package ccl.servlet;

import ccl.util.DBUtil;
import ccl.util.Util;
import java.io.BufferedReader;
import java.io.FileReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLImportHandler
extends DefaultHandler {
    private static final String S_PARSER = "org.apache.xerces.parsers.SAXParser";
    static final String S_TAG_COLUMN = "column";
    static final String S_TAG_COLUMNS = "columns";
    static final String S_TAG_DATABASE = "database";
    static final String S_TAG_ROW = "row";
    static final String S_TAG_ROWS = "rows";
    static final String S_TAG_TABLE = "table";
    static final String S_TAG_VALUE = "value";
    private StringBuffer _sbCDATA = new StringBuffer();
    private Connection _connection = null;
    private String _sTableName = null;
    private Vector _vColumns = null;
    private Vector _vValues = null;
    private PreparedStatement _statement = null;
    private Vector _vTypes = null;

    public XMLImportHandler(Connection connection) {
        this._connection = connection;
    }

    public void characters(char[] ac_, int start_, int length_) {
        this._sbCDATA.append(ac_, start_, length_);
    }

    public void startElement(String namespaceURI_, String localName_, String qName_, Attributes atts_) {
        if (qName_.equals(S_TAG_TABLE)) {
            this._sTableName = atts_.getValue("name");
            try {
                DBUtil.deleteTable(this._connection, this._sTableName);
            }
            catch (SQLException sqlException) {
                Util.printlnErr(sqlException);
            }
        }
        if (qName_.equals(S_TAG_COLUMNS)) {
            this._vColumns = new Vector();
        }
        if (qName_.equals(S_TAG_ROW)) {
            this._vValues = new Vector();
        }
        this._sbCDATA.setLength(0);
    }

    public void endElement(String namespaceURI_, String localName_, String qName_) {
        if (localName_.equals(S_TAG_COLUMN)) {
            this._vColumns.addElement(this._sbCDATA.toString());
        } else if (localName_.equals(S_TAG_COLUMNS)) {
            String sInsert = "insert into " + this._sTableName + " (";
            String sQuestionMarks = "";
            Enumeration eColumns = this._vColumns.elements();
            while (eColumns.hasMoreElements()) {
                sInsert = sInsert + (String)eColumns.nextElement();
                sQuestionMarks = sQuestionMarks + "?";
                if (!eColumns.hasMoreElements()) continue;
                sInsert = sInsert + ",";
                sQuestionMarks = sQuestionMarks + ",";
            }
            sInsert = sInsert + ") values (" + sQuestionMarks + ")";
            Util.debug(this, "endElement(..).Empty insert call: " + sInsert);
            try {
                this._statement = this._connection.prepareStatement(sInsert);
                Util.debug(this, "endElement(..)._statement: " + this._statement);
                DatabaseMetaData meta = this._connection.getMetaData();
                Util.debug(this, "endElement(..).table: " + this._sTableName);
                ResultSet result = meta.getColumns(null, null, this._sTableName.toLowerCase(), null);
                this._vTypes = new Vector();
                int column = 0;
                Util.debug(this, "endElement(..).GET_TYPES");
                while (result.next()) {
                    String sXMLColumn = (String)this._vColumns.elementAt(column);
                    String sName = result.getString(4);
                    Util.debug(this, "endElement(..).sName: " + sName);
                    if (!sXMLColumn.equals(sName)) {
                        Util.printlnErr("Xml column '" + sXMLColumn + "' in table '" + this._sTableName + "' does not match real column '" + sName + "' in the database!");
                    }
                    this._vTypes.addElement(result.getString(6));
                    ++column;
                }
                result.close();
            }
            catch (SQLException sqlException) {
                Util.printlnErr(sqlException);
            }
        } else if (!localName_.equals(S_TAG_DATABASE)) {
            if (localName_.equals(S_TAG_ROW)) {
                try {
                    if (this._statement == null) {
                        Util.debug(this, "endElement(..)._statement is indeed null!");
                    }
                    Enumeration eValues = this._vValues.elements();
                    Enumeration eTypes = this._vTypes.elements();
                    int index = 1;
                    while (eValues.hasMoreElements()) {
                        String sType = (String)eTypes.nextElement();
                        String sValue = (String)eValues.nextElement();
                        Util.debug(this, "endElement(..).type: --->" + sType + "<---");
                        if (sType.equals("int")) {
                            this._statement.setInt(index, Util.atoi(sValue));
                        } else if (sType.equals("double precis")) {
                            this._statement.setDouble(index, Util.atod(sValue));
                        } else if (sType.equals("numeric")) {
                            this._statement.setBigDecimal(index, BigDecimal.valueOf(Util.atol(sValue)));
                        } else {
                            this._statement.setString(index, sValue);
                        }
                        ++index;
                    }
                    this._statement.executeUpdate();
                }
                catch (SQLException sqlException) {
                    Util.printlnErr(sqlException);
                }
                catch (Exception exception) {
                    Util.printlnErr(exception);
                }
            } else if (!localName_.equals(S_TAG_ROWS) && !localName_.equals(S_TAG_TABLE) && localName_.equals(S_TAG_VALUE)) {
                this._vValues.addElement(this._sbCDATA.toString());
            }
        }
    }

    public static void parse(Connection connection_, String sFileName_) throws Exception {
        ((Hashtable)System.getProperties()).put("org.xml.sax.driver", S_PARSER);
        XMLImportHandler xmlimporthandler = new XMLImportHandler(connection_);
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(xmlimporthandler);
        reader.setErrorHandler(xmlimporthandler);
        InputSource pInputSource = new InputSource(new BufferedReader(new FileReader(sFileName_)));
        reader.parse(pInputSource);
    }
}

